/*
 * Decompiled with CFR 0.152.
 */
package org.entur.avro.realtime.siri.converter.jaxb2avro;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.entur.avro.realtime.siri.converter.jaxb2avro.Jaxb2AvroEnumConverter;
import org.entur.avro.realtime.siri.model.AlightingActivityEnum;
import org.entur.avro.realtime.siri.model.BoardingActivityEnum;
import org.entur.avro.realtime.siri.model.CallStatusEnum;
import org.entur.avro.realtime.siri.model.EstimatedCallRecord;
import org.entur.avro.realtime.siri.model.EstimatedJourneyVersionFrameRecord;
import org.entur.avro.realtime.siri.model.EstimatedTimetableDeliveryRecord;
import org.entur.avro.realtime.siri.model.EstimatedVehicleJourneyRecord;
import org.entur.avro.realtime.siri.model.FramedVehicleJourneyRefRecord;
import org.entur.avro.realtime.siri.model.OccupancyEnum;
import org.entur.avro.realtime.siri.model.PassengerCapacityRecord;
import org.entur.avro.realtime.siri.model.RecordedCallRecord;
import org.entur.avro.realtime.siri.model.StopAssignmentRecord;
import org.entur.avro.realtime.siri.model.VehicleOccupancyRecord;
import org.w3c.dom.Element;
import uk.org.siri.siri21.ArrivalBoardingActivityEnumeration;
import uk.org.siri.siri21.CallStatusEnumeration;
import uk.org.siri.siri21.DepartureBoardingActivityEnumeration;
import uk.org.siri.siri21.EstimatedCall;
import uk.org.siri.siri21.EstimatedTimetableDeliveryStructure;
import uk.org.siri.siri21.EstimatedVehicleJourney;
import uk.org.siri.siri21.EstimatedVersionFrameStructure;
import uk.org.siri.siri21.Extensions;
import uk.org.siri.siri21.FramedVehicleJourneyRefStructure;
import uk.org.siri.siri21.PassengerCapacityStructure;
import uk.org.siri.siri21.RecordedCall;
import uk.org.siri.siri21.StopAssignmentStructure;
import uk.org.siri.siri21.VehicleOccupancyStructure;

public class EstimatedTimetableDeliveryConverter
extends Jaxb2AvroEnumConverter {
    static List<EstimatedTimetableDeliveryRecord> convert(List<EstimatedTimetableDeliveryStructure> estimatedTimetableDeliveries) {
        if (EstimatedTimetableDeliveryConverter.isNullOrEmpty(estimatedTimetableDeliveries)) {
            return Collections.emptyList();
        }
        ArrayList<EstimatedTimetableDeliveryRecord> records = new ArrayList<EstimatedTimetableDeliveryRecord>();
        for (EstimatedTimetableDeliveryStructure delivery : estimatedTimetableDeliveries) {
            ArrayList<EstimatedJourneyVersionFrameRecord> estimatedJourneyVersionFrames = new ArrayList<EstimatedJourneyVersionFrameRecord>();
            for (EstimatedVersionFrameStructure versionFrame : delivery.getEstimatedJourneyVersionFrames()) {
                estimatedJourneyVersionFrames.add(EstimatedJourneyVersionFrameRecord.newBuilder().setRecordedAtTime(EstimatedTimetableDeliveryConverter.convert(versionFrame.getRecordedAtTime())).setEstimatedVehicleJourneys(EstimatedTimetableDeliveryConverter.convertJourneys(versionFrame.getEstimatedVehicleJourneies())).build());
            }
            records.add(EstimatedTimetableDeliveryRecord.newBuilder().setVersion((CharSequence)delivery.getVersion()).setResponseTimestamp(EstimatedTimetableDeliveryConverter.convert(delivery.getResponseTimestamp())).setEstimatedJourneyVersionFrames(estimatedJourneyVersionFrames).build());
        }
        return records;
    }

    static List<EstimatedVehicleJourneyRecord> convertJourneys(List<EstimatedVehicleJourney> estimatedVehicleJourneys) {
        if (estimatedVehicleJourneys == null) {
            return Collections.emptyList();
        }
        ArrayList<EstimatedVehicleJourneyRecord> records = new ArrayList<EstimatedVehicleJourneyRecord>();
        for (EstimatedVehicleJourney estimatedVehicleJourney : estimatedVehicleJourneys) {
            records.add(EstimatedTimetableDeliveryConverter.convert(estimatedVehicleJourney));
        }
        return records;
    }

    static EstimatedVehicleJourneyRecord convert(EstimatedVehicleJourney estimatedVehicleJourney) {
        return EstimatedVehicleJourneyRecord.newBuilder().setRecordedAtTime(EstimatedTimetableDeliveryConverter.convert(estimatedVehicleJourney.getRecordedAtTime())).setLineRef(EstimatedTimetableDeliveryConverter.getValue(estimatedVehicleJourney.getLineRef())).setCancellation(estimatedVehicleJourney.isCancellation()).setExtraJourney(estimatedVehicleJourney.isExtraJourney()).setPredictionInaccurate(estimatedVehicleJourney.isPredictionInaccurate()).setDirectionRef(EstimatedTimetableDeliveryConverter.getValue(estimatedVehicleJourney.getDirectionRef())).setDatedVehicleJourneyRef(EstimatedTimetableDeliveryConverter.getValue(estimatedVehicleJourney.getDatedVehicleJourneyRef())).setFramedVehicleJourneyRef(EstimatedTimetableDeliveryConverter.convert(estimatedVehicleJourney.getFramedVehicleJourneyRef())).setEstimatedVehicleJourneyCode((CharSequence)estimatedVehicleJourney.getEstimatedVehicleJourneyCode()).setJourneyPatternRef(EstimatedTimetableDeliveryConverter.getValue(estimatedVehicleJourney.getJourneyPatternRef())).setRouteRef(EstimatedTimetableDeliveryConverter.getValue(estimatedVehicleJourney.getRouteRef())).setPublishedLineNames(EstimatedTimetableDeliveryConverter.convertNames(estimatedVehicleJourney.getPublishedLineNames())).setDestinationDisplayAtOrigins(EstimatedTimetableDeliveryConverter.convertNames(estimatedVehicleJourney.getDestinationDisplayAtOrigins())).setGroupOfLinesRef(EstimatedTimetableDeliveryConverter.getValue(estimatedVehicleJourney.getGroupOfLinesRef())).setExternalLineRef(EstimatedTimetableDeliveryConverter.getValue(estimatedVehicleJourney.getExternalLineRef())).setVehicleModes(EstimatedTimetableDeliveryConverter.convertVehicleModes(estimatedVehicleJourney.getVehicleModes())).setOriginNames(EstimatedTimetableDeliveryConverter.convertNames(estimatedVehicleJourney.getOriginNames())).setOriginRef(EstimatedTimetableDeliveryConverter.getValue(estimatedVehicleJourney.getOriginRef())).setDestinationNames(EstimatedTimetableDeliveryConverter.convertNames(estimatedVehicleJourney.getDestinationNames())).setDestinationRef(EstimatedTimetableDeliveryConverter.getValue(estimatedVehicleJourney.getDestinationRef())).setOperatorRef(EstimatedTimetableDeliveryConverter.getValue(estimatedVehicleJourney.getOperatorRef())).setOriginAimedDepartureTime(EstimatedTimetableDeliveryConverter.convert(estimatedVehicleJourney.getOriginAimedDepartureTime())).setDestinationAimedArrivalTime(EstimatedTimetableDeliveryConverter.convert(estimatedVehicleJourney.getDestinationAimedArrivalTime())).setVehicleFeatureRefs(EstimatedTimetableDeliveryConverter.getValues(estimatedVehicleJourney.getVehicleFeatureReves())).setServiceFeatureRefs(EstimatedTimetableDeliveryConverter.getValues(estimatedVehicleJourney.getServiceFeatureReves())).setProductCategoryRef(EstimatedTimetableDeliveryConverter.getValue(estimatedVehicleJourney.getProductCategoryRef())).setMonitored(estimatedVehicleJourney.isMonitored()).setExtraJourney(estimatedVehicleJourney.isExtraJourney()).setDataSource((CharSequence)estimatedVehicleJourney.getDataSource()).setOccupancy(EstimatedTimetableDeliveryConverter.convert(estimatedVehicleJourney.getOccupancy())).setBlockRef(EstimatedTimetableDeliveryConverter.getValue(estimatedVehicleJourney.getBlockRef())).setVehicleJourneyRef(EstimatedTimetableDeliveryConverter.getValue(estimatedVehicleJourney.getVehicleJourneyRef())).setAdditionalVehicleJourneyRef(EstimatedTimetableDeliveryConverter.convertFramedVehicleJourneys(estimatedVehicleJourney.getAdditionalVehicleJourneyReves())).setVehicleRef(EstimatedTimetableDeliveryConverter.getValue(estimatedVehicleJourney.getVehicleRef())).setRecordedCalls(EstimatedTimetableDeliveryConverter.convert(estimatedVehicleJourney.getRecordedCalls())).setEstimatedCalls(EstimatedTimetableDeliveryConverter.convert(estimatedVehicleJourney.getEstimatedCalls())).setIsCompleteStopSequence(estimatedVehicleJourney.isIsCompleteStopSequence()).build();
    }

    private static List<FramedVehicleJourneyRefRecord> convertFramedVehicleJourneys(List<FramedVehicleJourneyRefStructure> refs) {
        if (EstimatedTimetableDeliveryConverter.isNullOrEmpty(refs)) {
            return Collections.emptyList();
        }
        ArrayList<FramedVehicleJourneyRefRecord> records = new ArrayList<FramedVehicleJourneyRefRecord>();
        for (FramedVehicleJourneyRefStructure ref : refs) {
            records.add(EstimatedTimetableDeliveryConverter.convert(ref));
        }
        return records;
    }

    private static List<EstimatedCallRecord> convert(EstimatedVehicleJourney.EstimatedCalls estimatedCalls) {
        ArrayList<EstimatedCallRecord> calls = new ArrayList<EstimatedCallRecord>();
        if (estimatedCalls != null && !EstimatedTimetableDeliveryConverter.isNullOrEmpty(estimatedCalls.getEstimatedCalls())) {
            for (EstimatedCall call : estimatedCalls.getEstimatedCalls()) {
                calls.add(EstimatedTimetableDeliveryConverter.convert(call));
            }
        }
        return calls;
    }

    private static List<RecordedCallRecord> convert(EstimatedVehicleJourney.RecordedCalls recordedCalls) {
        ArrayList<RecordedCallRecord> calls = new ArrayList<RecordedCallRecord>();
        if (recordedCalls != null && !EstimatedTimetableDeliveryConverter.isNullOrEmpty(recordedCalls.getRecordedCalls())) {
            for (RecordedCall call : recordedCalls.getRecordedCalls()) {
                calls.add(EstimatedTimetableDeliveryConverter.convert(call));
            }
        }
        return calls;
    }

    private static RecordedCallRecord convert(RecordedCall call) {
        return RecordedCallRecord.newBuilder().setStopPointRef(EstimatedTimetableDeliveryConverter.getValue(call.getStopPointRef())).setStopPointNames(EstimatedTimetableDeliveryConverter.convertNames(call.getStopPointNames())).setOrder(EstimatedTimetableDeliveryConverter.convert(call.getOrder())).setCancellation(call.isCancellation()).setRequestStop(call.isRequestStop()).setExtraCall(call.isExtraCall()).setPredictionInaccurate(call.isPredictionInaccurate()).setOccupancy(EstimatedTimetableDeliveryConverter.convert(call.getOccupancy())).setDestinationDisplays(EstimatedTimetableDeliveryConverter.convertNames(call.getDestinationDisplaies())).setAimedArrivalTime(EstimatedTimetableDeliveryConverter.convert(call.getAimedArrivalTime())).setExpectedArrivalTime(EstimatedTimetableDeliveryConverter.convert(call.getExpectedArrivalTime())).setActualArrivalTime(EstimatedTimetableDeliveryConverter.convert(call.getActualArrivalTime())).setArrivalPlatformName(EstimatedTimetableDeliveryConverter.getValue(call.getArrivalPlatformName())).setArrivalStatus(EstimatedTimetableDeliveryConverter.convert(call.getArrivalStatus())).setArrivalBoardingActivity(EstimatedTimetableDeliveryConverter.convert(call.getArrivalBoardingActivity())).setArrivalStopAssignments(EstimatedTimetableDeliveryConverter.convertStopAssignments(call.getArrivalStopAssignments())).setAimedDepartureTime(EstimatedTimetableDeliveryConverter.convert(call.getAimedDepartureTime())).setExpectedDepartureTime(EstimatedTimetableDeliveryConverter.convert(call.getExpectedDepartureTime())).setActualDepartureTime(EstimatedTimetableDeliveryConverter.convert(call.getActualDepartureTime())).setDeparturePlatformName(EstimatedTimetableDeliveryConverter.getValue(call.getDeparturePlatformName())).setDepartureStatus(EstimatedTimetableDeliveryConverter.convert(call.getDepartureStatus())).setDepartureBoardingActivity(EstimatedTimetableDeliveryConverter.convert(call.getDepartureBoardingActivity())).setDepartureStopAssignments(EstimatedTimetableDeliveryConverter.convertStopAssignments(call.getDepartureStopAssignments())).setRecordedDepartureOccupancies(EstimatedTimetableDeliveryConverter.convertOccupancies(call.getRecordedDepartureOccupancies())).setRecordedDepartureCapacities(EstimatedTimetableDeliveryConverter.convertCapacities(call.getRecordedDepartureCapacities())).build();
    }

    private static BoardingActivityEnum convert(DepartureBoardingActivityEnumeration departureBoardingActivity) {
        if (departureBoardingActivity == null) {
            return null;
        }
        return BoardingActivityEnum.valueOf((String)departureBoardingActivity.name());
    }

    private static AlightingActivityEnum convert(ArrivalBoardingActivityEnumeration arrivalBoardingActivity) {
        if (arrivalBoardingActivity == null) {
            return null;
        }
        return AlightingActivityEnum.valueOf((String)arrivalBoardingActivity.name());
    }

    static EstimatedCallRecord convert(EstimatedCall call) {
        if (call == null) {
            return null;
        }
        return EstimatedCallRecord.newBuilder().setStopPointRef(EstimatedTimetableDeliveryConverter.getValue(call.getStopPointRef())).setStopPointNames(EstimatedTimetableDeliveryConverter.convertNames(call.getStopPointNames())).setOrder(EstimatedTimetableDeliveryConverter.convert(call.getOrder())).setCancellation(call.isCancellation()).setRequestStop(call.isRequestStop()).setExtraCall(call.isExtraCall()).setPredictionInaccurate(call.isPredictionInaccurate()).setOccupancy(call.getOccupancy() != null ? OccupancyEnum.valueOf((String)call.getOccupancy().name()) : null).setDestinationDisplays(EstimatedTimetableDeliveryConverter.convertNames(call.getDestinationDisplaies())).setAimedArrivalTime(EstimatedTimetableDeliveryConverter.convert(call.getAimedArrivalTime())).setExpectedArrivalTime(EstimatedTimetableDeliveryConverter.convert(call.getExpectedArrivalTime())).setArrivalPlatformName(EstimatedTimetableDeliveryConverter.getValue(call.getArrivalPlatformName())).setArrivalStatus(EstimatedTimetableDeliveryConverter.convert(call.getArrivalStatus())).setArrivalBoardingActivity(EstimatedTimetableDeliveryConverter.convert(call.getArrivalBoardingActivity())).setArrivalStopAssignments(EstimatedTimetableDeliveryConverter.convertStopAssignments(call.getArrivalStopAssignments())).setAimedDepartureTime(EstimatedTimetableDeliveryConverter.convert(call.getAimedDepartureTime())).setExpectedDepartureTime(EstimatedTimetableDeliveryConverter.convert(call.getExpectedDepartureTime())).setDeparturePlatformName(EstimatedTimetableDeliveryConverter.getValue(call.getDeparturePlatformName())).setDepartureStatus(EstimatedTimetableDeliveryConverter.convert(call.getDepartureStatus())).setDepartureBoardingActivity(EstimatedTimetableDeliveryConverter.convert(call.getDepartureBoardingActivity())).setDepartureStopAssignments(EstimatedTimetableDeliveryConverter.convertStopAssignments(call.getDepartureStopAssignments())).setExpectedDepartureOccupancies(EstimatedTimetableDeliveryConverter.convertOccupancies(call.getExpectedDepartureOccupancies())).setExpectedDepartureCapacities(EstimatedTimetableDeliveryConverter.convertCapacities(call.getExpectedDepartureCapacities())).build();
    }

    private static List<PassengerCapacityRecord> convertCapacities(List<PassengerCapacityStructure> passengerCapacities) {
        if (!EstimatedTimetableDeliveryConverter.isNullOrEmpty(passengerCapacities)) {
            ArrayList<PassengerCapacityRecord> records = new ArrayList<PassengerCapacityRecord>();
            for (PassengerCapacityStructure capacityStructure : passengerCapacities) {
                records.add(EstimatedTimetableDeliveryConverter.convert(capacityStructure));
            }
            return records;
        }
        return Collections.emptyList();
    }

    private static PassengerCapacityRecord convert(PassengerCapacityStructure capacity) {
        return PassengerCapacityRecord.newBuilder().setCompoundTrainRef(EstimatedTimetableDeliveryConverter.getValue(capacity.getCompoundTrainRef())).setTrainRef(EstimatedTimetableDeliveryConverter.getValue(capacity.getTrainRef())).setTrainComponentRef(EstimatedTimetableDeliveryConverter.getValue(capacity.getTrainComponentRef())).setEntranceToVehicleRef(EstimatedTimetableDeliveryConverter.getValue(capacity.getEntranceToVehicleRef())).setPassengerCategory(EstimatedTimetableDeliveryConverter.getValue(capacity.getPassengerCategory())).setTotalCapacity(EstimatedTimetableDeliveryConverter.convert(capacity.getTotalCapacity())).setSeatingCapacity(EstimatedTimetableDeliveryConverter.convert(capacity.getSeatingCapacity())).setStandingCapacity(EstimatedTimetableDeliveryConverter.convert(capacity.getStandingCapacity())).setPushchairCapacity(EstimatedTimetableDeliveryConverter.convert(capacity.getPushchairCapacity())).setWheelchairPlaceCapacity(EstimatedTimetableDeliveryConverter.convert(capacity.getWheelchairPlaceCapacity())).setPramPlaceCapacity(EstimatedTimetableDeliveryConverter.convert(capacity.getPramPlaceCapacity())).setBicycleRackCapacity(EstimatedTimetableDeliveryConverter.convert(capacity.getBicycleRackCapacity())).build();
    }

    private static List<VehicleOccupancyRecord> convertOccupancies(List<VehicleOccupancyStructure> occupancies) {
        if (!EstimatedTimetableDeliveryConverter.isNullOrEmpty(occupancies)) {
            ArrayList<VehicleOccupancyRecord> records = new ArrayList<VehicleOccupancyRecord>();
            for (VehicleOccupancyStructure occupancy : occupancies) {
                records.add(EstimatedTimetableDeliveryConverter.convert(occupancy));
            }
            return records;
        }
        return Collections.emptyList();
    }

    private static VehicleOccupancyRecord convert(VehicleOccupancyStructure occupancy) {
        return VehicleOccupancyRecord.newBuilder().setCompoundTrainRef(EstimatedTimetableDeliveryConverter.getValue(occupancy.getCompoundTrainRef())).setTrainRef(EstimatedTimetableDeliveryConverter.getValue(occupancy.getTrainRef())).setTrainComponentRef(EstimatedTimetableDeliveryConverter.getValue(occupancy.getTrainComponentRef())).setEntranceToVehicleRef(EstimatedTimetableDeliveryConverter.getValue(occupancy.getEntranceToVehicleRef())).setPassengerCategory(EstimatedTimetableDeliveryConverter.getValue(occupancy.getPassengerCategory())).setOccupancyLevel(EstimatedTimetableDeliveryConverter.convert(occupancy.getOccupancyLevel())).setOccupancyPercentage(EstimatedTimetableDeliveryConverter.convert(occupancy.getOccupancyPercentage())).setAlightingCount(EstimatedTimetableDeliveryConverter.convert(occupancy.getAlightingCount())).setBoardingCount(EstimatedTimetableDeliveryConverter.convert(occupancy.getBoardingCount())).setOnboardCount(EstimatedTimetableDeliveryConverter.convert(occupancy.getOnboardCount())).setPushchairsOnboardCount(EstimatedTimetableDeliveryConverter.convert(occupancy.getPushchairsOnboardCount())).setWheelchairsOnboardCount(EstimatedTimetableDeliveryConverter.convert(occupancy.getWheelchairsOnboardCount())).setPramsOnboardCount(EstimatedTimetableDeliveryConverter.convert(occupancy.getPramsOnboardCount())).setBicycleOnboardCount(EstimatedTimetableDeliveryConverter.convert(occupancy.getBicycleOnboardCount())).setTotalNumberOfReservedSeats(EstimatedTimetableDeliveryConverter.convert(occupancy.getTotalNumberOfReservedSeats())).build();
    }

    private static Map<CharSequence, CharSequence> convert(Extensions extensions) {
        HashMap<CharSequence, CharSequence> extensionMap = new HashMap<CharSequence, CharSequence>();
        if (extensions != null && extensions.getAnies() != null) {
            for (Element any : extensions.getAnies()) {
                String localName = any.getLocalName();
                String nodeValue = any.getFirstChild().getNodeValue();
                extensionMap.put(localName, nodeValue);
            }
        }
        return extensionMap;
    }

    private static List<StopAssignmentRecord> convertStopAssignments(List<StopAssignmentStructure> stopAssignments) {
        if (!EstimatedTimetableDeliveryConverter.isNullOrEmpty(stopAssignments)) {
            ArrayList<StopAssignmentRecord> records = new ArrayList<StopAssignmentRecord>();
            for (StopAssignmentStructure stopAssignment : stopAssignments) {
                records.add(StopAssignmentRecord.newBuilder().setAimedQuayRef(EstimatedTimetableDeliveryConverter.getValue(stopAssignment.getAimedQuayRef())).setExpectedQuayRef(EstimatedTimetableDeliveryConverter.getValue(stopAssignment.getExpectedQuayRef())).build());
            }
            return records;
        }
        return Collections.emptyList();
    }

    private static CallStatusEnum convert(CallStatusEnumeration arrivalStatus) {
        if (arrivalStatus == null) {
            return null;
        }
        return CallStatusEnum.valueOf((String)arrivalStatus.name());
    }
}

