/*
 * Decompiled with CFR 0.152.
 */
package org.entur.avro.realtime.siri.converter.jaxb2avro;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.entur.avro.realtime.siri.converter.jaxb2avro.Jaxb2AvroEnumConverter;
import org.entur.avro.realtime.siri.model.AccessibilityAssessmentRecord;
import org.entur.avro.realtime.siri.model.AccessibilityEnum;
import org.entur.avro.realtime.siri.model.AccessibilityFeatureEnum;
import org.entur.avro.realtime.siri.model.AccessibilityLimitationRecord;
import org.entur.avro.realtime.siri.model.AdviceRecord;
import org.entur.avro.realtime.siri.model.AffectedComponentsRecord;
import org.entur.avro.realtime.siri.model.AffectedLineRecord;
import org.entur.avro.realtime.siri.model.AffectedNetworkRecord;
import org.entur.avro.realtime.siri.model.AffectedOperatorRecord;
import org.entur.avro.realtime.siri.model.AffectedRouteRecord;
import org.entur.avro.realtime.siri.model.AffectedSectionRecord;
import org.entur.avro.realtime.siri.model.AffectedStopPlaceComponentRecord;
import org.entur.avro.realtime.siri.model.AffectedStopPlaceRecord;
import org.entur.avro.realtime.siri.model.AffectedStopPointRecord;
import org.entur.avro.realtime.siri.model.AffectedVehicleJourneyRecord;
import org.entur.avro.realtime.siri.model.AffectsRecord;
import org.entur.avro.realtime.siri.model.ConsequenceRecord;
import org.entur.avro.realtime.siri.model.IndirectSectionRefRecord;
import org.entur.avro.realtime.siri.model.InfoLinkRecord;
import org.entur.avro.realtime.siri.model.PtSituationElementRecord;
import org.entur.avro.realtime.siri.model.SituationExchangeDeliveryRecord;
import org.entur.avro.realtime.siri.model.SourceRecord;
import org.entur.avro.realtime.siri.model.SourceTypeEnum;
import org.entur.avro.realtime.siri.model.StopPlaceComponentTypeEnum;
import org.entur.avro.realtime.siri.model.StopPointsRecord;
import org.entur.avro.realtime.siri.model.ValidityPeriodRecord;
import uk.org.acbs.siri21.AccessibilityAssessmentStructure;
import uk.org.acbs.siri21.AccessibilityLimitationStructure;
import uk.org.acbs.siri21.AccessibilityStructure;
import uk.org.ifopt.siri21.StopPlaceComponentTypeEnumeration;
import uk.org.siri.siri21.AccessibilityFeatureEnumeration;
import uk.org.siri.siri21.AffectedLineStructure;
import uk.org.siri.siri21.AffectedOperatorStructure;
import uk.org.siri.siri21.AffectedRouteStructure;
import uk.org.siri.siri21.AffectedSectionStructure;
import uk.org.siri.siri21.AffectedStopPlaceComponentStructure;
import uk.org.siri.siri21.AffectedStopPlaceStructure;
import uk.org.siri.siri21.AffectedStopPointStructure;
import uk.org.siri.siri21.AffectedVehicleJourneyStructure;
import uk.org.siri.siri21.AffectsScopeStructure;
import uk.org.siri.siri21.HalfOpenTimestampOutputRangeStructure;
import uk.org.siri.siri21.InfoLinkStructure;
import uk.org.siri.siri21.PtAdviceStructure;
import uk.org.siri.siri21.PtConsequenceStructure;
import uk.org.siri.siri21.PtConsequencesStructure;
import uk.org.siri.siri21.PtSituationElement;
import uk.org.siri.siri21.SituationExchangeDeliveryStructure;
import uk.org.siri.siri21.SituationSourceStructure;

public class SituationExchangeDeliveryConverter
extends Jaxb2AvroEnumConverter {
    public static List<SituationExchangeDeliveryRecord> convert(List<SituationExchangeDeliveryStructure> deliveries) {
        if (SituationExchangeDeliveryConverter.isNullOrEmpty(deliveries)) {
            return Collections.emptyList();
        }
        ArrayList<SituationExchangeDeliveryRecord> records = new ArrayList<SituationExchangeDeliveryRecord>();
        for (SituationExchangeDeliveryStructure delivery : deliveries) {
            SituationExchangeDeliveryStructure.Situations situations = delivery.getSituations();
            if (situations == null) continue;
            records.add(SituationExchangeDeliveryRecord.newBuilder().setVersion((CharSequence)delivery.getVersion()).setResponseTimestamp(SituationExchangeDeliveryConverter.convert(delivery.getResponseTimestamp())).setSituations(SituationExchangeDeliveryConverter.process(situations.getPtSituationElements())).build());
        }
        return records;
    }

    private static List<PtSituationElementRecord> process(List<PtSituationElement> elements) {
        if (elements == null) {
            return Collections.emptyList();
        }
        ArrayList<PtSituationElementRecord> records = new ArrayList<PtSituationElementRecord>();
        for (PtSituationElement element : elements) {
            records.add(SituationExchangeDeliveryConverter.convert(element));
        }
        return records;
    }

    static PtSituationElementRecord convert(PtSituationElement element) {
        if (element == null) {
            return null;
        }
        return PtSituationElementRecord.newBuilder().setCreationTime(SituationExchangeDeliveryConverter.convert(element.getCreationTime())).setParticipantRef(SituationExchangeDeliveryConverter.getValue(element.getParticipantRef())).setSituationNumber(SituationExchangeDeliveryConverter.getValue(element.getSituationNumber())).setVersion(SituationExchangeDeliveryConverter.convert(element.getVersion())).setSource(SituationExchangeDeliveryConverter.convert(element.getSource())).setVersionedAtTime(SituationExchangeDeliveryConverter.convert(element.getVersionedAtTime())).setProgress(SituationExchangeDeliveryConverter.convert(element.getProgress())).setValidityPeriods(SituationExchangeDeliveryConverter.convertValidityPeriods(element.getValidityPeriods())).setUndefinedReason((CharSequence)element.getUndefinedReason()).setSeverity(SituationExchangeDeliveryConverter.convert(element.getSeverity())).setPriority(SituationExchangeDeliveryConverter.convert(element.getPriority())).setReportType(SituationExchangeDeliveryConverter.convert(element.getReportType())).setKeywords(new ArrayList(element.getKeywords())).setPlanned(element.isPlanned()).setSummaries(SituationExchangeDeliveryConverter.getTranslatedValues(element.getSummaries())).setDescriptions(SituationExchangeDeliveryConverter.getTranslatedValues(element.getDescriptions())).setDetails(SituationExchangeDeliveryConverter.getTranslatedValues(element.getDetails())).setAdvices(SituationExchangeDeliveryConverter.getTranslatedValues(element.getAdvices())).setInfoLinks(SituationExchangeDeliveryConverter.convert(element.getInfoLinks())).setAffects(SituationExchangeDeliveryConverter.convert(element.getAffects())).setConsequences(SituationExchangeDeliveryConverter.convert(element.getConsequences())).build();
    }

    private static List<ConsequenceRecord> convert(PtConsequencesStructure consequences) {
        if (consequences == null) {
            return Collections.emptyList();
        }
        ArrayList<ConsequenceRecord> records = new ArrayList<ConsequenceRecord>();
        for (PtConsequenceStructure consequence : consequences.getConsequences()) {
            if (consequence.getAdvice() == null) continue;
            records.add(ConsequenceRecord.newBuilder().setAdvice(SituationExchangeDeliveryConverter.convert(consequence.getAdvice())).build());
        }
        return records;
    }

    private static AdviceRecord convert(PtAdviceStructure advice) {
        if (advice == null) {
            return null;
        }
        return AdviceRecord.newBuilder().setAdviceType(SituationExchangeDeliveryConverter.convert(advice.getAdviceType())).build();
    }

    private static AffectsRecord convert(AffectsScopeStructure affects) {
        if (affects == null) {
            return null;
        }
        return AffectsRecord.newBuilder().setNetworks(SituationExchangeDeliveryConverter.convert(affects.getNetworks())).setStopPlaces(SituationExchangeDeliveryConverter.convert(affects.getStopPlaces())).setStopPoints(SituationExchangeDeliveryConverter.convert(affects.getStopPoints())).setVehicleJourneys(SituationExchangeDeliveryConverter.convert(affects.getVehicleJourneys())).build();
    }

    private static List<AffectedVehicleJourneyRecord> convert(AffectsScopeStructure.VehicleJourneys vehicleJourneys) {
        if (vehicleJourneys == null) {
            return Collections.emptyList();
        }
        ArrayList<AffectedVehicleJourneyRecord> records = new ArrayList<AffectedVehicleJourneyRecord>();
        for (AffectedVehicleJourneyStructure affectedVehicleJourney : vehicleJourneys.getAffectedVehicleJourneies()) {
            records.add(AffectedVehicleJourneyRecord.newBuilder().setVehicleJourneyRefs(SituationExchangeDeliveryConverter.getValues(affectedVehicleJourney.getVehicleJourneyReves())).setFramedVehicleJourneyRef(SituationExchangeDeliveryConverter.convert(affectedVehicleJourney.getFramedVehicleJourneyRef())).setDatedVehicleJourneyRefs(SituationExchangeDeliveryConverter.getValues(affectedVehicleJourney.getDatedVehicleJourneyReves())).setOperator(SituationExchangeDeliveryConverter.convert(affectedVehicleJourney.getOperator())).setLineRef(SituationExchangeDeliveryConverter.getValue(affectedVehicleJourney.getLineRef())).setRoutes(SituationExchangeDeliveryConverter.convertRoutes(affectedVehicleJourney.getRoutes())).setOriginAimedDepartureTime(SituationExchangeDeliveryConverter.convert(affectedVehicleJourney.getOriginAimedDepartureTime())).build());
        }
        return records;
    }

    private static List<AffectedRouteRecord> convertRoutes(List<AffectedRouteStructure> routes) {
        ArrayList<AffectedRouteRecord> records = new ArrayList<AffectedRouteRecord>();
        for (AffectedRouteStructure route : routes) {
            records.add(SituationExchangeDeliveryConverter.convert(route));
        }
        return records;
    }

    private static List<AffectedStopPointRecord> convert(AffectsScopeStructure.StopPoints stopPoints) {
        if (stopPoints == null) {
            return Collections.emptyList();
        }
        ArrayList<AffectedStopPointRecord> records = new ArrayList<AffectedStopPointRecord>();
        for (AffectedStopPointStructure affectedStopPoint : stopPoints.getAffectedStopPoints()) {
            records.add(AffectedStopPointRecord.newBuilder().setStopPointRef(SituationExchangeDeliveryConverter.getValue(affectedStopPoint.getStopPointRef())).setStopPointNames(SituationExchangeDeliveryConverter.convertNames(affectedStopPoint.getStopPointNames())).setStopConditions(SituationExchangeDeliveryConverter.convertStopConditions(affectedStopPoint.getStopConditions())).build());
        }
        return records;
    }

    private static List<AffectedStopPlaceRecord> convert(AffectsScopeStructure.StopPlaces stopPlaces) {
        if (stopPlaces == null) {
            return Collections.emptyList();
        }
        ArrayList<AffectedStopPlaceRecord> records = new ArrayList<AffectedStopPlaceRecord>();
        for (AffectedStopPlaceStructure affectedStopPlace : stopPlaces.getAffectedStopPlaces()) {
            records.add(AffectedStopPlaceRecord.newBuilder().setAccessibilityAssessment(SituationExchangeDeliveryConverter.convert(affectedStopPlace.getAccessibilityAssessment())).setStopPlaceRef(SituationExchangeDeliveryConverter.getValue(affectedStopPlace.getStopPlaceRef())).setPlaceNames(SituationExchangeDeliveryConverter.getTranslatedValues(affectedStopPlace.getPlaceNames())).setAffectedComponent(SituationExchangeDeliveryConverter.convert(affectedStopPlace.getAffectedComponents())).build());
        }
        return records;
    }

    private static AffectedComponentsRecord convert(AffectedStopPlaceStructure.AffectedComponents affectedComponents) {
        if (affectedComponents == null) {
            return null;
        }
        return AffectedComponentsRecord.newBuilder().setComponents(SituationExchangeDeliveryConverter.convertComponents(affectedComponents.getAffectedComponents())).build();
    }

    private static List<AffectedStopPlaceComponentRecord> convertComponents(List<AffectedStopPlaceComponentStructure> components) {
        if (components == null) {
            return Collections.emptyList();
        }
        ArrayList<AffectedStopPlaceComponentRecord> records = new ArrayList<AffectedStopPlaceComponentRecord>();
        for (AffectedStopPlaceComponentStructure component : components) {
            records.add(SituationExchangeDeliveryConverter.convert(component));
        }
        return records;
    }

    private static AffectedStopPlaceComponentRecord convert(AffectedStopPlaceComponentStructure component) {
        return AffectedStopPlaceComponentRecord.newBuilder().setComponentRef(SituationExchangeDeliveryConverter.getValue(component.getComponentRef())).setAccessFeatureType(SituationExchangeDeliveryConverter.convert(component.getAccessFeatureType())).setComponentType(SituationExchangeDeliveryConverter.convert(component.getComponentType())).build();
    }

    private static StopPlaceComponentTypeEnum convert(StopPlaceComponentTypeEnumeration componentType) {
        if (componentType == null) {
            return null;
        }
        return StopPlaceComponentTypeEnum.valueOf((String)componentType.name());
    }

    private static AccessibilityFeatureEnum convert(AccessibilityFeatureEnumeration accessFeatureType) {
        if (accessFeatureType == null) {
            return null;
        }
        return AccessibilityFeatureEnum.valueOf((String)accessFeatureType.name());
    }

    private static AccessibilityAssessmentRecord convert(AccessibilityAssessmentStructure accessibilityAssessment) {
        if (accessibilityAssessment == null) {
            return null;
        }
        return AccessibilityAssessmentRecord.newBuilder().setMobilityImpairedAccess(Boolean.valueOf(accessibilityAssessment.isMobilityImpairedAccess())).setLimitations(SituationExchangeDeliveryConverter.convert(accessibilityAssessment.getLimitations())).build();
    }

    private static List<AccessibilityLimitationRecord> convert(AccessibilityAssessmentStructure.Limitations limitations) {
        if (limitations == null) {
            return Collections.emptyList();
        }
        ArrayList<AccessibilityLimitationRecord> records = new ArrayList<AccessibilityLimitationRecord>();
        for (AccessibilityLimitationStructure accessibilityLimitation : limitations.getAccessibilityLimitations()) {
            records.add(AccessibilityLimitationRecord.newBuilder().setEscalatorFreeAccess(SituationExchangeDeliveryConverter.convert(accessibilityLimitation.getEscalatorFreeAccess())).setStepFreeAccess(SituationExchangeDeliveryConverter.convert(accessibilityLimitation.getStepFreeAccess())).setEscalatorFreeAccess(SituationExchangeDeliveryConverter.convert(accessibilityLimitation.getEscalatorFreeAccess())).setLiftFreeAccess(SituationExchangeDeliveryConverter.convert(accessibilityLimitation.getLiftFreeAccess())).build());
        }
        return records;
    }

    private static AccessibilityEnum convert(AccessibilityStructure accessibilityStructure) {
        if (accessibilityStructure == null) {
            return null;
        }
        return AccessibilityEnum.valueOf((String)accessibilityStructure.getValue().name());
    }

    private static List<AffectedNetworkRecord> convert(AffectsScopeStructure.Networks networks) {
        if (networks == null) {
            return Collections.emptyList();
        }
        ArrayList<AffectedNetworkRecord> records = new ArrayList<AffectedNetworkRecord>();
        for (AffectsScopeStructure.Networks.AffectedNetwork affectedNetwork : networks.getAffectedNetworks()) {
            records.add(SituationExchangeDeliveryConverter.convert(affectedNetwork));
        }
        return records;
    }

    private static AffectedNetworkRecord convert(AffectsScopeStructure.Networks.AffectedNetwork affectedNetwork) {
        if (affectedNetwork == null) {
            return null;
        }
        return AffectedNetworkRecord.newBuilder().setAffectedOperators(SituationExchangeDeliveryConverter.convertOperators(affectedNetwork.getAffectedOperators())).setNetworkRef(SituationExchangeDeliveryConverter.getValue(affectedNetwork.getNetworkRef())).setVehicleMode(SituationExchangeDeliveryConverter.convert(affectedNetwork.getVehicleMode())).setAirSubmode(SituationExchangeDeliveryConverter.convert(affectedNetwork.getAirSubmode())).setBusSubmode(SituationExchangeDeliveryConverter.convert(affectedNetwork.getBusSubmode())).setCoachSubmode(SituationExchangeDeliveryConverter.convert(affectedNetwork.getCoachSubmode())).setMetroSubmode(SituationExchangeDeliveryConverter.convert(affectedNetwork.getMetroSubmode())).setRailSubmode(SituationExchangeDeliveryConverter.convert(affectedNetwork.getRailSubmode())).setTramSubmode(SituationExchangeDeliveryConverter.convert(affectedNetwork.getTramSubmode())).setWaterSubmode(SituationExchangeDeliveryConverter.convert(affectedNetwork.getWaterSubmode())).setAffectedLines(SituationExchangeDeliveryConverter.convertLines(affectedNetwork.getAffectedLines())).setAllLines((CharSequence)affectedNetwork.getAllLines()).build();
    }

    private static List<AffectedLineRecord> convertLines(List<AffectedLineStructure> affectedLines) {
        ArrayList<AffectedLineRecord> records = new ArrayList<AffectedLineRecord>();
        for (AffectedLineStructure affectedLine : affectedLines) {
            records.add(SituationExchangeDeliveryConverter.convert(affectedLine));
        }
        return records;
    }

    private static AffectedLineRecord convert(AffectedLineStructure affectedLine) {
        if (affectedLine == null) {
            return null;
        }
        return AffectedLineRecord.newBuilder().setLineRef(SituationExchangeDeliveryConverter.getValue(affectedLine.getLineRef())).setRoutes(SituationExchangeDeliveryConverter.convert(affectedLine.getRoutes())).setSections(SituationExchangeDeliveryConverter.convert(affectedLine.getSections())).build();
    }

    private static List<AffectedRouteRecord> convert(AffectedLineStructure.Routes routes) {
        if (routes == null) {
            return Collections.emptyList();
        }
        ArrayList<AffectedRouteRecord> records = new ArrayList<AffectedRouteRecord>();
        for (AffectedRouteStructure affectedRoute : routes.getAffectedRoutes()) {
            records.add(SituationExchangeDeliveryConverter.convert(affectedRoute));
        }
        return records;
    }

    private static AffectedRouteRecord convert(AffectedRouteStructure affectedRoute) {
        if (affectedRoute == null) {
            return null;
        }
        return AffectedRouteRecord.newBuilder().setRouteRef(SituationExchangeDeliveryConverter.getValue(affectedRoute.getRouteRef())).setStopPoints(SituationExchangeDeliveryConverter.convert(affectedRoute.getStopPoints())).setSections(SituationExchangeDeliveryConverter.convert(affectedRoute.getSections())).build();
    }

    private static List<AffectedSectionRecord> convert(AffectedRouteStructure.Sections sections) {
        if (sections == null) {
            return Collections.emptyList();
        }
        ArrayList<AffectedSectionRecord> records = new ArrayList<AffectedSectionRecord>();
        for (AffectedSectionStructure affectedSection : sections.getAffectedSections()) {
            records.add(SituationExchangeDeliveryConverter.convert(affectedSection));
        }
        return records;
    }

    private static List<AffectedSectionRecord> convert(AffectedLineStructure.Sections sections) {
        if (sections == null) {
            return Collections.emptyList();
        }
        ArrayList<AffectedSectionRecord> records = new ArrayList<AffectedSectionRecord>();
        for (AffectedSectionStructure affectedSection : sections.getAffectedSections()) {
            records.add(SituationExchangeDeliveryConverter.convert(affectedSection));
        }
        return records;
    }

    private static AffectedSectionRecord convert(AffectedSectionStructure affectedSection) {
        if (affectedSection == null) {
            return null;
        }
        return AffectedSectionRecord.newBuilder().setIndirectSectionRef(SituationExchangeDeliveryConverter.convert(affectedSection.getIndirectSectionRef())).build();
    }

    private static IndirectSectionRefRecord convert(AffectedSectionStructure.IndirectSectionRef indirectSectionRef) {
        if (indirectSectionRef == null) {
            return null;
        }
        return IndirectSectionRefRecord.newBuilder().setFirstQuayRef(SituationExchangeDeliveryConverter.getValue(indirectSectionRef.getFirstQuayRef())).setLastQuayRef(SituationExchangeDeliveryConverter.getValue(indirectSectionRef.getLastQuayRef())).build();
    }

    private static StopPointsRecord convert(AffectedRouteStructure.StopPoints stopPoints) {
        if (stopPoints == null) {
            return null;
        }
        return StopPointsRecord.newBuilder().setAffectedOnly(stopPoints.isAffectedOnly()).setStopPoints(SituationExchangeDeliveryConverter.convertRouteStopPoints(stopPoints.getAffectedStopPointsAndLinkProjectionToNextStopPoints())).build();
    }

    private static List<AffectedStopPointRecord> convertRouteStopPoints(List<Serializable> stopPoints) {
        ArrayList<AffectedStopPointRecord> records = new ArrayList<AffectedStopPointRecord>();
        for (Serializable affectedStopPoint : stopPoints) {
            if (!(affectedStopPoint instanceof AffectedStopPointStructure)) continue;
            records.add(SituationExchangeDeliveryConverter.convert((AffectedStopPointStructure)affectedStopPoint));
        }
        return records;
    }

    private static AffectedStopPointRecord convert(AffectedStopPointStructure affectedStopPoint) {
        if (affectedStopPoint == null) {
            return null;
        }
        return AffectedStopPointRecord.newBuilder().setStopPointRef(SituationExchangeDeliveryConverter.getValue(affectedStopPoint.getStopPointRef())).setStopPointNames(SituationExchangeDeliveryConverter.getTranslatedValues(affectedStopPoint.getStopPointNames())).setStopConditions(SituationExchangeDeliveryConverter.convertStopConditions(affectedStopPoint.getStopConditions())).build();
    }

    private static List<AffectedOperatorRecord> convertOperators(List<AffectedOperatorStructure> affectedOperators) {
        if (affectedOperators == null) {
            return Collections.emptyList();
        }
        ArrayList<AffectedOperatorRecord> records = new ArrayList<AffectedOperatorRecord>();
        for (AffectedOperatorStructure affectedOperator : affectedOperators) {
            records.add(SituationExchangeDeliveryConverter.convert(affectedOperator));
        }
        return records;
    }

    private static AffectedOperatorRecord convert(AffectedOperatorStructure affectedOperator) {
        if (affectedOperator == null) {
            return null;
        }
        return AffectedOperatorRecord.newBuilder().setOperatorRef(SituationExchangeDeliveryConverter.getValue(affectedOperator.getOperatorRef())).setOperatorNames(SituationExchangeDeliveryConverter.getTranslatedValues(affectedOperator.getOperatorNames())).build();
    }

    private static List<InfoLinkRecord> convert(PtSituationElement.InfoLinks infoLinks) {
        if (infoLinks == null) {
            return Collections.emptyList();
        }
        ArrayList<InfoLinkRecord> records = new ArrayList<InfoLinkRecord>();
        for (InfoLinkStructure infoLink : infoLinks.getInfoLinks()) {
            records.add(SituationExchangeDeliveryConverter.convert(infoLink));
        }
        return records;
    }

    private static InfoLinkRecord convert(InfoLinkStructure infoLink) {
        if (infoLink == null) {
            return null;
        }
        return InfoLinkRecord.newBuilder().setLabels(SituationExchangeDeliveryConverter.getTranslatedValues(infoLink.getLabels())).setUri((CharSequence)infoLink.getUri()).build();
    }

    private static List<ValidityPeriodRecord> convertValidityPeriods(List<HalfOpenTimestampOutputRangeStructure> periods) {
        if (periods == null) {
            return Collections.emptyList();
        }
        ArrayList<ValidityPeriodRecord> records = new ArrayList<ValidityPeriodRecord>();
        for (HalfOpenTimestampOutputRangeStructure period : periods) {
            records.add(SituationExchangeDeliveryConverter.convert(period));
        }
        return records;
    }

    private static ValidityPeriodRecord convert(HalfOpenTimestampOutputRangeStructure period) {
        if (period == null) {
            return null;
        }
        return ValidityPeriodRecord.newBuilder().setStartTime(SituationExchangeDeliveryConverter.convert(period.getStartTime())).setEndTime(SituationExchangeDeliveryConverter.convert(period.getEndTime())).build();
    }

    private static SourceRecord convert(SituationSourceStructure source) {
        if (source == null) {
            return null;
        }
        return SourceRecord.newBuilder().setSourceType(SourceTypeEnum.valueOf((String)source.getSourceType().name())).build();
    }
}

