/*
 * Decompiled with CFR 0.152.
 */
package org.entur.avro.realtime.siri.converter.jaxb2avro;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.entur.avro.realtime.siri.converter.CommonConverter;
import org.entur.avro.realtime.siri.model.EstimatedTimetableRequestRecord;
import org.entur.avro.realtime.siri.model.EstimatedTimetableSubscriptionRecord;
import org.entur.avro.realtime.siri.model.HeartbeatNotificationRecord;
import org.entur.avro.realtime.siri.model.ResponseStatusRecord;
import org.entur.avro.realtime.siri.model.SituationExchangeRequestRecord;
import org.entur.avro.realtime.siri.model.SituationExchangeSubscriptionRecord;
import org.entur.avro.realtime.siri.model.SubscriptionContextRecord;
import org.entur.avro.realtime.siri.model.SubscriptionRequestRecord;
import org.entur.avro.realtime.siri.model.SubscriptionResponseRecord;
import org.entur.avro.realtime.siri.model.TerminateSubscriptionRequestRecord;
import org.entur.avro.realtime.siri.model.TerminateSubscriptionResponseRecord;
import org.entur.avro.realtime.siri.model.TerminationResponseStatusRecord;
import org.entur.avro.realtime.siri.model.VehicleMonitoringRequestRecord;
import org.entur.avro.realtime.siri.model.VehicleMonitoringSubscriptionRecord;
import uk.org.siri.siri21.EstimatedTimetableRequestStructure;
import uk.org.siri.siri21.EstimatedTimetableSubscriptionStructure;
import uk.org.siri.siri21.HeartbeatNotificationStructure;
import uk.org.siri.siri21.ResponseStatus;
import uk.org.siri.siri21.ServiceDeliveryErrorConditionElement;
import uk.org.siri.siri21.SituationExchangeRequestStructure;
import uk.org.siri.siri21.SituationExchangeSubscriptionStructure;
import uk.org.siri.siri21.SubscriptionContextStructure;
import uk.org.siri.siri21.SubscriptionRequest;
import uk.org.siri.siri21.SubscriptionResponseStructure;
import uk.org.siri.siri21.TerminateSubscriptionRequestStructure;
import uk.org.siri.siri21.TerminateSubscriptionResponseStructure;
import uk.org.siri.siri21.TerminationResponseStatusStructure;
import uk.org.siri.siri21.VehicleMonitoringRequestStructure;
import uk.org.siri.siri21.VehicleMonitoringSubscriptionStructure;

public class SubscriptionConverter
extends CommonConverter {
    static HeartbeatNotificationRecord convert(HeartbeatNotificationStructure heartbeatNotification) {
        if (heartbeatNotification == null) {
            return null;
        }
        return HeartbeatNotificationRecord.newBuilder().setProducerRef(CommonConverter.getValue(heartbeatNotification.getProducerRef())).setRequestTimestamp(CommonConverter.convert(heartbeatNotification.getRequestTimestamp())).setServiceStartedTime(CommonConverter.convert(heartbeatNotification.getServiceStartedTime())).setStatus(heartbeatNotification.isStatus().booleanValue()).build();
    }

    public static SubscriptionRequestRecord convert(SubscriptionRequest subscriptionRequest) {
        if (subscriptionRequest == null) {
            return null;
        }
        return SubscriptionRequestRecord.newBuilder().setRequestTimestamp(SubscriptionConverter.convert(subscriptionRequest.getRequestTimestamp())).setAddress((CharSequence)subscriptionRequest.getAddress()).setConsumerAddress((CharSequence)subscriptionRequest.getConsumerAddress()).setMessageIdentifier(SubscriptionConverter.getValue(subscriptionRequest.getMessageIdentifier())).setSubscriptionContext(SubscriptionConverter.convert(subscriptionRequest.getSubscriptionContext())).setRequestorRef(SubscriptionConverter.getValue(subscriptionRequest.getRequestorRef())).setEstimatedTimetableSubscriptionRequests(SubscriptionConverter.convertEtSubRequests(subscriptionRequest.getEstimatedTimetableSubscriptionRequests())).setVehicleMonitoringSubscriptionRequests(SubscriptionConverter.convertVmSubRequests(subscriptionRequest.getVehicleMonitoringSubscriptionRequests())).setSituationExchangeSubscriptionRequests(SubscriptionConverter.convertSxSubRequests(subscriptionRequest.getSituationExchangeSubscriptionRequests())).build();
    }

    private static List<VehicleMonitoringSubscriptionRecord> convertVmSubRequests(List<VehicleMonitoringSubscriptionStructure> subscriptionRequests) {
        if (SubscriptionConverter.isNullOrEmpty(subscriptionRequests)) {
            return Collections.emptyList();
        }
        ArrayList<VehicleMonitoringSubscriptionRecord> records = new ArrayList<VehicleMonitoringSubscriptionRecord>();
        for (VehicleMonitoringSubscriptionStructure request : subscriptionRequests) {
            records.add(SubscriptionConverter.convert(request));
        }
        return records;
    }

    private static VehicleMonitoringSubscriptionRecord convert(VehicleMonitoringSubscriptionStructure request) {
        if (request == null) {
            return null;
        }
        return VehicleMonitoringSubscriptionRecord.newBuilder().setSubscriberRef(SubscriptionConverter.getValue(request.getSubscriberRef())).setSubscriptionIdentifier(SubscriptionConverter.getValue(request.getSubscriptionIdentifier())).setIncrementalUpdates(request.isIncrementalUpdates()).setInitialTerminationTime(SubscriptionConverter.convert(request.getInitialTerminationTime())).setChangeBeforeUpdates(SubscriptionConverter.convert(request.getChangeBeforeUpdates())).setVehicleMonitoringRequest(SubscriptionConverter.convert(request.getVehicleMonitoringRequest())).setUpdateInterval(SubscriptionConverter.convert(request.getUpdateInterval())).build();
    }

    private static VehicleMonitoringRequestRecord convert(VehicleMonitoringRequestStructure request) {
        if (request == null) {
            return null;
        }
        return VehicleMonitoringRequestRecord.newBuilder().setVersion((CharSequence)request.getVersion()).setMessageIdentifier(SubscriptionConverter.getValue(request.getMessageIdentifier())).setRequestTimestamp(SubscriptionConverter.convert(request.getRequestTimestamp())).build();
    }

    private static List<SituationExchangeSubscriptionRecord> convertSxSubRequests(List<SituationExchangeSubscriptionStructure> subscriptionRequests) {
        if (SubscriptionConverter.isNullOrEmpty(subscriptionRequests)) {
            return Collections.emptyList();
        }
        ArrayList<SituationExchangeSubscriptionRecord> records = new ArrayList<SituationExchangeSubscriptionRecord>();
        for (SituationExchangeSubscriptionStructure request : subscriptionRequests) {
            records.add(SubscriptionConverter.convert(request));
        }
        return records;
    }

    private static SituationExchangeSubscriptionRecord convert(SituationExchangeSubscriptionStructure request) {
        if (request == null) {
            return null;
        }
        return SituationExchangeSubscriptionRecord.newBuilder().setSubscriberRef(SubscriptionConverter.getValue(request.getSubscriberRef())).setSubscriptionIdentifier(SubscriptionConverter.getValue(request.getSubscriptionIdentifier())).setIncrementalUpdates(request.isIncrementalUpdates()).setInitialTerminationTime(SubscriptionConverter.convert(request.getInitialTerminationTime())).setSituationExchangeRequest(SubscriptionConverter.convert(request.getSituationExchangeRequest())).build();
    }

    private static SituationExchangeRequestRecord convert(SituationExchangeRequestStructure request) {
        if (request == null) {
            return null;
        }
        return SituationExchangeRequestRecord.newBuilder().setVersion((CharSequence)request.getVersion()).setMessageIdentifier(SubscriptionConverter.getValue(request.getMessageIdentifier())).setRequestTimestamp(SubscriptionConverter.convert(request.getRequestTimestamp())).setPreviewInterval(SubscriptionConverter.convert(request.getPreviewInterval())).build();
    }

    private static List<EstimatedTimetableSubscriptionRecord> convertEtSubRequests(List<EstimatedTimetableSubscriptionStructure> subscriptionRequests) {
        if (SubscriptionConverter.isNullOrEmpty(subscriptionRequests)) {
            return Collections.emptyList();
        }
        ArrayList<EstimatedTimetableSubscriptionRecord> records = new ArrayList<EstimatedTimetableSubscriptionRecord>();
        for (EstimatedTimetableSubscriptionStructure request : subscriptionRequests) {
            records.add(SubscriptionConverter.convert(request));
        }
        return records;
    }

    private static EstimatedTimetableSubscriptionRecord convert(EstimatedTimetableSubscriptionStructure request) {
        if (request == null) {
            return null;
        }
        return EstimatedTimetableSubscriptionRecord.newBuilder().setSubscriberRef(SubscriptionConverter.getValue(request.getSubscriberRef())).setSubscriptionIdentifier(SubscriptionConverter.getValue(request.getSubscriptionIdentifier())).setIncrementalUpdates(request.isIncrementalUpdates()).setChangeBeforeUpdates(SubscriptionConverter.convert(request.getChangeBeforeUpdates())).setInitialTerminationTime(SubscriptionConverter.convert(request.getInitialTerminationTime())).setEstimatedTimetableRequest(SubscriptionConverter.convert(request.getEstimatedTimetableRequest())).build();
    }

    private static EstimatedTimetableRequestRecord convert(EstimatedTimetableRequestStructure request) {
        if (request == null) {
            return null;
        }
        return EstimatedTimetableRequestRecord.newBuilder().setVersion((CharSequence)request.getVersion()).setRequestTimestamp(SubscriptionConverter.convert(request.getRequestTimestamp())).setPreviewInterval(SubscriptionConverter.convert(request.getPreviewInterval())).setMessageIdentifier(SubscriptionConverter.getValue(request.getMessageIdentifier())).build();
    }

    private static SubscriptionContextRecord convert(SubscriptionContextStructure subscriptionContext) {
        if (subscriptionContext == null) {
            return null;
        }
        return SubscriptionContextRecord.newBuilder().setHeartbeatInterval(SubscriptionConverter.convert(subscriptionContext.getHeartbeatInterval())).build();
    }

    public static SubscriptionResponseRecord convert(SubscriptionResponseStructure response) {
        if (response == null) {
            return null;
        }
        return SubscriptionResponseRecord.newBuilder().setRequestMessageRef(SubscriptionConverter.getValue(response.getRequestMessageRef())).setResponderRef(SubscriptionConverter.getValue(response.getResponderRef())).setResponseTimestamp(SubscriptionConverter.convert(response.getResponseTimestamp())).setResponseStatuses(SubscriptionConverter.convertResponseStatuses(response.getResponseStatuses())).build();
    }

    private static List<ResponseStatusRecord> convertResponseStatuses(List<ResponseStatus> statuses) {
        if (SubscriptionConverter.isNullOrEmpty(statuses)) {
            return Collections.emptyList();
        }
        ArrayList<ResponseStatusRecord> records = new ArrayList<ResponseStatusRecord>();
        for (ResponseStatus status : statuses) {
            records.add(SubscriptionConverter.convert(status));
        }
        return records;
    }

    private static ResponseStatusRecord convert(ResponseStatus status) {
        return ResponseStatusRecord.newBuilder().setResponseTimestamp(SubscriptionConverter.convert(status.getResponseTimestamp())).setRequestMessageRef(SubscriptionConverter.getValue(status.getRequestMessageRef())).setStatus(status.isStatus()).setErrorText(SubscriptionConverter.convert(status.getErrorCondition())).build();
    }

    private static CharSequence convert(ServiceDeliveryErrorConditionElement errorCondition) {
        if (errorCondition == null || errorCondition.getOtherError() == null) {
            return null;
        }
        return errorCondition.getOtherError().getErrorText();
    }

    public static TerminateSubscriptionRequestRecord convert(TerminateSubscriptionRequestStructure request) {
        if (request == null) {
            return null;
        }
        return TerminateSubscriptionRequestRecord.newBuilder().setMessageIdentifier(SubscriptionConverter.getValue(request.getMessageIdentifier())).setRequestorRef(SubscriptionConverter.getValue(request.getRequestorRef())).setRequestTimestamp(SubscriptionConverter.convert(request.getRequestTimestamp())).setSubscriptionRefs(SubscriptionConverter.getValues(request.getSubscriptionReves())).build();
    }

    public static TerminateSubscriptionResponseRecord convert(TerminateSubscriptionResponseStructure request) {
        if (request == null) {
            return null;
        }
        return TerminateSubscriptionResponseRecord.newBuilder().setResponseTimestamp(SubscriptionConverter.convert(request.getResponseTimestamp())).setStatuses(SubscriptionConverter.convertStatuses(request.getTerminationResponseStatuses())).build();
    }

    private static List<TerminationResponseStatusRecord> convertStatuses(List<TerminationResponseStatusStructure> statuses) {
        if (SubscriptionConverter.isNullOrEmpty(statuses)) {
            return Collections.emptyList();
        }
        ArrayList<TerminationResponseStatusRecord> records = new ArrayList<TerminationResponseStatusRecord>();
        for (TerminationResponseStatusStructure status : statuses) {
            records.add(SubscriptionConverter.convert(status));
        }
        return records;
    }

    private static TerminationResponseStatusRecord convert(TerminationResponseStatusStructure status) {
        return TerminationResponseStatusRecord.newBuilder().setResponseTimestamp(SubscriptionConverter.convert(status.getResponseTimestamp())).setStatus(status.isStatus()).setSubscriberRef(SubscriptionConverter.getValue(status.getSubscriberRef())).setRequestMessageRef(SubscriptionConverter.getValue(status.getRequestMessageRef())).setErrorText((CharSequence)SubscriptionConverter.convert(status.getErrorCondition())).build();
    }

    private static String convert(TerminationResponseStatusStructure.ErrorCondition errorCondition) {
        if (errorCondition != null && errorCondition.getOtherError() != null && errorCondition.getOtherError() != null) {
            return errorCondition.getOtherError().getErrorText();
        }
        return null;
    }

    static List<VehicleMonitoringRequestRecord> convertVmServiceRequests(List<VehicleMonitoringRequestStructure> requests) {
        if (SubscriptionConverter.isNullOrEmpty(requests)) {
            return Collections.emptyList();
        }
        ArrayList<VehicleMonitoringRequestRecord> result = new ArrayList<VehicleMonitoringRequestRecord>();
        for (VehicleMonitoringRequestStructure request : requests) {
            result.add(SubscriptionConverter.convert(request));
        }
        return result;
    }

    static List<EstimatedTimetableRequestRecord> convertEtServiceRequests(List<EstimatedTimetableRequestStructure> requests) {
        if (SubscriptionConverter.isNullOrEmpty(requests)) {
            return Collections.emptyList();
        }
        ArrayList<EstimatedTimetableRequestRecord> result = new ArrayList<EstimatedTimetableRequestRecord>();
        for (EstimatedTimetableRequestStructure request : requests) {
            result.add(SubscriptionConverter.convert(request));
        }
        return result;
    }

    static List<SituationExchangeRequestRecord> convertSxServiceRequests(List<SituationExchangeRequestStructure> requests) {
        if (SubscriptionConverter.isNullOrEmpty(requests)) {
            return Collections.emptyList();
        }
        ArrayList<SituationExchangeRequestRecord> result = new ArrayList<SituationExchangeRequestRecord>();
        for (SituationExchangeRequestStructure request : requests) {
            result.add(SubscriptionConverter.convert(request));
        }
        return result;
    }
}

