/*
 * Decompiled with CFR 0.152.
 */
package org.entur.siri.validator;

import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.entur.siri.UnsupportedSiriVersionException;
import org.entur.siri.validator.SiriValidationEventHandler;
import org.xml.sax.SAXException;
import uk.org.siri.siri20.Siri;

public class SiriValidator {
    private static JAXBContext siri10jaxbContext;
    private static JAXBContext siri13jaxbContext;
    private static JAXBContext siri14jaxbContext;
    private static JAXBContext siri20jaxbContext;
    private static JAXBContext siri21jaxbContext;

    private static void init() throws JAXBException {
        if (siri10jaxbContext == null) {
            siri10jaxbContext = JAXBContext.newInstance((Class[])new Class[]{uk.org.siri.siri10.Siri.class});
        }
        if (siri13jaxbContext == null) {
            siri13jaxbContext = JAXBContext.newInstance((Class[])new Class[]{uk.org.siri.siri13.Siri.class});
        }
        if (siri14jaxbContext == null) {
            siri14jaxbContext = JAXBContext.newInstance((Class[])new Class[]{uk.org.siri.siri14.Siri.class});
        }
        if (siri20jaxbContext == null) {
            siri20jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Siri.class});
        }
        if (siri21jaxbContext == null) {
            siri21jaxbContext = JAXBContext.newInstance((Class[])new Class[]{uk.org.siri.siri21.Siri.class});
        }
    }

    public static boolean validate(String xml, Version version) throws JAXBException, SAXException {
        return SiriValidator.validate(xml, version, System.out);
    }

    public static SiriValidationEventHandler validateAndGetHandler(String xml, Version version) throws JAXBException, SAXException {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = sf.newSchema(SiriValidator.getXsdRelativePath(version));
        Unmarshaller unmarshaller = SiriValidator.getVersionSpecificUnmarshaller(version);
        unmarshaller.setSchema(schema);
        SiriValidationEventHandler handler = new SiriValidationEventHandler();
        unmarshaller.setEventHandler((ValidationEventHandler)handler);
        unmarshaller.unmarshal((Reader)new StringReader(xml));
        return handler;
    }

    public static boolean validate(String xml, Version version, PrintStream out) throws JAXBException, SAXException {
        SiriValidationEventHandler handler = SiriValidator.validateAndGetHandler(xml, version);
        out.println("Found " + handler.events.size() + " errors");
        handler.events.forEach(event -> {
            out.println();
            out.println("EVENT");
            out.println("SEVERITY:  " + event.getSeverity());
            out.println("MESSAGE:  " + event.getMessage());
            out.println("LINKED EXCEPTION:  " + event.getLinkedException());
            out.println("LOCATOR");
            out.println("    LINE NUMBER:  " + event.getLocator().getLineNumber());
            out.println("    COLUMN NUMBER:  " + event.getLocator().getColumnNumber());
            out.println("    OFFSET:  " + event.getLocator().getOffset());
            out.println("    OBJECT:  " + event.getLocator().getObject());
            out.println("    NODE:  " + event.getLocator().getNode());
            out.println("    URL:  " + event.getLocator().getURL());
        });
        return handler.events.size() == 0;
    }

    private static Unmarshaller getVersionSpecificUnmarshaller(Version version) throws JAXBException {
        switch (version) {
            case VERSION_1_0: {
                return siri10jaxbContext.createUnmarshaller();
            }
            case VERSION_1_3: {
                return siri13jaxbContext.createUnmarshaller();
            }
            case VERSION_1_4: {
                return siri14jaxbContext.createUnmarshaller();
            }
            case VERSION_2_0: {
                return siri20jaxbContext.createUnmarshaller();
            }
            case VERSION_2_1: {
                return siri21jaxbContext.createUnmarshaller();
            }
        }
        throw new UnsupportedSiriVersionException(version);
    }

    private static URL getXsdRelativePath(Version version) {
        String path;
        switch (version) {
            case VERSION_1_0: {
                path = "siri-1.0/xsd/siri.xsd";
                break;
            }
            case VERSION_1_3: {
                path = "siri-1.3/xsd/siri.xsd";
                break;
            }
            case VERSION_1_4: {
                path = "siri-1.4/xsd/siri.xsd";
                break;
            }
            case VERSION_2_0: {
                path = "siri-2.0/xsd/siri.xsd";
                break;
            }
            case VERSION_2_1: {
                path = "siri-2.1/xsd/siri.xsd";
                break;
            }
            default: {
                throw new UnsupportedSiriVersionException(version);
            }
        }
        return SiriValidator.class.getClassLoader().getResource(path);
    }

    static {
        try {
            SiriValidator.init();
        }
        catch (JAXBException e) {
            throw new InstantiationError();
        }
    }

    public static enum Version {
        VERSION_1_0,
        VERSION_1_3,
        VERSION_1_4,
        VERSION_2_0,
        VERSION_2_1;

    }
}

