/*
 * Decompiled with CFR 0.152.
 */
package org.entur.siri.adapter;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Objects;

public class ZonedDateTimeAdapter {
    public static ZonedDateTime parse(String dateTime) {
        ZonedDateTime parsed;
        Objects.requireNonNull(dateTime, "dateTime");
        try {
            parsed = ZonedDateTime.parse(dateTime);
        }
        catch (DateTimeParseException e) {
            LocalDateTime parse1 = LocalDateTime.parse(dateTime, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            parsed = ZonedDateTime.ofLocal(parse1, ZoneId.systemDefault(), ZoneOffset.ofHours(0));
        }
        return parsed.withZoneSameInstant(ZoneId.systemDefault());
    }
}

