/*
 * Decompiled with CFR 0.152.
 */
package org.entur.protobuf.mapper;

import java.util.List;
import org.entur.protobuf.mapper.siri.CommonMapper;
import org.entur.protobuf.mapper.siri.EstimatedTimetableSiri2PbfMapper;
import org.entur.protobuf.mapper.siri.SituationExchangeSiri2PbfMapper;
import org.entur.protobuf.mapper.siri.VehicleMonitoringSiri2PbfMapper;
import uk.org.siri.siri20.DataReadyRequestStructure;
import uk.org.siri.siri20.EstimatedTimetableDeliveryStructure;
import uk.org.siri.siri20.ServiceDelivery;
import uk.org.siri.siri20.Siri;
import uk.org.siri.siri20.SituationExchangeDeliveryStructure;
import uk.org.siri.siri20.VehicleMonitoringDeliveryStructure;
import uk.org.siri.www.siri.DataReadyRequestStructure;
import uk.org.siri.www.siri.ServiceDeliveryType;
import uk.org.siri.www.siri.SiriType;

class Jaxb2PbfMapper
extends CommonMapper {
    Jaxb2PbfMapper() {
    }

    static SiriType map(Siri siri) {
        SiriType.Builder builder = SiriType.newBuilder();
        builder.setVersion(siri.getVersion());
        if (siri.getServiceDelivery() != null) {
            builder.setServiceDelivery(Jaxb2PbfMapper.map(siri.getServiceDelivery()));
        }
        if (siri.getDataReadyNotification() != null) {
            builder.setDataReadyNotification(Jaxb2PbfMapper.map(siri.getDataReadyNotification()));
        }
        return builder.build();
    }

    private static DataReadyRequestStructure.Builder map(DataReadyRequestStructure dataReadyNotification) {
        DataReadyRequestStructure.Builder builder = uk.org.siri.www.siri.DataReadyRequestStructure.newBuilder();
        builder.setRequestTimestamp(Jaxb2PbfMapper.map(dataReadyNotification.getRequestTimestamp()));
        return builder;
    }

    private static ServiceDeliveryType.Builder map(ServiceDelivery serviceDelivery) {
        List situationExchangeDeliveries;
        List vehicleMonitoringDeliveries;
        ServiceDeliveryType.Builder builder = ServiceDeliveryType.newBuilder();
        builder.setResponseTimestamp(Jaxb2PbfMapper.map(serviceDelivery.getResponseTimestamp()));
        if (serviceDelivery.getProducerRef() != null) {
            builder.setProducerRef(Jaxb2PbfMapper.map(serviceDelivery.getProducerRef()));
        }
        builder.setMoreData(serviceDelivery.isMoreData() != null && serviceDelivery.isMoreData() != false);
        List estimatedTimetableDeliveries = serviceDelivery.getEstimatedTimetableDeliveries();
        if (estimatedTimetableDeliveries != null) {
            for (EstimatedTimetableDeliveryStructure estimatedTimetableDelivery : estimatedTimetableDeliveries) {
                builder.addEstimatedTimetableDelivery(EstimatedTimetableSiri2PbfMapper.map(estimatedTimetableDelivery));
            }
        }
        if ((vehicleMonitoringDeliveries = serviceDelivery.getVehicleMonitoringDeliveries()) != null) {
            for (VehicleMonitoringDeliveryStructure vehicleMonitoringDeliveryStructure : vehicleMonitoringDeliveries) {
                builder.addVehicleMonitoringDelivery(VehicleMonitoringSiri2PbfMapper.map(vehicleMonitoringDeliveryStructure));
            }
        }
        if ((situationExchangeDeliveries = serviceDelivery.getSituationExchangeDeliveries()) != null) {
            for (SituationExchangeDeliveryStructure situationExchangeDeliveryStructure : situationExchangeDeliveries) {
                builder.addSituationExchangeDelivery(SituationExchangeSiri2PbfMapper.map(situationExchangeDeliveryStructure));
            }
        }
        return builder;
    }
}

