/*
 * Decompiled with CFR 0.152.
 */
package org.entur.protobuf.mapper;

import org.entur.protobuf.mapper.siri.CommonMapper;
import org.entur.protobuf.mapper.siri.EstimatedTimetablePbf2SiriMapper;
import org.entur.protobuf.mapper.siri.SituationExchangePbf2SiriMapper;
import org.entur.protobuf.mapper.siri.VehicleMonitoringPbf2SiriMapper;
import uk.org.siri.siri20.DataReadyRequestStructure;
import uk.org.siri.siri20.ServiceDelivery;
import uk.org.siri.siri20.Siri;
import uk.org.siri.www.siri.EstimatedTimetableDeliveryStructure;
import uk.org.siri.www.siri.ServiceDeliveryType;
import uk.org.siri.www.siri.SiriType;
import uk.org.siri.www.siri.SituationExchangeDeliveryStructure;
import uk.org.siri.www.siri.VehicleMonitoringDeliveryStructure;

class Pbf2JaxbMapper
extends CommonMapper {
    Pbf2JaxbMapper() {
    }

    static Siri map(SiriType siri) {
        Siri mapped = new Siri();
        mapped.setVersion(siri.getVersion());
        if (siri.hasServiceDelivery()) {
            mapped.setServiceDelivery(Pbf2JaxbMapper.map(siri.getServiceDelivery()));
        }
        if (siri.hasDataReadyNotification()) {
            mapped.setDataReadyNotification(Pbf2JaxbMapper.map(siri.getDataReadyNotification()));
        }
        return mapped;
    }

    private static DataReadyRequestStructure map(uk.org.siri.www.siri.DataReadyRequestStructure dataReadyNotification) {
        DataReadyRequestStructure mapped = new DataReadyRequestStructure();
        mapped.setRequestTimestamp(Pbf2JaxbMapper.map(dataReadyNotification.getRequestTimestamp()));
        return mapped;
    }

    private static ServiceDelivery map(ServiceDeliveryType serviceDelivery) {
        ServiceDelivery mapped = new ServiceDelivery();
        if (serviceDelivery.getEstimatedTimetableDeliveryList() != null) {
            for (EstimatedTimetableDeliveryStructure estimatedTimetableDeliveryStructure : serviceDelivery.getEstimatedTimetableDeliveryList()) {
                mapped.getEstimatedTimetableDeliveries().add(EstimatedTimetablePbf2SiriMapper.map(estimatedTimetableDeliveryStructure));
            }
        }
        if (serviceDelivery.getVehicleMonitoringDeliveryList() != null) {
            for (VehicleMonitoringDeliveryStructure vehicleMonitoringDeliveryStructure : serviceDelivery.getVehicleMonitoringDeliveryList()) {
                mapped.getVehicleMonitoringDeliveries().add(VehicleMonitoringPbf2SiriMapper.map(vehicleMonitoringDeliveryStructure));
            }
        }
        if (serviceDelivery.getSituationExchangeDeliveryList() != null) {
            for (SituationExchangeDeliveryStructure situationExchangeDeliveryStructure : serviceDelivery.getSituationExchangeDeliveryList()) {
                mapped.getSituationExchangeDeliveries().add(SituationExchangePbf2SiriMapper.map(situationExchangeDeliveryStructure));
            }
        }
        if (serviceDelivery.hasResponseTimestamp()) {
            mapped.setResponseTimestamp(Pbf2JaxbMapper.map(serviceDelivery.getResponseTimestamp()));
        }
        mapped.setMoreData(Boolean.valueOf(serviceDelivery.getMoreData()));
        if (serviceDelivery.hasProducerRef()) {
            mapped.setProducerRef(Pbf2JaxbMapper.map(serviceDelivery.getProducerRef()));
        }
        return mapped;
    }
}

