/*
 * Decompiled with CFR 0.152.
 */
package org.entur.protobuf.mapper.siri;

import java.io.Serializable;
import java.util.List;
import org.entur.protobuf.mapper.siri.CommonMapper;
import org.w3c.dom.Element;
import uk.org.acbs.siri20.AccessibilityAssessmentStructure;
import uk.org.acbs.siri20.AccessibilityLimitationStructure;
import uk.org.ifopt.siri20.StopPlaceComponentRefStructure;
import uk.org.ifopt.www.acsb.AccessibilityAssessmentStructure;
import uk.org.ifopt.www.acsb.AccessibilityLimitationStructure;
import uk.org.ifopt.www.acsb.AccessibilityStructure;
import uk.org.ifopt.www.ifopt.StopPlaceComponentRefStructure;
import uk.org.siri.siri20.AffectedLineStructure;
import uk.org.siri.siri20.AffectedOperatorStructure;
import uk.org.siri.siri20.AffectedRouteStructure;
import uk.org.siri.siri20.AffectedStopPlaceStructure;
import uk.org.siri.siri20.AffectedStopPointStructure;
import uk.org.siri.siri20.AffectsScopeStructure;
import uk.org.siri.siri20.BlockingStructure;
import uk.org.siri.siri20.BoardingStructure;
import uk.org.siri.siri20.CasualtiesStructure;
import uk.org.siri.siri20.DatedVehicleJourneyRef;
import uk.org.siri.siri20.DefaultedTextStructure;
import uk.org.siri.siri20.Extensions;
import uk.org.siri.siri20.HalfOpenTimestampOutputRangeStructure;
import uk.org.siri.siri20.InfoLinkStructure;
import uk.org.siri.siri20.NaturalLanguageStringStructure;
import uk.org.siri.siri20.PtConsequenceStructure;
import uk.org.siri.siri20.PtSituationElement;
import uk.org.siri.siri20.RoutePointTypeEnumeration;
import uk.org.siri.siri20.ServiceConditionEnumeration;
import uk.org.siri.siri20.SituationExchangeDeliveryStructure;
import uk.org.siri.siri20.SituationNumber;
import uk.org.siri.siri20.SituationSourceStructure;
import uk.org.siri.siri20.VehicleJourneyRef;
import uk.org.siri.www.siri.AdviceRefStructure;
import uk.org.siri.www.siri.AffectedLineStructure;
import uk.org.siri.www.siri.AffectedOperatorStructure;
import uk.org.siri.www.siri.AffectedRouteStructure;
import uk.org.siri.www.siri.AffectedStopPlaceComponentStructure;
import uk.org.siri.www.siri.AffectedStopPlaceStructure;
import uk.org.siri.www.siri.AffectedStopPointStructure;
import uk.org.siri.www.siri.AffectedVehicleJourneyStructure;
import uk.org.siri.www.siri.AffectsScopeStructure;
import uk.org.siri.www.siri.BlockingStructure;
import uk.org.siri.www.siri.BoardingStructure;
import uk.org.siri.www.siri.CasualtiesStructure;
import uk.org.siri.www.siri.DatedVehicleJourneyRefStructure;
import uk.org.siri.www.siri.DelaysStructure;
import uk.org.siri.www.siri.EasementsStructure;
import uk.org.siri.www.siri.EntryQualifierStructure;
import uk.org.siri.www.siri.ExtensionsStructure;
import uk.org.siri.www.siri.HalfOpenTimestampOutputRangeStructure;
import uk.org.siri.www.siri.InfoLinkStructure;
import uk.org.siri.www.siri.NetworkRefStructure;
import uk.org.siri.www.siri.PtAdviceStructure;
import uk.org.siri.www.siri.PtConsequenceStructure;
import uk.org.siri.www.siri.PtConsequencesStructure;
import uk.org.siri.www.siri.PtSituationElementStructure;
import uk.org.siri.www.siri.ReferencesStructure;
import uk.org.siri.www.siri.RelatedSituationStructure;
import uk.org.siri.www.siri.ReportTypeEnumeration;
import uk.org.siri.www.siri.RouteRefStructure;
import uk.org.siri.www.siri.SituationExchangeDeliveryStructure;
import uk.org.siri.www.siri.SituationSourceStructure;
import uk.org.siri.www.siri.SituationVersion;
import uk.org.siri.www.siri.VehicleJourneyRefStructure;

public class SituationExchangeSiri2PbfMapper
extends CommonMapper {
    public static SituationExchangeDeliveryStructure.Builder map(uk.org.siri.siri20.SituationExchangeDeliveryStructure situationExchangeDeliveryStructure) {
        SituationExchangeDeliveryStructure.Builder builder = SituationExchangeDeliveryStructure.newBuilder();
        if (situationExchangeDeliveryStructure.getSituations() != null) {
            builder.setSituations(SituationExchangeSiri2PbfMapper.map(situationExchangeDeliveryStructure.getSituations()));
        }
        if (situationExchangeDeliveryStructure.getResponseTimestamp() != null) {
            builder.setResponseTimestamp(SituationExchangeSiri2PbfMapper.map(situationExchangeDeliveryStructure.getResponseTimestamp()));
        }
        return builder;
    }

    private static SituationExchangeDeliveryStructure.SituationsType.Builder map(SituationExchangeDeliveryStructure.Situations situations) {
        SituationExchangeDeliveryStructure.SituationsType.Builder builder = SituationExchangeDeliveryStructure.SituationsType.newBuilder();
        List ptSituationElements = situations.getPtSituationElements();
        for (PtSituationElement ptSituationElement : ptSituationElements) {
            builder.addPtSituationElement(SituationExchangeSiri2PbfMapper.map(ptSituationElement));
        }
        return builder;
    }

    private static PtSituationElementStructure.Builder map(PtSituationElement ptSituationElement) {
        PtSituationElementStructure.Builder builder = PtSituationElementStructure.newBuilder();
        if (ptSituationElement.getCreationTime() != null) {
            builder.setCreationTime(SituationExchangeSiri2PbfMapper.map(ptSituationElement.getCreationTime()));
        }
        if (ptSituationElement.getParticipantRef() != null) {
            builder.setParticipantRef(SituationExchangeSiri2PbfMapper.map(ptSituationElement.getParticipantRef()));
        }
        if (ptSituationElement.getSituationNumber() != null) {
            builder.setSituationNumber(SituationExchangeSiri2PbfMapper.map(ptSituationElement.getSituationNumber()));
        }
        if (ptSituationElement.getSource() != null) {
            builder.setSource(SituationExchangeSiri2PbfMapper.map(ptSituationElement.getSource()));
        }
        if (ptSituationElement.getProgress() != null) {
            builder.setProgress(SituationExchangeSiri2PbfMapper.map(ptSituationElement.getProgress()));
        }
        if (ptSituationElement.getVersion() != null) {
            builder.setVersion(SituationExchangeSiri2PbfMapper.map(ptSituationElement.getVersion()));
        }
        if (ptSituationElement.getVersionedAtTime() != null) {
            builder.setVersionedAtTime(SituationExchangeSiri2PbfMapper.map(ptSituationElement.getVersionedAtTime()));
        }
        if (ptSituationElement.getValidityPeriods() != null) {
            for (HalfOpenTimestampOutputRangeStructure validityPeriod : ptSituationElement.getValidityPeriods()) {
                builder.addValidityPeriod(SituationExchangeSiri2PbfMapper.map(validityPeriod));
            }
        }
        if (ptSituationElement.getScopeType() != null) {
            builder.setScopeType(SituationExchangeSiri2PbfMapper.map(ptSituationElement.getScopeType()));
        }
        if (ptSituationElement.getUndefinedReason() != null) {
            builder.setUndefinedReason(ptSituationElement.getUndefinedReason());
        }
        if (ptSituationElement.getSeverity() != null) {
            builder.setSeverity(SituationExchangeSiri2PbfMapper.map(ptSituationElement.getSeverity()));
        }
        if (ptSituationElement.getAudience() != null) {
            builder.setAudience(SituationExchangeSiri2PbfMapper.map(ptSituationElement.getAudience()));
        }
        if (ptSituationElement.getPriority() != null) {
            builder.setPriority(ptSituationElement.getPriority().intValue());
        }
        if (ptSituationElement.getReportType() != null) {
            builder.setReportType(SituationExchangeSiri2PbfMapper.map(ptSituationElement.getReportType()));
        }
        builder.setPlanned(ptSituationElement.isPlanned() != null && ptSituationElement.isPlanned() != false);
        if (ptSituationElement.getSummaries() != null) {
            for (DefaultedTextStructure summary : ptSituationElement.getSummaries()) {
                builder.addSummary(SituationExchangeSiri2PbfMapper.map(summary));
            }
        }
        if (ptSituationElement.getDescriptions() != null) {
            for (DefaultedTextStructure description : ptSituationElement.getDescriptions()) {
                builder.addDescription(SituationExchangeSiri2PbfMapper.map(description));
            }
        }
        if (ptSituationElement.getAdvices() != null) {
            for (DefaultedTextStructure advice : ptSituationElement.getAdvices()) {
                builder.addAdvice(SituationExchangeSiri2PbfMapper.map(advice));
            }
        }
        if (ptSituationElement.getDetails() != null) {
            for (DefaultedTextStructure detail : ptSituationElement.getDetails()) {
                builder.addDetail(SituationExchangeSiri2PbfMapper.map(detail));
            }
        }
        if (ptSituationElement.getInfoLinks() != null) {
            builder.setInfoLinks(SituationExchangeSiri2PbfMapper.map(ptSituationElement.getInfoLinks()));
        }
        if (ptSituationElement.getAffects() != null) {
            builder.setAffects(SituationExchangeSiri2PbfMapper.map(ptSituationElement.getAffects()));
        }
        if (ptSituationElement.getConsequences() != null && ptSituationElement.getConsequences().getConsequences() != null && !ptSituationElement.getConsequences().getConsequences().isEmpty()) {
            builder.setConsequences(SituationExchangeSiri2PbfMapper.map(ptSituationElement.getConsequences()));
        }
        if (ptSituationElement.getReferences() != null) {
            builder.setReferences(SituationExchangeSiri2PbfMapper.map(ptSituationElement.getReferences()));
        }
        if (ptSituationElement.getExtensions() != null) {
            // empty if block
        }
        return builder;
    }

    private static AffectsScopeStructure.Builder map(uk.org.siri.siri20.AffectsScopeStructure affects) {
        AffectsScopeStructure.Builder builder = AffectsScopeStructure.newBuilder();
        if (affects.getNetworks() != null) {
            builder.setNetworks(SituationExchangeSiri2PbfMapper.map(affects.getNetworks()));
        }
        if (affects.getStopPlaces() != null) {
            builder.setStopPlaces(SituationExchangeSiri2PbfMapper.map(affects.getStopPlaces()));
        }
        if (affects.getStopPoints() != null) {
            builder.setStopPoints(SituationExchangeSiri2PbfMapper.map(affects.getStopPoints()));
        }
        if (affects.getVehicleJourneys() != null) {
            builder.setVehicleJourneys(SituationExchangeSiri2PbfMapper.map(affects.getVehicleJourneys()));
        }
        return builder;
    }

    private static AffectsScopeStructure.VehicleJourneysType.Builder map(AffectsScopeStructure.VehicleJourneys vehicleJourneys) {
        AffectsScopeStructure.VehicleJourneysType.Builder builder = AffectsScopeStructure.VehicleJourneysType.newBuilder();
        if (vehicleJourneys.getAffectedVehicleJourneies() != null) {
            for (uk.org.siri.siri20.AffectedVehicleJourneyStructure affectedVehicleJourney : vehicleJourneys.getAffectedVehicleJourneies()) {
                builder.addAffectedVehicleJourney(SituationExchangeSiri2PbfMapper.map(affectedVehicleJourney));
            }
        }
        return builder;
    }

    private static AffectedVehicleJourneyStructure.Builder map(uk.org.siri.siri20.AffectedVehicleJourneyStructure affectedVehicleJourney) {
        AffectedVehicleJourneyStructure.Builder builder = AffectedVehicleJourneyStructure.newBuilder();
        if (affectedVehicleJourney.getVehicleJourneyReves() != null) {
            for (VehicleJourneyRef vehicleJourneyRef : affectedVehicleJourney.getVehicleJourneyReves()) {
                builder.addVehicleJourneyRef(SituationExchangeSiri2PbfMapper.map(vehicleJourneyRef));
            }
        }
        if (affectedVehicleJourney.getFramedVehicleJourneyRef() != null) {
            builder.setFramedVehicleJourneyRef(SituationExchangeSiri2PbfMapper.map(affectedVehicleJourney.getFramedVehicleJourneyRef()));
        }
        if (affectedVehicleJourney.getDatedVehicleJourneyReves() != null) {
            for (DatedVehicleJourneyRef datedVehicleJourneyRef : affectedVehicleJourney.getDatedVehicleJourneyReves()) {
                builder.addDatedVehicleJourneyRef(SituationExchangeSiri2PbfMapper.map(datedVehicleJourneyRef));
            }
        }
        if (affectedVehicleJourney.getOperator() != null) {
            builder.setOperator(SituationExchangeSiri2PbfMapper.map(affectedVehicleJourney.getOperator()));
        }
        if (affectedVehicleJourney.getLineRef() != null) {
            builder.setLineRef(SituationExchangeSiri2PbfMapper.map(affectedVehicleJourney.getLineRef()));
        }
        if (affectedVehicleJourney.getRoutes() != null) {
            for (uk.org.siri.siri20.AffectedRouteStructure route : affectedVehicleJourney.getRoutes()) {
                builder.addRoute(SituationExchangeSiri2PbfMapper.map(route));
            }
        }
        if (affectedVehicleJourney.getOriginAimedDepartureTime() != null) {
            builder.setOriginAimedDepartureTime(SituationExchangeSiri2PbfMapper.map(affectedVehicleJourney.getOriginAimedDepartureTime()));
        }
        return builder;
    }

    private static DatedVehicleJourneyRefStructure.Builder map(DatedVehicleJourneyRef datedVehicleJourneyRef) {
        DatedVehicleJourneyRefStructure.Builder builder = DatedVehicleJourneyRefStructure.newBuilder();
        if (datedVehicleJourneyRef.getValue() != null && !datedVehicleJourneyRef.getValue().isEmpty()) {
            builder.setValue(datedVehicleJourneyRef.getValue());
        }
        return builder;
    }

    private static VehicleJourneyRefStructure.Builder map(VehicleJourneyRef vehicleJourneyRef) {
        return VehicleJourneyRefStructure.newBuilder().setValue(vehicleJourneyRef.getValue());
    }

    private static AffectsScopeStructure.StopPointsType.Builder map(AffectsScopeStructure.StopPoints stopPoints) {
        AffectsScopeStructure.StopPointsType.Builder builder = AffectsScopeStructure.StopPointsType.newBuilder();
        if (stopPoints.getAffectedStopPoints() != null) {
            for (AffectedStopPointStructure affectedStopPoint : stopPoints.getAffectedStopPoints()) {
                AffectedRouteStructure.StopPointsType.SequenceWrapper_StopPointsType.Builder stop = SituationExchangeSiri2PbfMapper.map(affectedStopPoint);
                builder.addAffectedStopPoint(stop.getAffectedStopPoint());
            }
        }
        return builder;
    }

    private static AffectsScopeStructure.StopPlacesType.Builder map(AffectsScopeStructure.StopPlaces stopPlaces) {
        AffectsScopeStructure.StopPlacesType.Builder builder = AffectsScopeStructure.StopPlacesType.newBuilder();
        if (stopPlaces.getAffectedStopPlaces() != null) {
            for (AffectedStopPlaceStructure affectedStopPlace : stopPlaces.getAffectedStopPlaces()) {
                builder.addAffectedStopPlace(SituationExchangeSiri2PbfMapper.map(affectedStopPlace));
            }
        }
        return builder;
    }

    private static AffectedStopPlaceStructure.Builder map(AffectedStopPlaceStructure affectedStopPlace) {
        AffectedStopPlaceStructure.Builder builder = uk.org.siri.www.siri.AffectedStopPlaceStructure.newBuilder();
        if (affectedStopPlace.getStopPlaceRef() != null) {
            builder.setStopPlaceRef(SituationExchangeSiri2PbfMapper.map(affectedStopPlace.getStopPlaceRef()));
        }
        if (affectedStopPlace.getPlaceNames() != null) {
            for (NaturalLanguageStringStructure placeName : affectedStopPlace.getPlaceNames()) {
                builder.addPlaceName(SituationExchangeSiri2PbfMapper.map(placeName));
            }
        }
        if (affectedStopPlace.getAffectedComponents() != null) {
            builder.setAffectedComponents(SituationExchangeSiri2PbfMapper.map(affectedStopPlace.getAffectedComponents()));
        }
        if (affectedStopPlace.getAccessibilityAssessment() != null) {
            builder.setAccessibilityAssessment(SituationExchangeSiri2PbfMapper.map(affectedStopPlace.getAccessibilityAssessment()));
        }
        return builder;
    }

    private static AccessibilityAssessmentStructure.Builder map(AccessibilityAssessmentStructure accessibilityAssessment) {
        AccessibilityAssessmentStructure.Builder builder = uk.org.ifopt.www.acsb.AccessibilityAssessmentStructure.newBuilder();
        builder.setMobilityImpairedAccess(accessibilityAssessment.isMobilityImpairedAccess());
        if (accessibilityAssessment.getLimitations() != null) {
            builder.setLimitations(SituationExchangeSiri2PbfMapper.map(accessibilityAssessment.getLimitations()));
        }
        return builder;
    }

    private static AccessibilityAssessmentStructure.LimitationsType.Builder map(AccessibilityAssessmentStructure.Limitations limitations) {
        AccessibilityAssessmentStructure.LimitationsType.Builder builder = AccessibilityAssessmentStructure.LimitationsType.newBuilder();
        if (limitations.getAccessibilityLimitations() != null) {
            for (AccessibilityLimitationStructure accessibilityLimitation : limitations.getAccessibilityLimitations()) {
                builder.addAccessibilityLimitation(SituationExchangeSiri2PbfMapper.map(accessibilityLimitation));
            }
        }
        return builder;
    }

    private static AccessibilityLimitationStructure.Builder map(AccessibilityLimitationStructure accessibilityLimitation) {
        AccessibilityLimitationStructure.Builder builder = uk.org.ifopt.www.acsb.AccessibilityLimitationStructure.newBuilder();
        if (accessibilityLimitation.getWheelchairAccess() != null) {
            builder.setWheelchairAccess(SituationExchangeSiri2PbfMapper.map(accessibilityLimitation.getWheelchairAccess()));
        }
        if (accessibilityLimitation.getStepFreeAccess() != null) {
            builder.setStepFreeAccess(SituationExchangeSiri2PbfMapper.map(accessibilityLimitation.getStepFreeAccess()));
        }
        if (accessibilityLimitation.getEscalatorFreeAccess() != null) {
            builder.setEscalatorFreeAccess(SituationExchangeSiri2PbfMapper.map(accessibilityLimitation.getEscalatorFreeAccess()));
        }
        if (accessibilityLimitation.getLiftFreeAccess() != null) {
            builder.setLiftFreeAccess(SituationExchangeSiri2PbfMapper.map(accessibilityLimitation.getLiftFreeAccess()));
        }
        return builder;
    }

    private static AccessibilityStructure.Builder map(uk.org.acbs.siri20.AccessibilityStructure accessibilityStructure) {
        return AccessibilityStructure.newBuilder().setValue(accessibilityStructure.getValue().value());
    }

    private static AffectedStopPlaceStructure.AffectedComponentsType.Builder map(AffectedStopPlaceStructure.AffectedComponents affectedComponents) {
        AffectedStopPlaceStructure.AffectedComponentsType.Builder builder = AffectedStopPlaceStructure.AffectedComponentsType.newBuilder();
        if (affectedComponents.getAffectedComponents() != null) {
            for (uk.org.siri.siri20.AffectedStopPlaceComponentStructure affectedComponent : affectedComponents.getAffectedComponents()) {
                builder.addAffectedComponent(SituationExchangeSiri2PbfMapper.map(affectedComponent));
            }
        }
        return builder;
    }

    private static AffectedStopPlaceComponentStructure.Builder map(uk.org.siri.siri20.AffectedStopPlaceComponentStructure affectedComponent) {
        AffectedStopPlaceComponentStructure.Builder builder = AffectedStopPlaceComponentStructure.newBuilder();
        if (affectedComponent.getComponentRef() != null) {
            builder.setComponentRef(SituationExchangeSiri2PbfMapper.map(affectedComponent.getComponentRef()));
        }
        if (affectedComponent.getComponentType() != null) {
            builder.setComponentType(SituationExchangeSiri2PbfMapper.map(affectedComponent.getComponentType()));
        }
        if (affectedComponent.getAccessFeatureType() != null) {
            builder.setAccessFeatureType(SituationExchangeSiri2PbfMapper.map(affectedComponent.getAccessFeatureType()));
        }
        return builder;
    }

    private static StopPlaceComponentRefStructure.Builder map(StopPlaceComponentRefStructure componentRef) {
        return uk.org.ifopt.www.ifopt.StopPlaceComponentRefStructure.newBuilder().setValue(componentRef.getValue());
    }

    private static AffectsScopeStructure.NetworksType.Builder map(AffectsScopeStructure.Networks networks) {
        AffectsScopeStructure.NetworksType.Builder builder = AffectsScopeStructure.NetworksType.newBuilder();
        if (networks.getAffectedNetworks() != null) {
            for (AffectsScopeStructure.Networks.AffectedNetwork affectedNetwork : networks.getAffectedNetworks()) {
                builder.addAffectedNetwork(SituationExchangeSiri2PbfMapper.map(affectedNetwork));
            }
        }
        return builder;
    }

    private static AffectsScopeStructure.NetworksType.AffectedNetworkType.Builder map(AffectsScopeStructure.Networks.AffectedNetwork affectedNetwork) {
        AffectsScopeStructure.NetworksType.AffectedNetworkType.Builder builder = AffectsScopeStructure.NetworksType.AffectedNetworkType.newBuilder();
        if (affectedNetwork.getAffectedOperators() != null) {
            for (AffectedOperatorStructure affectedOperator : affectedNetwork.getAffectedOperators()) {
                builder.addAffectedOperator(SituationExchangeSiri2PbfMapper.map(affectedOperator));
            }
        }
        if (affectedNetwork.getNetworkRef() != null) {
            builder.setNetworkRef(SituationExchangeSiri2PbfMapper.map(affectedNetwork.getNetworkRef()));
        }
        if (affectedNetwork.getVehicleMode() != null) {
            builder.setVehicleMode(SituationExchangeSiri2PbfMapper.map(affectedNetwork.getVehicleMode()));
        }
        if (affectedNetwork.getAirSubmode() != null) {
            builder.setAirSubmode(SituationExchangeSiri2PbfMapper.map(affectedNetwork.getAirSubmode()));
        }
        if (affectedNetwork.getBusSubmode() != null) {
            builder.setBusSubmode(SituationExchangeSiri2PbfMapper.map(affectedNetwork.getBusSubmode()));
        }
        if (affectedNetwork.getCoachSubmode() != null) {
            builder.setCoachSubmode(SituationExchangeSiri2PbfMapper.map(affectedNetwork.getCoachSubmode()));
        }
        if (affectedNetwork.getMetroSubmode() != null) {
            builder.setMetroSubmode(SituationExchangeSiri2PbfMapper.map(affectedNetwork.getMetroSubmode()));
        }
        if (affectedNetwork.getRailSubmode() != null) {
            builder.setRailSubmode(SituationExchangeSiri2PbfMapper.map(affectedNetwork.getRailSubmode()));
        }
        if (affectedNetwork.getTramSubmode() != null) {
            builder.setTramSubmode(SituationExchangeSiri2PbfMapper.map(affectedNetwork.getTramSubmode()));
        }
        if (affectedNetwork.getWaterSubmode() != null) {
            builder.setWaterSubmode(SituationExchangeSiri2PbfMapper.map(affectedNetwork.getWaterSubmode()));
        }
        if (affectedNetwork.getAffectedLines() != null) {
            for (uk.org.siri.siri20.AffectedLineStructure affectedLine : affectedNetwork.getAffectedLines()) {
                builder.addAffectedLine(SituationExchangeSiri2PbfMapper.map(affectedLine));
            }
        }
        return builder;
    }

    private static AffectedLineStructure.Builder map(uk.org.siri.siri20.AffectedLineStructure affectedLine) {
        AffectedLineStructure.Builder builder = AffectedLineStructure.newBuilder();
        if (affectedLine.getLineRef() != null) {
            builder.setLineRef(SituationExchangeSiri2PbfMapper.map(affectedLine.getLineRef()));
        }
        if (affectedLine.getRoutes() != null) {
            builder.setRoutes(SituationExchangeSiri2PbfMapper.map(affectedLine.getRoutes()));
        }
        if (affectedLine.getPublishedLineName() != null) {
            builder.setPublishedLineName(SituationExchangeSiri2PbfMapper.map(affectedLine.getPublishedLineName()));
        }
        return builder;
    }

    private static AffectedLineStructure.RoutesType.Builder map(AffectedLineStructure.Routes routes) {
        AffectedLineStructure.RoutesType.Builder builder = AffectedLineStructure.RoutesType.newBuilder();
        if (routes.getAffectedRoutes() != null) {
            for (uk.org.siri.siri20.AffectedRouteStructure affectedRoute : routes.getAffectedRoutes()) {
                builder.addAffectedRoute(SituationExchangeSiri2PbfMapper.map(affectedRoute));
            }
        }
        return builder;
    }

    private static AffectedRouteStructure.Builder map(uk.org.siri.siri20.AffectedRouteStructure affectedRoute) {
        AffectedRouteStructure.Builder builder = AffectedRouteStructure.newBuilder();
        if (affectedRoute.getRouteRef() != null) {
            builder.setRouteRef(SituationExchangeSiri2PbfMapper.map(affectedRoute.getRouteRef()));
        }
        if (affectedRoute.getStopPoints() != null) {
            builder.setStopPoints(SituationExchangeSiri2PbfMapper.map(affectedRoute.getStopPoints()));
        }
        return builder;
    }

    private static AffectedRouteStructure.StopPointsType.Builder map(AffectedRouteStructure.StopPoints stopPoints) {
        AffectedRouteStructure.StopPointsType.Builder builder = AffectedRouteStructure.StopPointsType.newBuilder();
        if (stopPoints.getAffectedStopPointsAndLinkProjectionToNextStopPoints() != null) {
            for (Serializable stopPoint : stopPoints.getAffectedStopPointsAndLinkProjectionToNextStopPoints()) {
                if (!(stopPoint instanceof AffectedStopPointStructure)) continue;
                AffectedStopPointStructure affectedStopPoint = (AffectedStopPointStructure)stopPoint;
                builder.addSequenceWrapper(SituationExchangeSiri2PbfMapper.map(affectedStopPoint));
            }
        }
        builder.setAffectedOnly(stopPoints.isAffectedOnly() != null && stopPoints.isAffectedOnly() != false);
        return builder;
    }

    private static AffectedRouteStructure.StopPointsType.SequenceWrapper_StopPointsType.Builder map(AffectedStopPointStructure affectedStopPoint) {
        AffectedRouteStructure.StopPointsType.SequenceWrapper_StopPointsType.Builder builder = AffectedRouteStructure.StopPointsType.SequenceWrapper_StopPointsType.newBuilder();
        AffectedStopPointStructure.Builder stopPoint = uk.org.siri.www.siri.AffectedStopPointStructure.newBuilder();
        if (affectedStopPoint.getStopPointRef() != null) {
            stopPoint.setStopPointRef(SituationExchangeSiri2PbfMapper.map(affectedStopPoint.getStopPointRef()));
        }
        if (affectedStopPoint.getStopPointNames() != null) {
            for (NaturalLanguageStringStructure stopPointName : affectedStopPoint.getStopPointNames()) {
                stopPoint.addStopPointName(SituationExchangeSiri2PbfMapper.map(stopPointName));
            }
        }
        if (affectedStopPoint.getStopConditions() != null) {
            for (RoutePointTypeEnumeration stopCondition : affectedStopPoint.getStopConditions()) {
                stopPoint.addStopCondition(SituationExchangeSiri2PbfMapper.map(stopCondition));
            }
        }
        if (affectedStopPoint.getStopPointType() != null) {
            stopPoint.setStopPointType(SituationExchangeSiri2PbfMapper.map(affectedStopPoint.getStopPointType()));
        }
        if (affectedStopPoint.getLocation() != null) {
            stopPoint.setLocation(SituationExchangeSiri2PbfMapper.map(affectedStopPoint.getLocation()));
        }
        builder.setAffectedStopPoint(stopPoint);
        return builder;
    }

    private static RouteRefStructure.Builder map(uk.org.siri.siri20.RouteRefStructure routeRef) {
        RouteRefStructure.Builder builder = RouteRefStructure.newBuilder();
        builder.setValue(routeRef.getValue());
        return builder;
    }

    private static NetworkRefStructure.Builder map(uk.org.siri.siri20.NetworkRefStructure networkRef) {
        NetworkRefStructure.Builder builder = NetworkRefStructure.newBuilder();
        builder.setValue(networkRef.getValue());
        return builder;
    }

    private static AffectedOperatorStructure.Builder map(AffectedOperatorStructure affectedOperator) {
        AffectedOperatorStructure.Builder builder = uk.org.siri.www.siri.AffectedOperatorStructure.newBuilder();
        if (affectedOperator.getOperatorRef() != null) {
            builder.setOperatorRef(SituationExchangeSiri2PbfMapper.map(affectedOperator.getOperatorRef()));
        }
        return builder;
    }

    private static PtSituationElementStructure.InfoLinksType.Builder map(PtSituationElement.InfoLinks infoLinks) {
        PtSituationElementStructure.InfoLinksType.Builder builder = PtSituationElementStructure.InfoLinksType.newBuilder();
        if (infoLinks.getInfoLinks() != null) {
            for (InfoLinkStructure infoLink : infoLinks.getInfoLinks()) {
                builder.addInfoLink(SituationExchangeSiri2PbfMapper.map(infoLink));
            }
        }
        return builder;
    }

    private static InfoLinkStructure.Builder map(InfoLinkStructure infoLink) {
        InfoLinkStructure.Builder builder = uk.org.siri.www.siri.InfoLinkStructure.newBuilder();
        if (infoLink.getLabels() != null) {
            for (NaturalLanguageStringStructure label : infoLink.getLabels()) {
                builder.addLabel(SituationExchangeSiri2PbfMapper.map(label));
            }
        }
        if (infoLink.getUri() != null) {
            builder.setUri(infoLink.getUri());
        }
        return builder;
    }

    private static ReportTypeEnumeration map(String reportType) {
        if (reportType.equals("general")) {
            return ReportTypeEnumeration.REPORT_TYPE_ENUMERATION_GENERAL;
        }
        if (reportType.equals("incident")) {
            return ReportTypeEnumeration.REPORT_TYPE_ENUMERATION_INCIDENT;
        }
        return null;
    }

    private static HalfOpenTimestampOutputRangeStructure.Builder map(HalfOpenTimestampOutputRangeStructure validityPeriod) {
        HalfOpenTimestampOutputRangeStructure.Builder builder = uk.org.siri.www.siri.HalfOpenTimestampOutputRangeStructure.newBuilder();
        if (validityPeriod.getStartTime() != null) {
            builder.setStartTime(SituationExchangeSiri2PbfMapper.map(validityPeriod.getStartTime()));
        }
        if (validityPeriod.getEndTime() != null) {
            builder.setEndTime(SituationExchangeSiri2PbfMapper.map(validityPeriod.getEndTime()));
        }
        return builder;
    }

    private static SituationVersion.Builder map(uk.org.siri.siri20.SituationVersion version) {
        SituationVersion.Builder builder = SituationVersion.newBuilder();
        builder.setValue(version.getValue().intValue());
        return builder;
    }

    private static SituationSourceStructure.Builder map(SituationSourceStructure source) {
        SituationSourceStructure.Builder builder = uk.org.siri.www.siri.SituationSourceStructure.newBuilder();
        if (source.getSourceType() != null) {
            builder.setSourceType(SituationExchangeSiri2PbfMapper.map(source.getSourceType()));
        }
        if (source.getPhone() != null && !source.getPhone().isEmpty()) {
            builder.setPhone(source.getPhone());
        }
        if (source.getAgentReference() != null && !source.getAgentReference().isEmpty()) {
            builder.setAgentReference(source.getAgentReference());
        }
        if (source.getTimeOfCommunication() != null) {
            builder.setTimeOfCommunication(SituationExchangeSiri2PbfMapper.map(source.getTimeOfCommunication()));
        }
        return builder;
    }

    private static EntryQualifierStructure.Builder map(SituationNumber situationNumber) {
        EntryQualifierStructure.Builder builder = EntryQualifierStructure.newBuilder();
        builder.setValue(situationNumber.getValue());
        return builder;
    }

    private static PtConsequencesStructure.Builder map(uk.org.siri.siri20.PtConsequencesStructure consequences) {
        PtConsequencesStructure.Builder builder = PtConsequencesStructure.newBuilder();
        if (consequences != null && consequences.getConsequences() != null && !consequences.getConsequences().isEmpty()) {
            for (PtConsequenceStructure consequence : consequences.getConsequences()) {
                builder.addConsequence(SituationExchangeSiri2PbfMapper.map(consequence));
            }
        }
        return builder;
    }

    private static PtConsequenceStructure.Builder map(PtConsequenceStructure consequence) {
        PtConsequenceStructure.Builder builder = uk.org.siri.www.siri.PtConsequenceStructure.newBuilder();
        if (consequence.getAdvice() != null) {
            builder.setAdvice(SituationExchangeSiri2PbfMapper.map(consequence.getAdvice()));
        }
        if (consequence.getAffects() != null) {
            builder.setAffects(SituationExchangeSiri2PbfMapper.map(consequence.getAffects()));
        }
        if (consequence.getBlocking() != null) {
            builder.setBlocking(SituationExchangeSiri2PbfMapper.map(consequence.getBlocking()));
        }
        if (consequence.getBoarding() != null) {
            builder.setBoarding(SituationExchangeSiri2PbfMapper.map(consequence.getBoarding()));
        }
        if (consequence.getCasualties() != null) {
            builder.setCasualties(SituationExchangeSiri2PbfMapper.map(consequence.getCasualties()));
        }
        if (consequence.getConditions() != null && !consequence.getConditions().isEmpty()) {
            for (ServiceConditionEnumeration condition : consequence.getConditions()) {
                builder.addCondition(SituationExchangeSiri2PbfMapper.map(condition));
            }
        }
        if (consequence.getDelays() != null) {
            builder.setDelays(SituationExchangeSiri2PbfMapper.map(consequence.getDelays()));
        }
        if (consequence.getEasements() != null && !consequence.getEasements().isEmpty()) {
            for (uk.org.siri.siri20.EasementsStructure easement : consequence.getEasements()) {
                builder.addEasements(SituationExchangeSiri2PbfMapper.map(easement));
            }
        }
        if (consequence.getPeriod() != null) {
            builder.setPeriod(SituationExchangeSiri2PbfMapper.map(consequence.getPeriod()));
        }
        if (consequence.getSeverity() != null) {
            builder.setSeverity(SituationExchangeSiri2PbfMapper.map(consequence.getSeverity()));
        }
        return builder;
    }

    private static PtAdviceStructure.Builder map(uk.org.siri.siri20.PtAdviceStructure advice) {
        PtAdviceStructure.Builder builder = PtAdviceStructure.newBuilder();
        if (advice.getAdviceRef() != null) {
            builder.setAdviceRef(SituationExchangeSiri2PbfMapper.map(advice.getAdviceRef()));
        }
        if (advice.getDetails() != null && !advice.getDetails().isEmpty()) {
            for (NaturalLanguageStringStructure detail : advice.getDetails()) {
                builder.addDetails(SituationExchangeSiri2PbfMapper.map(detail));
            }
        }
        return builder;
    }

    private static AdviceRefStructure.Builder map(uk.org.siri.siri20.AdviceRefStructure adviceRef) {
        AdviceRefStructure.Builder builder = AdviceRefStructure.newBuilder();
        builder.setValue(adviceRef.getValue());
        return builder;
    }

    private static BlockingStructure.Builder map(BlockingStructure blocking) {
        BlockingStructure.Builder builder = uk.org.siri.www.siri.BlockingStructure.newBuilder();
        if (blocking.isJourneyPlanner() != null) {
            builder.setJourneyPlanner(blocking.isJourneyPlanner().booleanValue());
        }
        if (blocking.isRealTime() != null) {
            builder.setRealTime(blocking.isRealTime().booleanValue());
        }
        return builder;
    }

    private static BoardingStructure.Builder map(BoardingStructure boarding) {
        BoardingStructure.Builder builder = uk.org.siri.www.siri.BoardingStructure.newBuilder();
        if (boarding.getArrivalBoardingActivity() != null) {
            builder.setArrivalBoardingActivity(SituationExchangeSiri2PbfMapper.map(boarding.getArrivalBoardingActivity()));
        }
        if (boarding.getDepartureBoardingActivity() != null) {
            builder.setDepartureBoardingActivity(SituationExchangeSiri2PbfMapper.map(boarding.getDepartureBoardingActivity()));
        }
        return builder;
    }

    private static CasualtiesStructure.Builder map(CasualtiesStructure boarding) {
        CasualtiesStructure.Builder builder = uk.org.siri.www.siri.CasualtiesStructure.newBuilder();
        if (boarding.getNumberOfDeaths() != null) {
            builder.setNumberOfDeaths(boarding.getNumberOfDeaths().intValue());
        }
        if (boarding.getNumberOfInjured() != null) {
            builder.setNumberOfInjured(boarding.getNumberOfInjured().intValue());
        }
        return builder;
    }

    private static DelaysStructure.Builder map(uk.org.siri.siri20.DelaysStructure delays) {
        DelaysStructure.Builder builder = DelaysStructure.newBuilder();
        if (delays.getDelay() != null) {
            builder.setDelay(SituationExchangeSiri2PbfMapper.map(delays.getDelay()));
        }
        if (delays.getDelayBand() != null) {
            builder.setDelayBand(SituationExchangeSiri2PbfMapper.map(delays.getDelayBand()));
        }
        if (delays.getDelayType() != null) {
            builder.setDelayType(SituationExchangeSiri2PbfMapper.map(delays.getDelayType()));
        }
        return builder;
    }

    private static EasementsStructure.Builder map(uk.org.siri.siri20.EasementsStructure easement) {
        EasementsStructure.Builder builder = EasementsStructure.newBuilder();
        builder.setEasementRef(easement.getEasementRef());
        if (easement.getEasements() != null && !easement.getEasements().isEmpty()) {
            for (NaturalLanguageStringStructure easementLanguageStructure : easement.getEasements()) {
                builder.addEasement(SituationExchangeSiri2PbfMapper.map(easementLanguageStructure));
            }
        }
        if (easement.getTicketRestrictions() != null) {
            builder.setTicketRestrictions(SituationExchangeSiri2PbfMapper.map(easement.getTicketRestrictions()));
        }
        return builder;
    }

    private static ReferencesStructure.Builder map(uk.org.siri.siri20.ReferencesStructure references) {
        ReferencesStructure.Builder builder = ReferencesStructure.newBuilder();
        if (references.getRelatedToReves() != null && !references.getRelatedToReves().isEmpty()) {
            for (uk.org.siri.siri20.RelatedSituationStructure reference : references.getRelatedToReves()) {
                builder.addRelatedToRef(SituationExchangeSiri2PbfMapper.map(reference));
            }
        }
        return builder;
    }

    private static RelatedSituationStructure.Builder map(uk.org.siri.siri20.RelatedSituationStructure reference) {
        RelatedSituationStructure.Builder builder = RelatedSituationStructure.newBuilder();
        if (reference.getCountryRef() != null) {
            builder.setCountryRef(SituationExchangeSiri2PbfMapper.map(reference.getCountryRef()));
        }
        if (reference.getCreationTime() != null) {
            builder.setCreationTime(SituationExchangeSiri2PbfMapper.map(reference.getCreationTime()));
        }
        if (reference.getExternalReference() != null) {
            builder.setExternalReference(reference.getExternalReference());
        }
        if (reference.getParticipantRef() != null) {
            builder.setParticipantRef(SituationExchangeSiri2PbfMapper.map(reference.getParticipantRef()));
        }
        if (reference.getRelatedAs() != null) {
            builder.setRelatedAs(SituationExchangeSiri2PbfMapper.map(reference.getRelatedAs()));
        }
        if (reference.getSituationNumber() != null) {
            builder.setSituationNumber(SituationExchangeSiri2PbfMapper.map(reference.getSituationNumber()));
        }
        if (reference.getUpdateCountryRef() != null) {
            builder.setUpdateCountryRef(SituationExchangeSiri2PbfMapper.map(reference.getUpdateCountryRef()));
        }
        if (reference.getUpdateParticipantRef() != null) {
            builder.setUpdateParticipantRef(SituationExchangeSiri2PbfMapper.map(reference.getUpdateParticipantRef()));
        }
        if (reference.getVersion() != null) {
            builder.setVersion(SituationExchangeSiri2PbfMapper.map(reference.getVersion()));
        }
        return builder;
    }

    private static ExtensionsStructure.Builder map(Extensions extensions) {
        ExtensionsStructure.Builder builder = ExtensionsStructure.newBuilder();
        if (extensions.getAnies() != null && !extensions.getAnies().isEmpty()) {
            for (Element any : extensions.getAnies()) {
                builder.addAny(SituationExchangeSiri2PbfMapper.map(any));
            }
        }
        return builder;
    }
}

