/*
 * Decompiled with CFR 0.152.
 */
package org.enumerable.lambda.enumerable;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.enumerable.lambda.Fn0;
import org.enumerable.lambda.Fn1;
import org.enumerable.lambda.Fn2;
import org.enumerable.lambda.enumerable.Range;
import org.enumerable.lambda.enumerable.collection.EList;
import org.enumerable.lambda.enumerable.collection.EMap;
import org.enumerable.lambda.enumerable.collection.ESet;
import org.enumerable.lambda.enumerable.collection.EnumerableModule;
import org.enumerable.lambda.enumerable.collection.IEnumerable;
import org.enumerable.lambda.exception.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Enumerable {
    public static <E> boolean all(Iterable<E> collection, Fn1<? super E, ?> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).all(block);
    }

    public static <E> boolean all(Iterable<E> collection) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).all();
    }

    public static <E> boolean any(Iterable<E> collection, Fn1<? super E, ?> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).any(block);
    }

    public static <E> boolean any(Iterable<E> collection) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).any();
    }

    public static <E, R> EList<R> collect(Iterable<E> collection, Fn1<? super E, ? extends R> block) {
        return EnumerableModule.extend(collection).collect(block);
    }

    public static <E> int count(Iterable<E> collection) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).count();
    }

    public static <E> int count(Iterable<E> collection, E obj) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).count(obj);
    }

    public static <E> int count(Iterable<E> collection, Fn1<? super E, Boolean> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).count(block);
    }

    public static <E, R> EList<E> cycle(Iterable<E> collection, int times, Fn1<? super E, R> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).cycle(times, (Fn1)block);
    }

    public static <E> E detect(Iterable<E> collection, Fn1<? super E, Boolean> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).detect(block);
    }

    public static <E> E detect(Iterable<E> collection, Fn0<E> ifNone, Fn1<? super E, Boolean> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).detect(ifNone, block);
    }

    public static <E> EList<E> drop(Iterable<E> collection, int n) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).drop(n);
    }

    public static <E> EList<E> dropWhile(Iterable<E> collection, Fn1<? super E, Boolean> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).dropWhile(block);
    }

    public static <E, R> IEnumerable<E> each(Iterable<E> collection, Fn1<? super E, R> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).each((Fn1)block);
    }

    public static <K, V, R> EMap<K, V> each(Map<K, V> map, Fn2<? super K, ? super V, R> block) {
        return EnumerableModule.extend(map).each(block);
    }

    public static <E, R> Object eachCons(Iterable<E> collection, int n, Fn1<List<E>, R> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).eachCons(n, block);
    }

    public static <K, V, R> EMap<K, V> eachKey(Map<K, V> map, Fn1<? super K, ? super R> block) {
        return EnumerableModule.extend(map).eachKey(block);
    }

    public static <R> File eachLine(File file, Fn1<String, R> block) {
        try {
            Enumerable.eachLine(new FileReader(file), block);
            return file;
        }
        catch (FileNotFoundException e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static <R> Reader eachLine(Reader reader, Fn1<String, R> block) {
        try {
            String line;
            BufferedReader in = new BufferedReader(reader);
            while ((line = in.readLine()) != null) {
                block.call(line);
            }
            Reader reader2 = reader;
            return reader2;
        }
        catch (IOException e) {
            throw UncheckedException.uncheck(e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException silent) {}
        }
    }

    public static <R> String eachLine(String string, Fn1<String, R> block) {
        Enumerable.eachLine(new StringReader(string), block);
        return string;
    }

    public static <E, R> Object eachSlice(Iterable<E> collection, int n, Fn1<List<E>, R> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).eachSlice(n, block);
    }

    public static <K, V, R> EMap<K, V> eachValue(Map<K, V> map, Fn1<? super V, ? super R> block) {
        return EnumerableModule.extend(map).eachValue(block);
    }

    public static <E, R> IEnumerable<E> eachWithIndex(Iterable<E> collection, Fn2<? super E, Integer, R> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).eachWithIndex((Fn2)block);
    }

    public static <E, M, R> M eachWithObject(Iterable<E> collection, M memo, Fn2<? super E, M, R> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).eachWithObject(memo, block);
    }

    public static <E> EList<E> entries(Iterable<E> collection) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).toList();
    }

    public static <E> E find(Iterable<E> collection, Fn1<? super E, Boolean> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).find(block);
    }

    public static <E> E find(Iterable<E> collection, Fn0<E> ifNone, Fn1<? super E, Boolean> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).find(ifNone, block);
    }

    public static <E> EList<E> findAll(Iterable<E> collection, Fn1<? super E, Boolean> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).findAll(block);
    }

    public static <E> int findIndex(Iterable<E> collection, Fn1<? super E, Boolean> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).findIndex(block);
    }

    public static <E> E first(Iterable<E> collection) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).first();
    }

    public static <E> EList<E> first(Iterable<E> collection, int n) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).first(n);
    }

    public static <E> EList<E> grep(Iterable<E> collection, Pattern pattern) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).grep(pattern);
    }

    public static <E, R> EList<R> grep(Iterable<E> collection, Pattern pattern, Fn1<? super E, R> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).grep(pattern, block);
    }

    public static <E> EList<E> grep(Iterable<E> collection, String pattern) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).grep(pattern);
    }

    public static <E, R> EList<R> grep(Iterable<E> collection, String pattern, Fn1<? super E, R> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).grep(pattern, block);
    }

    public static <E, R> EMap<R, EList<E>> groupBy(Iterable<E> collection, Fn1<? super E, R> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).groupBy(block);
    }

    public static <R> Fn0<R> ifNone(R defaultValue) {
        return Fn0.constant(defaultValue);
    }

    public static <E> boolean include(Iterable<E> collection, Object obj) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).include(obj);
    }

    public static <E> E inject(Iterable<E> collection, Fn2<? super E, ? super E, ? extends E> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).inject(block);
    }

    public static <E, R> R inject(Iterable<E> collection, R initial, Fn2<? super R, ? super E, ? extends R> block) {
        return EnumerableModule.extend(collection).inject(initial, block);
    }

    public static <E, R> EList<R> map(Iterable<E> collection, Fn1<? super E, ? extends R> block) {
        return EnumerableModule.extend(collection).map(block);
    }

    public static <E> E max(Iterable<E> collection) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).max();
    }

    public static <E> E max(Iterable<E> collection, Fn2<? super E, ? super E, Integer> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).max(block);
    }

    public static <E, R> E maxBy(Iterable<E> collection, Fn1<? super E, R> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).maxBy(block);
    }

    public static <E> boolean member(Iterable<E> collection, Object obj) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).include(obj);
    }

    public static <E> E min(Iterable<E> collection) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).min();
    }

    public static <E> E min(Iterable<E> collection, Fn2<? super E, ? super E, Integer> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).min(block);
    }

    public static <E, R> E minBy(Iterable<E> collection, Fn1<? super E, R> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).minBy(block);
    }

    public static <E> EList<E> minMax(Iterable<E> collection) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).minMax();
    }

    public static <E> EList<E> minMax(Iterable<E> collection, Fn2<? super E, ? super E, Integer> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).minMax(block);
    }

    public static <E, R> EList<E> minMaxBy(Iterable<E> collection, Fn1<? super E, R> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).minMaxBy(block);
    }

    public static <E> boolean none(Iterable<E> collection, Fn1<? super E, ?> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).none(block);
    }

    public static <E> boolean none(Iterable<E> collection) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).none();
    }

    public static <E> boolean one(Iterable<E> collection, Fn1<? super E, ?> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).one(block);
    }

    public static <E> boolean one(Iterable<E> collection) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).one();
    }

    public static <E> EList<EList<E>> partition(Iterable<E> collection, Fn1<? super E, Boolean> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).partition(block);
    }

    public static Range range(int start, int end) {
        return Enumerable.range(start, end, false);
    }

    public static Range range(int start, int end, boolean exclusive) {
        return new Range(start, end, exclusive);
    }

    public static <E> E reduce(Iterable<E> collection, Fn2<? super E, ? super E, ? extends E> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).reduce(block);
    }

    public static <E, R> R reduce(Iterable<E> collection, R initial, Fn2<? super R, ? super E, ? extends R> block) {
        return EnumerableModule.extend(collection).reduce(initial, block);
    }

    public static <E> EList<E> reject(Iterable<E> collection, Fn1<? super E, Boolean> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).reject(block);
    }

    public static <E, R> IEnumerable<E> reverseEach(Iterable<E> collection, Fn1<? super E, R> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).reverseEach((Fn1)block);
    }

    public static <E> EList<E> select(Iterable<E> collection, Fn1<? super E, Boolean> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).select(block);
    }

    public static <K, V> EList<Map.Entry<K, V>> select(Map<K, V> map, Fn2<? super K, ? super V, Boolean> block) {
        return EnumerableModule.extend(map).select(block);
    }

    public static <E> EList<E> sort(Iterable<E> collection) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).sort();
    }

    public static <E> EList<E> sort(Iterable<E> collection, Fn2<? super E, ? super E, Integer> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).sort(block);
    }

    public static <E, R> EList<E> sortBy(Iterable<E> collection, Fn1<? super E, R> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).sortBy(block);
    }

    public static <E> EList<E> take(Iterable<E> collection, int n) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).take(n);
    }

    public static <E> EList<E> takeWhile(Iterable<E> collection, Fn1<? super E, Boolean> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).takeWhile(block);
    }

    public static int times(int i, Fn0<?> block) {
        Iterator<Integer> range = Enumerable.range(0, i, true).iterator();
        while (range.hasNext()) {
            block.call();
            range.next();
        }
        return i;
    }

    public static int times(int i, Fn1<Integer, ?> block) {
        Enumerable.each(Enumerable.range(0, i, true), block);
        return i;
    }

    public static <E> EList<E> toList(Iterable<E> collection) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).toList();
    }

    public static <E> ESet<E> toSet(Iterable<E> collection) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).toSet();
    }

    public static <E, R> ESet<R> toSet(Iterable<E> collection, Fn1<? super E, R> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).toSet(block);
    }

    public static <E, R> Object zip(Iterable<E> collection, List<Iterable<?>> args, Fn1<? super EList<?>, R> block) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).zip(args, block);
    }

    public static <E> EList<EList<?>> zip(Iterable<E> collection, Iterable<?> ... args) {
        return ((EnumerableModule)EnumerableModule.extend(collection)).zip(args);
    }
}

