/*
 * Decompiled with CFR 0.152.
 */
package org.enumerable.lambda.enumerable.collection;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import org.enumerable.lambda.enumerable.collection.EList;
import org.enumerable.lambda.enumerable.collection.EMap;
import org.enumerable.lambda.enumerable.collection.ESet;
import org.enumerable.lambda.enumerable.collection.Pair;
import org.enumerable.lambda.exception.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ECollections {
    public static <A, B> EMap<A, B> map(Map.Entry<A, B> ... entries) {
        EMap<A, B> map = new EMap<A, B>(new HashMap(entries.length));
        for (Map.Entry<A, B> entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static <A, B> EMap<A, B> map(Collection<Map.Entry<A, B>> entries) {
        EMap<A, B> map = new EMap<A, B>(new HashMap(entries.size()));
        for (Map.Entry<A, B> pair : entries) {
            map.put(pair.getKey(), pair.getValue());
        }
        return map;
    }

    public static <A, B> EMap<A, B> orderedMap(Map.Entry<A, B> ... entries) {
        EMap<A, B> map = new EMap<A, B>(new LinkedHashMap(entries.length));
        for (Map.Entry<A, B> entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static <A, B> EMap<A, B> orderedMap(Collection<Map.Entry<A, B>> entries) {
        EMap<A, B> map = new EMap<A, B>(new LinkedHashMap(entries.size()));
        for (Map.Entry<A, B> pair : entries) {
            map.put(pair.getKey(), pair.getValue());
        }
        return map;
    }

    public static <E> ESet<E> set(E ... elements) {
        ESet<E> set = new ESet<E>(new HashSet(elements.length));
        set.addAll(Arrays.asList(elements));
        return set;
    }

    public static <E> ESet<E> sortedSet(E ... elements) {
        ESet<E> set = new ESet<E>(new TreeSet());
        set.addAll(Arrays.asList(elements));
        return set;
    }

    public static <E> EList<E> list(E ... elements) {
        EList<E> list = new EList<E>(elements.length);
        list.addAll(Arrays.asList(elements));
        return list;
    }

    public static <A, B> Pair<A, B> pair(A first, B second) {
        return new Pair<A, B>(first, second);
    }

    public static <A, B> Pair<A, B> cons(A first, B second) {
        return ECollections.pair(first, second);
    }

    public static EList<String> lines(String string) {
        return ECollections.lines(new StringReader(string));
    }

    public static EList<String> lines(Reader reader) {
        try {
            EList<String> result = new EList<String>();
            BufferedReader bufferedReader = new BufferedReader(reader);
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                result.add(line);
            }
            return result;
        }
        catch (IOException e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static EList<Character> chars(String string) {
        EList<Character> result = new EList<Character>();
        for (char c : string.toCharArray()) {
            result.add(Character.valueOf(c));
        }
        return result;
    }
}

