/*
 * Decompiled with CFR 0.152.
 */
package org.enumerable.lambda.enumerable.primitives;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.enumerable.lambda.enumerable.Enumerable;
import org.enumerable.lambda.enumerable.collection.EList;
import org.enumerable.lambda.enumerable.collection.ESet;
import org.enumerable.lambda.primitives.Fn1DtoB;
import org.enumerable.lambda.primitives.Fn1DtoD;
import org.enumerable.lambda.primitives.Fn1DtoI;
import org.enumerable.lambda.primitives.Fn1DtoL;
import org.enumerable.lambda.primitives.Fn1DtoO;
import org.enumerable.lambda.primitives.Fn2DDtoD;
import org.enumerable.lambda.primitives.Fn2DDtoO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumerableDoubles {
    public static <E> boolean all(double[] array, Fn1DtoB block) {
        for (double each : array) {
            if (block.call(each)) continue;
            return false;
        }
        return true;
    }

    public static <E> boolean any(double[] array, Fn1DtoB block) {
        for (double each : array) {
            if (!block.call(each)) continue;
            return true;
        }
        return false;
    }

    public static <R> Object[] collect(double[] array, Fn1DtoO<R> block) {
        Object[] result = new Object[array.length];
        int i = 0;
        for (double each : array) {
            result[i++] = block.call(each);
        }
        return result;
    }

    public static double[] collect(double[] array, Fn1DtoD block) {
        double[] result = new double[array.length];
        int i = 0;
        for (double each : array) {
            result[i++] = block.call(each);
        }
        return result;
    }

    public static int[] collect(double[] array, Fn1DtoI block) {
        int[] result = new int[array.length];
        int i = 0;
        for (double each : array) {
            result[i++] = block.call(each);
        }
        return result;
    }

    public static long[] collect(double[] array, Fn1DtoL block) {
        long[] result = new long[array.length];
        int i = 0;
        for (double each : array) {
            result[i++] = block.call(each);
        }
        return result;
    }

    public static <R> R[] collect(double[] array, Fn1DtoO<R> block, Class<R> type) {
        Object[] result = (Object[])Array.newInstance(type, array.length);
        int i = 0;
        for (double each : array) {
            result[i++] = block.call(each);
        }
        return result;
    }

    public static double detect(double[] array, double ifNone, Fn1DtoB block) {
        for (double each : array) {
            if (!block.call(each)) continue;
            return each;
        }
        return ifNone;
    }

    public static <R> double[] each(double[] array, Fn1DtoO<R> block) {
        for (double each : array) {
            block.call(each);
        }
        return array;
    }

    public static double[] each(double[] array, Fn1DtoD block) {
        for (double each : array) {
            block.call(each);
        }
        return array;
    }

    public static double[] each(double[] array, Fn1DtoI block) {
        for (double each : array) {
            block.call(each);
        }
        return array;
    }

    public static double[] each(double[] array, Fn1DtoL block) {
        for (double each : array) {
            block.call(each);
        }
        return array;
    }

    public static double[] each(double[] array, Fn1DtoB block) {
        for (double each : array) {
            block.call(each);
        }
        return array;
    }

    public static <R> double[] eachWithIndex(double[] array, Fn2DDtoO<R> block) {
        double idx = 0.0;
        for (double each : array) {
            double d = idx;
            idx = d + 1.0;
            block.call(each, d);
        }
        return array;
    }

    public static double[] eachWithIndex(double[] array, Fn2DDtoD block) {
        double idx = 0.0;
        for (double each : array) {
            double d = idx;
            idx = d + 1.0;
            block.call(each, d);
        }
        return array;
    }

    public static <E> EList<Double> entries(double[] array) {
        return EnumerableDoubles.toList(array);
    }

    public static double find(double[] array, double ifNone, Fn1DtoB block) {
        return EnumerableDoubles.detect(array, ifNone, block);
    }

    public static double[] findAll(double[] array, Fn1DtoB block) {
        return EnumerableDoubles.select(array, block);
    }

    public static double ifNone(double defaultValue) {
        return defaultValue;
    }

    public static boolean include(double[] array, double value) {
        return EnumerableDoubles.member(array, value);
    }

    public static double inject(double[] array, Fn2DDtoD block) {
        double initial = array[0];
        for (int i = 1; i < array.length; ++i) {
            initial = block.call(initial, array[i]);
        }
        return initial;
    }

    public static double inject(double[] array, double initial, Fn2DDtoD block) {
        for (double each : array) {
            initial = block.call(initial, each);
        }
        return initial;
    }

    public static <R> Object[] map(double[] array, Fn1DtoO<R> block) {
        return EnumerableDoubles.collect(array, block);
    }

    public static double[] map(double[] array, Fn1DtoD block) {
        return EnumerableDoubles.collect(array, block);
    }

    public static int[] map(double[] array, Fn1DtoI block) {
        return EnumerableDoubles.collect(array, block);
    }

    public static long[] map(double[] array, Fn1DtoL block) {
        return EnumerableDoubles.collect(array, block);
    }

    public static <R> R[] map(double[] array, Fn1DtoO<R> block, Class<R> type) {
        return EnumerableDoubles.collect(array, block, type);
    }

    public static double max(double[] array) {
        return EnumerableDoubles.min(array, new ReverseNaturalOrderDoubleComparator(new NaturalOrderPrimitiveComparator()));
    }

    public static double max(double[] array, Fn2DDtoD block) {
        return EnumerableDoubles.min(array, new ReverseNaturalOrderDoubleComparator(new BlockDoubleComparator(block)));
    }

    public static boolean member(double[] array, double value) {
        return Arrays.binarySearch(EnumerableDoubles.sort(array), value) >= 0;
    }

    public static double min(double[] array) {
        return EnumerableDoubles.min(array, new NaturalOrderPrimitiveComparator());
    }

    public static double min(double[] array, Fn2DDtoD block) {
        return EnumerableDoubles.min(array, new BlockDoubleComparator(block));
    }

    public static double[][] partition(double[] array, Fn1DtoB block) {
        double[][] result = new double[][]{EnumerableDoubles.select(array, block), EnumerableDoubles.reject(array, block)};
        return result;
    }

    public static double[] reject(double[] array, Fn1DtoB block) {
        return EnumerableDoubles.selectOrReject(array, block, false);
    }

    public static double[] select(double[] array, Fn1DtoB block) {
        return EnumerableDoubles.selectOrReject(array, block, true);
    }

    private static double[] selectOrReject(double[] array, Fn1DtoB block, boolean select) {
        double[] result = new double[array.length];
        int i = 0;
        for (double each : array) {
            if (block.call(each) != select) continue;
            result[i++] = each;
        }
        return EnumerableDoubles.copy(result, i);
    }

    public static double[] sort(double[] array) {
        double[] result = EnumerableDoubles.copy(array, array.length);
        Arrays.sort(result);
        return result;
    }

    public static EList<Double> toList(double[] array) {
        EList<Double> result = new EList<Double>(array.length);
        for (double each : array) {
            result.add(each);
        }
        return result;
    }

    public static ESet<Double> toSet(double[] array) {
        return Enumerable.toSet(EnumerableDoubles.toList(array));
    }

    public static <R> ESet<R> toSet(double[] array, Fn1DtoO<R> block) {
        return Enumerable.toSet(EnumerableDoubles.toList(array), block);
    }

    static double min(double[] array, DoubleComparator comparator) {
        double result = array[0];
        for (int i = 1; i < array.length; ++i) {
            double each = array[i];
            if (comparator.compare(each, result) >= 0) continue;
            result = each;
        }
        return result;
    }

    static double[] copy(double[] array, int length) {
        double[] result = new double[length];
        System.arraycopy(array, 0, result, 0, length);
        return result;
    }

    static class ReverseNaturalOrderDoubleComparator
    implements DoubleComparator {
        DoubleComparator comparator;

        ReverseNaturalOrderDoubleComparator(DoubleComparator comparator) {
            this.comparator = comparator;
        }

        public int compare(double a, double b) {
            return -this.comparator.compare(a, b);
        }
    }

    static class BlockDoubleComparator
    implements DoubleComparator {
        Fn2DDtoD block;

        BlockDoubleComparator(Fn2DDtoD block) {
            this.block = block;
        }

        public int compare(double a, double b) {
            return (int)this.block.call(a, b);
        }
    }

    static class NaturalOrderPrimitiveComparator
    implements DoubleComparator {
        NaturalOrderPrimitiveComparator() {
        }

        public int compare(double a, double b) {
            return Double.compare(a, b);
        }

        public int compare(long a, long b) {
            return a < b ? -1 : (a > b ? 1 : 0);
        }

        public int compare(int a, int b) {
            return a < b ? -1 : (a > b ? 1 : 0);
        }
    }

    static interface DoubleComparator {
        public int compare(double var1, double var3);
    }
}

