/*
 * Decompiled with CFR 0.152.
 */
package org.enumerable.lambda.enumerable.primitives;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.enumerable.lambda.enumerable.Enumerable;
import org.enumerable.lambda.enumerable.collection.EList;
import org.enumerable.lambda.enumerable.collection.ESet;
import org.enumerable.lambda.primitives.Fn1LtoB;
import org.enumerable.lambda.primitives.Fn1LtoD;
import org.enumerable.lambda.primitives.Fn1LtoI;
import org.enumerable.lambda.primitives.Fn1LtoL;
import org.enumerable.lambda.primitives.Fn1LtoO;
import org.enumerable.lambda.primitives.Fn2LLtoL;
import org.enumerable.lambda.primitives.Fn2LLtoO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumerableLongs {
    public static <E> boolean all(long[] array, Fn1LtoB block) {
        for (long each : array) {
            if (block.call(each)) continue;
            return false;
        }
        return true;
    }

    public static <E> boolean any(long[] array, Fn1LtoB block) {
        for (long each : array) {
            if (!block.call(each)) continue;
            return true;
        }
        return false;
    }

    public static <R> Object[] collect(long[] array, Fn1LtoO<R> block) {
        Object[] result = new Object[array.length];
        int i = 0;
        for (long each : array) {
            result[i++] = block.call(each);
        }
        return result;
    }

    public static double[] collect(long[] array, Fn1LtoD block) {
        double[] result = new double[array.length];
        int i = 0;
        for (long each : array) {
            result[i++] = block.call(each);
        }
        return result;
    }

    public static int[] collect(long[] array, Fn1LtoI block) {
        int[] result = new int[array.length];
        int i = 0;
        for (long each : array) {
            result[i++] = block.call(each);
        }
        return result;
    }

    public static long[] collect(long[] array, Fn1LtoL block) {
        long[] result = new long[array.length];
        int i = 0;
        for (long each : array) {
            result[i++] = block.call(each);
        }
        return result;
    }

    public static <R> R[] collect(long[] array, Fn1LtoO<R> block, Class<R> type) {
        Object[] result = (Object[])Array.newInstance(type, array.length);
        int i = 0;
        for (long each : array) {
            result[i++] = block.call(each);
        }
        return result;
    }

    public static long detect(long[] array, long ifNone, Fn1LtoB block) {
        for (long each : array) {
            if (!block.call(each)) continue;
            return each;
        }
        return ifNone;
    }

    public static <R> long[] each(long[] array, Fn1LtoO<R> block) {
        for (long each : array) {
            block.call(each);
        }
        return array;
    }

    public static long[] each(long[] array, Fn1LtoD block) {
        for (long each : array) {
            block.call(each);
        }
        return array;
    }

    public static long[] each(long[] array, Fn1LtoI block) {
        for (long each : array) {
            block.call(each);
        }
        return array;
    }

    public static long[] each(long[] array, Fn1LtoL block) {
        for (long each : array) {
            block.call(each);
        }
        return array;
    }

    public static long[] each(long[] array, Fn1LtoB block) {
        for (long each : array) {
            block.call(each);
        }
        return array;
    }

    public static <R> long[] eachWithIndex(long[] array, Fn2LLtoO<R> block) {
        long idx = 0L;
        for (long each : array) {
            block.call(each, idx++);
        }
        return array;
    }

    public static long[] eachWithIndex(long[] array, Fn2LLtoL block) {
        long idx = 0L;
        for (long each : array) {
            block.call(each, idx++);
        }
        return array;
    }

    public static <E> EList<Long> entries(long[] array) {
        return EnumerableLongs.toList(array);
    }

    public static long find(long[] array, long ifNone, Fn1LtoB block) {
        return EnumerableLongs.detect(array, ifNone, block);
    }

    public static long[] findAll(long[] array, Fn1LtoB block) {
        return EnumerableLongs.select(array, block);
    }

    public static long ifNone(long defaultValue) {
        return defaultValue;
    }

    public static boolean include(long[] array, long value) {
        return EnumerableLongs.member(array, value);
    }

    public static long inject(long[] array, Fn2LLtoL block) {
        long initial = array[0];
        for (int i = 1; i < array.length; ++i) {
            initial = block.call(initial, array[i]);
        }
        return initial;
    }

    public static long inject(long[] array, long initial, Fn2LLtoL block) {
        for (long each : array) {
            initial = block.call(initial, each);
        }
        return initial;
    }

    public static <R> Object[] map(long[] array, Fn1LtoO<R> block) {
        return EnumerableLongs.collect(array, block);
    }

    public static double[] map(long[] array, Fn1LtoD block) {
        return EnumerableLongs.collect(array, block);
    }

    public static int[] map(long[] array, Fn1LtoI block) {
        return EnumerableLongs.collect(array, block);
    }

    public static long[] map(long[] array, Fn1LtoL block) {
        return EnumerableLongs.collect(array, block);
    }

    public static <R> R[] map(long[] array, Fn1LtoO<R> block, Class<R> type) {
        return EnumerableLongs.collect(array, block, type);
    }

    public static long max(long[] array) {
        return EnumerableLongs.min(array, new ReverseNaturalOrderLongComparator(new NaturalOrderPrimitiveComparator()));
    }

    public static long max(long[] array, Fn2LLtoL block) {
        return EnumerableLongs.min(array, new ReverseNaturalOrderLongComparator(new BlockLongComparator(block)));
    }

    public static boolean member(long[] array, long value) {
        return Arrays.binarySearch(EnumerableLongs.sort(array), value) >= 0;
    }

    public static long min(long[] array) {
        return EnumerableLongs.min(array, new NaturalOrderPrimitiveComparator());
    }

    public static long min(long[] array, Fn2LLtoL block) {
        return EnumerableLongs.min(array, new BlockLongComparator(block));
    }

    public static long[][] partition(long[] array, Fn1LtoB block) {
        long[][] result = new long[][]{EnumerableLongs.select(array, block), EnumerableLongs.reject(array, block)};
        return result;
    }

    public static long[] reject(long[] array, Fn1LtoB block) {
        return EnumerableLongs.selectOrReject(array, block, false);
    }

    public static long[] select(long[] array, Fn1LtoB block) {
        return EnumerableLongs.selectOrReject(array, block, true);
    }

    private static long[] selectOrReject(long[] array, Fn1LtoB block, boolean select) {
        long[] result = new long[array.length];
        int i = 0;
        for (long each : array) {
            if (block.call(each) != select) continue;
            result[i++] = each;
        }
        return EnumerableLongs.copy(result, i);
    }

    public static long[] sort(long[] array) {
        long[] result = EnumerableLongs.copy(array, array.length);
        Arrays.sort(result);
        return result;
    }

    public static EList<Long> toList(long[] array) {
        EList<Long> result = new EList<Long>(array.length);
        for (long each : array) {
            result.add(each);
        }
        return result;
    }

    public static ESet<Long> toSet(long[] array) {
        return Enumerable.toSet(EnumerableLongs.toList(array));
    }

    public static <R> ESet<R> toSet(long[] array, Fn1LtoO<R> block) {
        return Enumerable.toSet(EnumerableLongs.toList(array), block);
    }

    static long min(long[] array, LongComparator comparator) {
        long result = array[0];
        for (int i = 1; i < array.length; ++i) {
            long each = array[i];
            if (comparator.compare(each, result) >= 0) continue;
            result = each;
        }
        return result;
    }

    static long[] copy(long[] array, int length) {
        long[] result = new long[length];
        System.arraycopy(array, 0, result, 0, length);
        return result;
    }

    static class ReverseNaturalOrderLongComparator
    implements LongComparator {
        LongComparator comparator;

        ReverseNaturalOrderLongComparator(LongComparator comparator) {
            this.comparator = comparator;
        }

        public int compare(long a, long b) {
            return -this.comparator.compare(a, b);
        }
    }

    static class BlockLongComparator
    implements LongComparator {
        Fn2LLtoL block;

        BlockLongComparator(Fn2LLtoL block) {
            this.block = block;
        }

        public int compare(long a, long b) {
            return (int)this.block.call(a, b);
        }
    }

    static class NaturalOrderPrimitiveComparator
    implements LongComparator {
        NaturalOrderPrimitiveComparator() {
        }

        public int compare(double a, double b) {
            return Double.compare(a, b);
        }

        public int compare(long a, long b) {
            return a < b ? -1 : (a > b ? 1 : 0);
        }

        public int compare(int a, int b) {
            return a < b ? -1 : (a > b ? 1 : 0);
        }
    }

    static interface LongComparator {
        public int compare(long var1, long var3);
    }
}

