/*
 * Decompiled with CFR 0.152.
 */
package org.enumerable.lambda.support.expression;

import japa.parser.ast.expr.ArrayAccessExpr;
import japa.parser.ast.expr.ArrayCreationExpr;
import japa.parser.ast.expr.ArrayInitializerExpr;
import japa.parser.ast.expr.AssignExpr;
import japa.parser.ast.expr.BinaryExpr;
import japa.parser.ast.expr.BooleanLiteralExpr;
import japa.parser.ast.expr.CastExpr;
import japa.parser.ast.expr.ClassExpr;
import japa.parser.ast.expr.ConditionalExpr;
import japa.parser.ast.expr.DoubleLiteralExpr;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.FieldAccessExpr;
import japa.parser.ast.expr.InstanceOfExpr;
import japa.parser.ast.expr.IntegerLiteralExpr;
import japa.parser.ast.expr.LongLiteralExpr;
import japa.parser.ast.expr.MethodCallExpr;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.NullLiteralExpr;
import japa.parser.ast.expr.ObjectCreationExpr;
import japa.parser.ast.expr.StringLiteralExpr;
import japa.parser.ast.expr.ThisExpr;
import japa.parser.ast.expr.UnaryExpr;
import japa.parser.ast.type.ClassOrInterfaceType;
import japa.parser.ast.type.PrimitiveType;
import japa.parser.ast.type.ReferenceType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.enumerable.lambda.support.expression.LambdaExpressionTrees;
import org.enumerable.lambda.weaving.asm.Opcodes;
import org.enumerable.lambda.weaving.asm.Type;
import org.enumerable.lambda.weaving.asm.tree.AbstractInsnNode;
import org.enumerable.lambda.weaving.asm.tree.FieldInsnNode;
import org.enumerable.lambda.weaving.asm.tree.IincInsnNode;
import org.enumerable.lambda.weaving.asm.tree.IntInsnNode;
import org.enumerable.lambda.weaving.asm.tree.LdcInsnNode;
import org.enumerable.lambda.weaving.asm.tree.LocalVariableNode;
import org.enumerable.lambda.weaving.asm.tree.MethodInsnNode;
import org.enumerable.lambda.weaving.asm.tree.MethodNode;
import org.enumerable.lambda.weaving.asm.tree.TypeInsnNode;
import org.enumerable.lambda.weaving.asm.tree.VarInsnNode;
import org.enumerable.lambda.weaving.asm.tree.analysis.Analyzer;
import org.enumerable.lambda.weaving.asm.tree.analysis.AnalyzerException;
import org.enumerable.lambda.weaving.asm.tree.analysis.Frame;
import org.enumerable.lambda.weaving.asm.tree.analysis.Interpreter;
import org.enumerable.lambda.weaving.asm.tree.analysis.Value;
import org.enumerable.lambda.weaving.asm.util.AbstractVisitor;

public class ExpressionInterpreter
implements Opcodes,
Interpreter {
    static final PrimitiveType PRIMITIVE_BOOLEAN = new PrimitiveType(PrimitiveType.Primitive.Boolean);
    static final PrimitiveType PRIMITIVE_INT = new PrimitiveType(PrimitiveType.Primitive.Int);
    static final PrimitiveType PRIMITIVE_FLOAT = new PrimitiveType(PrimitiveType.Primitive.Float);
    static final PrimitiveType PRIMITIVE_LONG = new PrimitiveType(PrimitiveType.Primitive.Long);
    static final PrimitiveType PRIMITIVE_DOUBLE = new PrimitiveType(PrimitiveType.Primitive.Double);
    static final PrimitiveType PRIMITIVE_CHAR = new PrimitiveType(PrimitiveType.Primitive.Char);
    static final PrimitiveType PRIMITIVE_BYTE = new PrimitiveType(PrimitiveType.Primitive.Byte);
    static final PrimitiveType PRIMITIVE_SHORT = new PrimitiveType(PrimitiveType.Primitive.Short);
    LocalVariableNode[] parameters;
    Frame currentFrame;
    Analyzer analyzer;
    MethodNode mn;
    Expression expression;
    UnaryExpr iinc;
    AssignExpr iincAssign;
    ExpressionValue assign;
    ConditionalExpr conditional;
    boolean cmpConditional;
    Set<Integer> returns = new HashSet<Integer>();

    ExpressionInterpreter(MethodNode mn, LocalVariableNode ... parameters) {
        this.mn = mn;
        this.parameters = parameters;
    }

    void setCurrentFrame(Frame frame) {
        ExpressionValue previous;
        ExpressionValue value;
        this.currentFrame = frame;
        if (this.iinc != null) {
            if (frame.getStackSize() > 0) {
                value = new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, (Expression)this.iinc);
                previous = (ExpressionValue)frame.pop();
                if (previous.type == PRIMITIVE_INT && previous.expression instanceof NameExpr) {
                    frame.push(value);
                    this.iinc = null;
                } else {
                    frame.push(previous);
                }
            } else if (this.iinc.getOperator() == UnaryExpr.Operator.posIncrement) {
                this.iinc.setOperator(UnaryExpr.Operator.preIncrement);
            } else {
                this.iinc.setOperator(UnaryExpr.Operator.preDecrement);
            }
        }
        if (this.iincAssign != null && frame.getStackSize() > 0) {
            value = new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, (Expression)this.iincAssign);
            previous = (ExpressionValue)frame.pop();
            if (previous.type == PRIMITIVE_INT && previous.expression instanceof NameExpr) {
                frame.push(value);
                this.iincAssign = null;
            } else {
                frame.push(previous);
            }
        }
        if (this.assign != null && frame.getStackSize() > 0) {
            frame.pop();
            frame.push(this.assign);
            this.assign = null;
        }
    }

    void newControlFlowEdge(int insn, int successor) {
    }

    public Value newValue(Type type) {
        if (type == null) {
            return new ExpressionValue(null, null);
        }
        Expression value = null;
        switch (type.getSort()) {
            case 0: {
                return null;
            }
            case 1: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_BOOLEAN, value);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, value);
            }
            case 6: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_FLOAT, value);
            }
            case 7: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_LONG, value);
            }
            case 8: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_DOUBLE, value);
            }
            case 9: 
            case 10: {
                return new ExpressionValue((japa.parser.ast.type.Type)this.createClassOrInterfaceType(this.removeJavaLang(type.getClassName())), value);
            }
        }
        throw new Error("Internal error");
    }

    public Value newOperation(AbstractInsnNode insn) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 1: {
                return new ExpressionValue((japa.parser.ast.type.Type)this.createClassOrInterfaceType(Object.class.getName()), (Expression)new NullLiteralExpr());
            }
            case 2: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, (Expression)new UnaryExpr((Expression)new IntegerLiteralExpr("1"), UnaryExpr.Operator.negative));
            }
            case 3: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, (Expression)new IntegerLiteralExpr("0"));
            }
            case 4: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, (Expression)new IntegerLiteralExpr("1"));
            }
            case 5: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, (Expression)new IntegerLiteralExpr("2"));
            }
            case 6: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, (Expression)new IntegerLiteralExpr("3"));
            }
            case 7: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, (Expression)new IntegerLiteralExpr("4"));
            }
            case 8: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, (Expression)new IntegerLiteralExpr("5"));
            }
            case 9: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_LONG, (Expression)new LongLiteralExpr("0L"));
            }
            case 10: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_LONG, (Expression)new LongLiteralExpr("1L"));
            }
            case 11: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_FLOAT, (Expression)new DoubleLiteralExpr("0.0f"));
            }
            case 12: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_FLOAT, (Expression)new DoubleLiteralExpr("1.0f"));
            }
            case 13: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_FLOAT, (Expression)new DoubleLiteralExpr("2.0f"));
            }
            case 14: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_DOUBLE, (Expression)new DoubleLiteralExpr("0.0"));
            }
            case 15: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_DOUBLE, (Expression)new DoubleLiteralExpr("1.0"));
            }
            case 16: 
            case 17: {
                int operand = ((IntInsnNode)insn).operand;
                if (operand < 0) {
                    return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, (Expression)new UnaryExpr((Expression)new IntegerLiteralExpr("" + Math.abs(operand)), UnaryExpr.Operator.negative));
                }
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, (Expression)new IntegerLiteralExpr("" + operand));
            }
            case 18: {
                Object cst = ((LdcInsnNode)insn).cst;
                if (cst instanceof Number) {
                    ExpressionValue value = null;
                    if (cst instanceof Integer) {
                        value = new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, (Expression)new IntegerLiteralExpr(cst.toString()));
                    } else if (cst instanceof Float) {
                        value = new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_FLOAT, (Expression)new DoubleLiteralExpr(cst.toString() + "f"));
                    } else if (cst instanceof Long) {
                        value = new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_LONG, (Expression)new LongLiteralExpr(cst.toString() + "L"));
                    } else if (cst instanceof Double) {
                        value = new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_DOUBLE, (Expression)new DoubleLiteralExpr(cst.toString()));
                    }
                    if (((Number)cst).intValue() < 0) {
                        StringLiteralExpr expr = (StringLiteralExpr)value.expression;
                        expr.setValue(expr.getValue().substring("-".length()));
                        value.expression = new UnaryExpr((Expression)expr, UnaryExpr.Operator.negative);
                    }
                    return value;
                }
                if (cst instanceof Type) {
                    ClassExpr classExpr = new ClassExpr((japa.parser.ast.type.Type)new ReferenceType((japa.parser.ast.type.Type)this.createClassOrInterfaceType(((Type)cst).getClassName())));
                    return new ExpressionValue((japa.parser.ast.type.Type)this.createClassOrInterfaceType(Class.class.getName()), (Expression)classExpr);
                }
                return new ExpressionValue((japa.parser.ast.type.Type)this.createClassOrInterfaceType(String.class.getName()), (Expression)new StringLiteralExpr(cst.toString()));
            }
            case 168: {
                throw new UnsupportedOperationException(AbstractVisitor.OPCODES[insn.getOpcode()]);
            }
            case 178: {
                FieldInsnNode fieldNode = (FieldInsnNode)insn;
                ExpressionValue getField = (ExpressionValue)this.newValue(Type.getType(fieldNode.desc));
                getField.expression = new FieldAccessExpr((Expression)new NameExpr(this.removeJavaLang(Type.getObjectType(fieldNode.owner).getClassName())), fieldNode.name);
                return getField;
            }
            case 187: {
                return this.newValue(Type.getObjectType(((TypeInsnNode)insn).desc));
            }
        }
        throw new Error("Internal error.");
    }

    ClassOrInterfaceType createClassOrInterfaceType(String className) {
        if (!className.contains(".")) {
            return new ClassOrInterfaceType(className);
        }
        ClassOrInterfaceType parent = null;
        for (String name : className.split("\\.")) {
            parent = new ClassOrInterfaceType(parent, name);
        }
        return parent;
    }

    LocalVariableNode getLocalVariable(int var) {
        for (LocalVariableNode local : this.parameters) {
            if (var != local.index) continue;
            return local;
        }
        return null;
    }

    String removeJavaLang(String className) {
        if (className.startsWith("java.lang.")) {
            className = className.substring("java.lang.".length());
        }
        return className;
    }

    boolean isStoreInstruction(VarInsnNode vin) {
        return vin.getOpcode() >= 54 && vin.getOpcode() <= 58;
    }

    public Value copyOperation(AbstractInsnNode insn, Value value) throws AnalyzerException {
        ExpressionValue expressionValue = (ExpressionValue)value;
        if (insn instanceof VarInsnNode) {
            VarInsnNode node = (VarInsnNode)insn;
            if (this.isStoreInstruction(node)) {
                BinaryExpr binary;
                AssignExpr.Operator op = AssignExpr.Operator.assign;
                NameExpr target = new NameExpr(this.getLocalVariable((int)node.var).name);
                Expression assignmentValue = expressionValue.expression;
                if (expressionValue.expression instanceof BinaryExpr && (binary = (BinaryExpr)expressionValue.expression).getLeft().equals((Object)target)) {
                    if (binary.getOperator() == BinaryExpr.Operator.plus) {
                        op = AssignExpr.Operator.plus;
                    }
                    if (binary.getOperator() == BinaryExpr.Operator.minus) {
                        op = AssignExpr.Operator.minus;
                    }
                    if (binary.getOperator() == BinaryExpr.Operator.times) {
                        op = AssignExpr.Operator.star;
                    }
                    if (binary.getOperator() == BinaryExpr.Operator.divide) {
                        op = AssignExpr.Operator.slash;
                    }
                    if (binary.getOperator() == BinaryExpr.Operator.binAnd) {
                        op = AssignExpr.Operator.and;
                    }
                    if (binary.getOperator() == BinaryExpr.Operator.binOr) {
                        op = AssignExpr.Operator.or;
                    }
                    if (binary.getOperator() == BinaryExpr.Operator.xor) {
                        op = AssignExpr.Operator.xor;
                    }
                    if (binary.getOperator() == BinaryExpr.Operator.remainder) {
                        op = AssignExpr.Operator.rem;
                    }
                    if (binary.getOperator() == BinaryExpr.Operator.lShift) {
                        op = AssignExpr.Operator.lShift;
                    }
                    if (binary.getOperator() == BinaryExpr.Operator.rSignedShift) {
                        op = AssignExpr.Operator.rSignedShift;
                    }
                    if (binary.getOperator() == BinaryExpr.Operator.rUnsignedShift) {
                        op = AssignExpr.Operator.rUnsignedShift;
                    }
                    if (op != AssignExpr.Operator.assign) {
                        assignmentValue = binary.getRight();
                    }
                }
                this.assign = expressionValue.expression instanceof UnaryExpr ? expressionValue : new ExpressionValue(expressionValue.type, (Expression)new AssignExpr((Expression)target, assignmentValue, op));
            } else {
                if (node.var == 0) {
                    return new ExpressionValue(expressionValue.type, (Expression)new ThisExpr());
                }
                return new ExpressionValue(expressionValue.type, (Expression)new NameExpr(this.getLocalVariable((int)node.var).name));
            }
        }
        if (expressionValue.expression == null) {
            return expressionValue;
        }
        return new ExpressionValue(expressionValue.type, LambdaExpressionTrees.parseExpression(expressionValue.expression.toString()));
    }

    public Value unaryOperation(AbstractInsnNode insn, Value value) throws AnalyzerException {
        ExpressionValue expressionValue = (ExpressionValue)value;
        switch (insn.getOpcode()) {
            case 116: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, (Expression)new UnaryExpr(expressionValue.expression, UnaryExpr.Operator.negative));
            }
            case 132: {
                IincInsnNode node = (IincInsnNode)insn;
                NameExpr nameExpr = new NameExpr(this.getLocalVariable((int)node.var).name);
                if (node.incr == 1) {
                    this.iinc = new UnaryExpr((Expression)nameExpr, UnaryExpr.Operator.posIncrement);
                }
                if (node.incr == -1) {
                    this.iinc = new UnaryExpr((Expression)nameExpr, UnaryExpr.Operator.posDecrement);
                }
                if (node.incr > 1) {
                    this.iincAssign = new AssignExpr((Expression)nameExpr, (Expression)new IntegerLiteralExpr(node.incr + ""), AssignExpr.Operator.plus);
                }
                if (node.incr < -1) {
                    this.iincAssign = new AssignExpr((Expression)nameExpr, (Expression)new IntegerLiteralExpr(-node.incr + ""), AssignExpr.Operator.minus);
                }
                return value;
            }
            case 136: 
            case 139: 
            case 142: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, (Expression)new CastExpr((japa.parser.ast.type.Type)PRIMITIVE_INT, expressionValue.expression));
            }
            case 145: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_BYTE, (Expression)new CastExpr((japa.parser.ast.type.Type)PRIMITIVE_BYTE, expressionValue.expression));
            }
            case 146: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_CHAR, (Expression)new CastExpr((japa.parser.ast.type.Type)PRIMITIVE_CHAR, expressionValue.expression));
            }
            case 147: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_SHORT, (Expression)new CastExpr((japa.parser.ast.type.Type)PRIMITIVE_SHORT, expressionValue.expression));
            }
            case 118: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_FLOAT, (Expression)new UnaryExpr(expressionValue.expression, UnaryExpr.Operator.negative));
            }
            case 134: 
            case 137: 
            case 144: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_FLOAT, (Expression)new CastExpr((japa.parser.ast.type.Type)PRIMITIVE_FLOAT, expressionValue.expression));
            }
            case 117: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_LONG, (Expression)new UnaryExpr(expressionValue.expression, UnaryExpr.Operator.negative));
            }
            case 133: 
            case 140: 
            case 143: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_LONG, (Expression)new CastExpr((japa.parser.ast.type.Type)PRIMITIVE_LONG, expressionValue.expression));
            }
            case 119: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_DOUBLE, (Expression)new UnaryExpr(expressionValue.expression, UnaryExpr.Operator.negative));
            }
            case 135: 
            case 138: 
            case 141: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_DOUBLE, (Expression)new CastExpr((japa.parser.ast.type.Type)PRIMITIVE_DOUBLE, expressionValue.expression));
            }
            case 153: {
                if (this.conditional != null) {
                    if (this.conditional.getCondition() instanceof BinaryExpr && this.cmpConditional) {
                        ((BinaryExpr)this.conditional.getCondition()).setOperator(BinaryExpr.Operator.notEquals);
                        this.cmpConditional = false;
                    } else {
                        this.handleNestedConditional(expressionValue.expression);
                    }
                } else {
                    this.conditional = new ConditionalExpr(expressionValue.expression, null, null);
                }
                return null;
            }
            case 154: {
                if (this.conditional != null) {
                    if (this.conditional.getCondition() instanceof BinaryExpr && this.cmpConditional) {
                        ((BinaryExpr)this.conditional.getCondition()).setOperator(BinaryExpr.Operator.equals);
                        this.cmpConditional = false;
                    } else {
                        this.handleNestedConditional((Expression)new UnaryExpr(expressionValue.expression, UnaryExpr.Operator.not));
                    }
                } else {
                    this.conditional = new ConditionalExpr((Expression)new UnaryExpr(expressionValue.expression, UnaryExpr.Operator.not), null, null);
                }
                return null;
            }
            case 157: {
                ((BinaryExpr)this.conditional.getCondition()).setOperator(BinaryExpr.Operator.lessEquals);
                this.cmpConditional = false;
                return null;
            }
            case 158: {
                ((BinaryExpr)this.conditional.getCondition()).setOperator(BinaryExpr.Operator.greater);
                this.cmpConditional = false;
                return null;
            }
            case 155: {
                ((BinaryExpr)this.conditional.getCondition()).setOperator(BinaryExpr.Operator.greaterEquals);
                this.cmpConditional = false;
                return null;
            }
            case 156: {
                ((BinaryExpr)this.conditional.getCondition()).setOperator(BinaryExpr.Operator.less);
                this.cmpConditional = false;
                return null;
            }
            case 170: 
            case 171: {
                throw new UnsupportedOperationException(AbstractVisitor.OPCODES[insn.getOpcode()]);
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                return null;
            }
            case 179: {
                FieldInsnNode fieldNode = (FieldInsnNode)insn;
                ExpressionValue putField = (ExpressionValue)this.newValue(Type.getType(fieldNode.desc));
                putField.expression = new AssignExpr((Expression)new FieldAccessExpr((Expression)new NameExpr(this.removeJavaLang(Type.getObjectType(fieldNode.owner).getClassName())), fieldNode.name), expressionValue.expression, AssignExpr.Operator.assign);
                this.assign = putField;
                return null;
            }
            case 180: {
                FieldInsnNode fieldNode = (FieldInsnNode)insn;
                ExpressionValue getField = (ExpressionValue)this.newValue(Type.getType(fieldNode.desc));
                getField.expression = new FieldAccessExpr(expressionValue.expression, fieldNode.name);
                return getField;
            }
            case 188: {
                PrimitiveType type;
                switch (((IntInsnNode)insn).operand) {
                    case 4: {
                        type = PRIMITIVE_BOOLEAN;
                        break;
                    }
                    case 5: {
                        type = PRIMITIVE_CHAR;
                        break;
                    }
                    case 8: {
                        type = PRIMITIVE_BYTE;
                        break;
                    }
                    case 9: {
                        type = PRIMITIVE_SHORT;
                        break;
                    }
                    case 10: {
                        type = PRIMITIVE_INT;
                        break;
                    }
                    case 6: {
                        type = PRIMITIVE_FLOAT;
                        break;
                    }
                    case 7: {
                        type = PRIMITIVE_DOUBLE;
                        break;
                    }
                    case 11: {
                        type = PRIMITIVE_LONG;
                        break;
                    }
                    default: {
                        throw new AnalyzerException(insn, "Invalid array type");
                    }
                }
                ArrayList<Expression> dimensions = new ArrayList<Expression>();
                dimensions.add(expressionValue.expression);
                return new ExpressionValue((japa.parser.ast.type.Type)new ReferenceType((japa.parser.ast.type.Type)type, 1), (Expression)new ArrayCreationExpr((japa.parser.ast.type.Type)type, dimensions, 0));
            }
            case 189: {
                ExpressionValue newArray = (ExpressionValue)this.newValue(Type.getObjectType(((TypeInsnNode)insn).desc));
                ArrayList<Expression> dimensions = new ArrayList<Expression>();
                dimensions.add(expressionValue.expression);
                newArray.expression = new ArrayCreationExpr(newArray.type, dimensions, 0);
                return newArray;
            }
            case 190: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, (Expression)new FieldAccessExpr(expressionValue.expression, "length"));
            }
            case 191: {
                throw new UnsupportedOperationException(AbstractVisitor.OPCODES[insn.getOpcode()]);
            }
            case 192: {
                ExpressionValue cast = (ExpressionValue)this.newValue(Type.getObjectType(((TypeInsnNode)insn).desc));
                cast.expression = new CastExpr((japa.parser.ast.type.Type)new ReferenceType(cast.type), expressionValue.expression);
                return cast;
            }
            case 193: {
                ExpressionValue instanceOf = (ExpressionValue)this.newValue(Type.getObjectType(((TypeInsnNode)insn).desc));
                instanceOf.expression = new InstanceOfExpr(expressionValue.expression, (japa.parser.ast.type.Type)new ReferenceType(instanceOf.type));
                return instanceOf;
            }
            case 194: 
            case 195: {
                throw new UnsupportedOperationException(AbstractVisitor.OPCODES[insn.getOpcode()]);
            }
            case 198: {
                this.handleNestedConditional((Expression)new BinaryExpr(expressionValue.expression, (Expression)new NullLiteralExpr(), BinaryExpr.Operator.notEquals));
                return null;
            }
            case 199: {
                this.handleNestedConditional((Expression)new BinaryExpr(expressionValue.expression, (Expression)new NullLiteralExpr(), BinaryExpr.Operator.equals));
                return null;
            }
        }
        throw new Error("Internal error.");
    }

    public Value binaryOperation(AbstractInsnNode insn, Value value1, Value value2) throws AnalyzerException {
        ExpressionValue expressionValue1 = (ExpressionValue)value1;
        ExpressionValue expressionValue2 = (ExpressionValue)value2;
        switch (insn.getOpcode()) {
            case 46: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, (Expression)new ArrayAccessExpr(expressionValue1.expression, expressionValue2.expression));
            }
            case 51: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_BYTE, (Expression)new ArrayAccessExpr(expressionValue1.expression, expressionValue2.expression));
            }
            case 52: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_CHAR, (Expression)new ArrayAccessExpr(expressionValue1.expression, expressionValue2.expression));
            }
            case 53: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_SHORT, (Expression)new ArrayAccessExpr(expressionValue1.expression, expressionValue2.expression));
            }
            case 96: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.plus));
            }
            case 100: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.minus));
            }
            case 104: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.times));
            }
            case 108: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.divide));
            }
            case 112: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.remainder));
            }
            case 120: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.lShift));
            }
            case 122: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.rSignedShift));
            }
            case 124: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.rUnsignedShift));
            }
            case 126: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.binAnd));
            }
            case 128: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.binOr));
            }
            case 130: {
                if (expressionValue2.expression.toString().equals("-1")) {
                    return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, (Expression)new UnaryExpr(expressionValue1.expression, UnaryExpr.Operator.inverse));
                }
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.xor));
            }
            case 48: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_FLOAT, (Expression)new ArrayAccessExpr(expressionValue1.expression, expressionValue2.expression));
            }
            case 98: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_FLOAT, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.plus));
            }
            case 102: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_FLOAT, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.minus));
            }
            case 106: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_FLOAT, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.times));
            }
            case 110: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_FLOAT, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.divide));
            }
            case 114: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_FLOAT, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.remainder));
            }
            case 47: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_LONG, (Expression)new ArrayAccessExpr(expressionValue1.expression, expressionValue2.expression));
            }
            case 97: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_LONG, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.plus));
            }
            case 101: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_LONG, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.minus));
            }
            case 105: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_LONG, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.times));
            }
            case 109: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_LONG, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.divide));
            }
            case 113: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_LONG, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.remainder));
            }
            case 121: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_LONG, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.lShift));
            }
            case 123: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_LONG, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.rSignedShift));
            }
            case 125: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_LONG, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.rUnsignedShift));
            }
            case 127: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_LONG, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.binAnd));
            }
            case 129: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_LONG, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.binOr));
            }
            case 131: {
                if (expressionValue2.expression.toString().equals("-1L")) {
                    return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_LONG, (Expression)new UnaryExpr(expressionValue1.expression, UnaryExpr.Operator.inverse));
                }
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_LONG, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.xor));
            }
            case 49: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_DOUBLE, (Expression)new ArrayAccessExpr(expressionValue1.expression, expressionValue2.expression));
            }
            case 99: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_DOUBLE, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.plus));
            }
            case 103: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_DOUBLE, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.minus));
            }
            case 107: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_DOUBLE, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.times));
            }
            case 111: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_DOUBLE, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.divide));
            }
            case 115: {
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_DOUBLE, (Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.remainder));
            }
            case 50: {
                return new ExpressionValue(expressionValue1.type, (Expression)new ArrayAccessExpr(expressionValue1.expression, expressionValue2.expression));
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                this.cmpConditional = true;
                this.conditional = new ConditionalExpr((Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.notEquals), null, null);
                return new ExpressionValue((japa.parser.ast.type.Type)PRIMITIVE_INT, null);
            }
            case 159: {
                Object condition = null;
                condition = this.booleanValue(expressionValue2.expression, expressionValue1).toString().equals("true") ? new UnaryExpr(expressionValue1.expression, UnaryExpr.Operator.not) : (this.booleanValue(expressionValue1.expression, expressionValue2).toString().equals("true") ? new UnaryExpr(expressionValue2.expression, UnaryExpr.Operator.not) : (this.booleanValue(expressionValue1.expression, expressionValue2).toString().equals("false") ? expressionValue2.expression : new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.notEquals)));
                this.handleNestedConditional((Expression)condition);
                return null;
            }
            case 160: {
                Object condition = null;
                condition = this.booleanValue(expressionValue2.expression, expressionValue1).toString().equals("true") ? expressionValue1.expression : (this.booleanValue(expressionValue1.expression, expressionValue2).toString().equals("true") ? expressionValue2.expression : (this.booleanValue(expressionValue1.expression, expressionValue2).toString().equals("false") ? new UnaryExpr(expressionValue2.expression, UnaryExpr.Operator.not) : new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.equals)));
                this.handleNestedConditional((Expression)condition);
                return null;
            }
            case 161: {
                this.handleNestedConditional((Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.greaterEquals));
                return null;
            }
            case 162: {
                this.handleNestedConditional((Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.less));
                return null;
            }
            case 163: {
                this.handleNestedConditional((Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.lessEquals));
                return null;
            }
            case 164: {
                this.handleNestedConditional((Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.greater));
                return null;
            }
            case 165: {
                this.handleNestedConditional((Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.notEquals));
                return null;
            }
            case 166: {
                this.handleNestedConditional((Expression)new BinaryExpr(expressionValue1.expression, expressionValue2.expression, BinaryExpr.Operator.equals));
                return null;
            }
            case 181: {
                FieldInsnNode fieldNode = (FieldInsnNode)insn;
                ExpressionValue putField = (ExpressionValue)this.newValue(Type.getType(fieldNode.desc));
                putField.expression = new AssignExpr((Expression)new FieldAccessExpr(expressionValue1.expression, fieldNode.name), expressionValue2.expression, AssignExpr.Operator.assign);
                this.assign = putField;
                return null;
            }
        }
        throw new Error("Internal error.");
    }

    void handleNestedConditional(Expression condition) {
        if (this.conditional == null) {
            this.conditional = new ConditionalExpr(condition, null, null);
        } else {
            Expression currentCondition = this.conditional.getCondition();
            if (currentCondition instanceof UnaryExpr && ((UnaryExpr)currentCondition).getOperator() == UnaryExpr.Operator.not) {
                this.conditional.setCondition((Expression)new BinaryExpr(((UnaryExpr)currentCondition).getExpr(), condition, BinaryExpr.Operator.or));
            } else {
                this.conditional.setCondition((Expression)new BinaryExpr(currentCondition, condition, BinaryExpr.Operator.and));
            }
        }
    }

    public Value ternaryOperation(AbstractInsnNode insn, Value value1, Value value2, Value value3) throws AnalyzerException {
        ExpressionValue expressionValue1 = (ExpressionValue)value1;
        ExpressionValue expressionValue2 = (ExpressionValue)value2;
        ExpressionValue expressionValue3 = (ExpressionValue)value3;
        switch (insn.getOpcode()) {
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                if (expressionValue1.expression instanceof ArrayCreationExpr) {
                    ArrayList<Expression> values;
                    ArrayCreationExpr arrayCreationExpression = (ArrayCreationExpr)expressionValue1.expression;
                    ArrayInitializerExpr initializer = arrayCreationExpression.getInitializer();
                    if (initializer == null) {
                        initializer = new ArrayInitializerExpr();
                    }
                    if ((values = initializer.getValues()) == null) {
                        values = new ArrayList<Expression>();
                    }
                    values.add(expressionValue3.expression);
                    initializer.setValues(values);
                    arrayCreationExpression.setInitializer(initializer);
                    arrayCreationExpression.setDimensions(null);
                    arrayCreationExpression.setArrayCount(1);
                    this.assign = expressionValue1;
                } else {
                    this.assign = new ExpressionValue(expressionValue1.type, (Expression)new AssignExpr((Expression)new ArrayAccessExpr(expressionValue1.expression, expressionValue2.expression), expressionValue3.expression, AssignExpr.Operator.assign));
                }
                return null;
            }
        }
        throw new Error("Internal error.");
    }

    public Value naryOperation(AbstractInsnNode insn, List values) throws AnalyzerException {
        boolean isConstructor;
        if (insn.getOpcode() == 197) {
            throw new UnsupportedOperationException(AbstractVisitor.OPCODES[insn.getOpcode()]);
        }
        MethodInsnNode node = (MethodInsnNode)insn;
        ClassOrInterfaceType returnType = this.createClassOrInterfaceType(Type.getReturnType(node.desc).getClassName());
        NameExpr scope = null;
        boolean bl = isConstructor = node.getOpcode() == 183 && "<init>".equals(node.name);
        if (node.getOpcode() == 184) {
            String className = Type.getObjectType(node.owner).getClassName();
            scope = new NameExpr(this.removeJavaLang(className));
        } else if (!isConstructor) {
            ExpressionValue target = (ExpressionValue)values.remove(0);
            if (!(target.expression instanceof ThisExpr)) {
                scope = target.expression;
            }
        }
        ArrayList<Expression> arguments = values.isEmpty() ? null : new ArrayList<Expression>();
        for (ExpressionValue value : values) {
            arguments.add(value.expression);
        }
        if (isConstructor) {
            arguments.remove(0);
            ExpressionValue newExpressionValue = (ExpressionValue)values.remove(0);
            ClassOrInterfaceType type = (ClassOrInterfaceType)newExpressionValue.type;
            newExpressionValue.expression = new ObjectCreationExpr((Expression)scope, type, arguments.isEmpty() ? null : arguments);
            return new ExpressionValue((japa.parser.ast.type.Type)returnType, newExpressionValue.expression);
        }
        return new ExpressionValue((japa.parser.ast.type.Type)returnType, (Expression)new MethodCallExpr((Expression)scope, node.name, arguments));
    }

    public void returnOperation(AbstractInsnNode insn, Value value, Value expected) throws AnalyzerException {
        this.returns.add(this.mn.instructions.indexOf(insn));
        this.expression = ((ExpressionValue)value).expression;
        this.expression = this.booleanValue(this.expression, expected);
        if (this.conditional != null) {
            Expression elseExpr = this.conditional.getElseExpr();
            if (elseExpr == null) {
                this.conditional.setElseExpr(this.expression);
            } else {
                Expression thenExpr;
                Expression condition = this.conditional.getCondition();
                if (this.currentFrame.getStackSize() > 0) {
                    Value then = this.currentFrame.pop();
                    this.currentFrame.push(then);
                    this.conditional.setThenExpr(this.booleanValue(((ExpressionValue)then).expression, expected));
                } else {
                    thenExpr = this.conditional.getThenExpr();
                    if (thenExpr == null && this.expression != null) {
                        this.conditional.setThenExpr(this.expression);
                    } else {
                        this.conditional.setThenExpr((Expression)new BooleanLiteralExpr(false));
                    }
                }
                thenExpr = this.conditional.getThenExpr();
                if (thenExpr instanceof BooleanLiteralExpr && elseExpr instanceof BooleanLiteralExpr) {
                    if (thenExpr.toString().equals("true") && elseExpr.toString().equals("false")) {
                        this.expression = condition;
                    } else if (thenExpr.toString().equals("false") && elseExpr.toString().equals("true")) {
                        if (condition instanceof BinaryExpr) {
                            BinaryExpr binaryExpr = (BinaryExpr)condition;
                            this.expression = condition;
                            if (binaryExpr.getLeft() instanceof BinaryExpr) {
                                BinaryExpr left = (BinaryExpr)binaryExpr.getLeft();
                                if (binaryExpr.getOperator() == BinaryExpr.Operator.and) {
                                    binaryExpr.setOperator(BinaryExpr.Operator.or);
                                    this.flipOperator(left);
                                }
                            }
                            if (this.couldBeECJ()) {
                                BinaryExpr right;
                                if (binaryExpr.getRight() instanceof BinaryExpr) {
                                    right = (BinaryExpr)binaryExpr.getRight();
                                    if (binaryExpr.getOperator() == BinaryExpr.Operator.or) {
                                        this.flipOperator(right);
                                    }
                                }
                                if (binaryExpr.getRight() instanceof UnaryExpr && (right = (UnaryExpr)binaryExpr.getRight()).getOperator() == UnaryExpr.Operator.not) {
                                    binaryExpr.setRight(right.getExpr());
                                }
                            }
                        } else {
                            this.expression = new UnaryExpr(condition, UnaryExpr.Operator.not);
                        }
                    }
                } else {
                    this.expression = this.conditional;
                }
                this.conditional = null;
            }
        }
    }

    boolean couldBeECJ() {
        return this.returns.size() > 1;
    }

    BinaryExpr flipOperator(BinaryExpr binaryExpr) {
        BinaryExpr.Operator op = binaryExpr.getOperator();
        if (op == BinaryExpr.Operator.notEquals) {
            binaryExpr.setOperator(BinaryExpr.Operator.equals);
        } else if (op == BinaryExpr.Operator.equals) {
            binaryExpr.setOperator(BinaryExpr.Operator.notEquals);
        } else if (op == BinaryExpr.Operator.greater) {
            binaryExpr.setOperator(BinaryExpr.Operator.lessEquals);
        } else if (op == BinaryExpr.Operator.less) {
            binaryExpr.setOperator(BinaryExpr.Operator.greaterEquals);
        } else if (op == BinaryExpr.Operator.greaterEquals) {
            binaryExpr.setOperator(BinaryExpr.Operator.less);
        } else if (op == BinaryExpr.Operator.lessEquals) {
            binaryExpr.setOperator(BinaryExpr.Operator.greater);
        }
        return binaryExpr;
    }

    Expression booleanValue(Expression expression, Value expected) {
        if (((ExpressionValue)expected).type == PRIMITIVE_BOOLEAN && expression instanceof IntegerLiteralExpr) {
            if ("1".equals(expression.toString())) {
                expression = new BooleanLiteralExpr(true);
            } else if ("0".equals(expression.toString())) {
                expression = new BooleanLiteralExpr(false);
            }
        }
        return expression;
    }

    public Value merge(Value v, Value w) {
        if (!v.equals(w)) {
            return new ExpressionValue(null, null);
        }
        return v;
    }

    static class ExpressionValue
    implements Value {
        Expression expression;
        japa.parser.ast.type.Type type;
        int size = 1;

        ExpressionValue(japa.parser.ast.type.Type type, Expression expression) {
            this.type = type;
            this.expression = expression;
            if (type instanceof PrimitiveType) {
                PrimitiveType.Primitive primitive = ((PrimitiveType)type).getType();
                this.size = primitive == PrimitiveType.Primitive.Long || primitive == PrimitiveType.Primitive.Double ? 2 : 1;
            }
        }

        public int getSize() {
            return this.size;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExpressionValue other = (ExpressionValue)obj;
            if (this.expression == null ? other.expression != null : !this.expression.equals((Object)other.expression)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
        }

        public String toString() {
            return this.expression + " (" + this.type + ")";
        }
    }
}

