/*
 * Decompiled with CFR 0.152.
 */
package org.enumerable.lambda.support.expression;

import japa.parser.ast.expr.Expression;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.enumerable.lambda.Fn0;
import org.enumerable.lambda.Fn1;
import org.enumerable.lambda.Fn2;
import org.enumerable.lambda.Fn3;
import org.enumerable.lambda.annotation.LambdaLocal;
import org.enumerable.lambda.exception.UncheckedException;
import org.enumerable.lambda.support.expression.ExpressionInterpreter;
import org.enumerable.lambda.weaving.InMemoryCompiler;
import org.enumerable.lambda.weaving.asm.ClassReader;
import org.enumerable.lambda.weaving.asm.Type;
import org.enumerable.lambda.weaving.asm.tree.ClassNode;
import org.enumerable.lambda.weaving.asm.tree.LocalVariableNode;
import org.enumerable.lambda.weaving.asm.tree.MethodNode;
import org.enumerable.lambda.weaving.asm.tree.analysis.Analyzer;
import org.enumerable.lambda.weaving.asm.tree.analysis.Frame;
import org.enumerable.lambda.weaving.asm.util.ASMifierMethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LambdaExpressionTrees {
    static int expressionId = 1;
    static InMemoryCompiler compiler = new InMemoryCompiler();

    public static Expression parseExpression(String expression) {
        try {
            Class<?> parserClass = Class.forName("japa.parser.ASTParser");
            Constructor<?> ctor = parserClass.getConstructor(Reader.class);
            ctor.setAccessible(true);
            Object parser = ctor.newInstance(new StringReader(expression));
            Method method = parserClass.getMethod("Expression", new Class[0]);
            method.setAccessible(true);
            return (Expression)method.invoke(parser, new Object[0]);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    static Expression parseExpressionFromSingleMethodClass(Class<?> aClass, String ... parameters) {
        return LambdaExpressionTrees.parseExpressionFromMethod(Fn0.getLambdaMethod(aClass), parameters);
    }

    public static Expression parseExpressionFromMethod(Method method, String ... parameters) {
        try {
            Analyzer analyzer;
            MethodNode mn = LambdaExpressionTrees.findMethodNode(method);
            LocalVariableNode[] parameterLocals = new LocalVariableNode[parameters.length];
            Type[] argumentTypes = Type.getArgumentTypes(mn.desc);
            int realIndex = 1;
            for (int i = 0; i < parameters.length; ++i) {
                parameterLocals[i] = new LocalVariableNode(parameters[i], argumentTypes[i].getDescriptor(), null, null, null, realIndex);
                realIndex += argumentTypes[i].getSize();
            }
            final ExpressionInterpreter interpreter = new ExpressionInterpreter(mn, parameterLocals);
            interpreter.analyzer = analyzer = new Analyzer(interpreter){

                protected Frame newFrame(Frame src) {
                    Frame frame = super.newFrame(src);
                    interpreter.setCurrentFrame(frame);
                    return frame;
                }

                protected void newControlFlowEdge(int insn, int successor) {
                    interpreter.newControlFlowEdge(insn, successor);
                }
            };
            analyzer.analyze(Type.getInternalName(method.getDeclaringClass()), mn);
            return interpreter.expression;
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    static void printASMifiedMethod(Method method) {
        try {
            MethodNode mn = LambdaExpressionTrees.findMethodNode(method);
            ASMifierMethodVisitor asm = new ASMifierMethodVisitor();
            mn.accept(asm);
            PrintWriter pw = new PrintWriter(System.out);
            asm.print(pw);
            pw.flush();
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    static MethodNode findMethodNode(Method method) throws IOException {
        String className = method.getDeclaringClass().getName();
        ClassReader cr = InMemoryCompiler.bytesByClassName.containsKey(className) ? new ClassReader(InMemoryCompiler.bytesByClassName.get(className)) : new ClassReader(className);
        ClassNode cn = new ClassNode();
        cr.accept(cn, 0);
        String descriptor = Type.getMethodDescriptor(method);
        for (MethodNode mn : cn.methods) {
            if (!method.getName().equals(mn.name) || !descriptor.equals(mn.desc)) continue;
            return mn;
        }
        throw new IllegalStateException("Cannot find method which does exist");
    }

    public static <R extends Expression> R toExpression(Fn0<?> fn) {
        if (fn.getClass().getDeclaredFields().length > 0) {
            throw new IllegalArgumentException("Turning Closures into Expressions isn't supported");
        }
        List<LambdaLocal> parameters = fn.getParameters();
        String[] parameterNames = new String[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            parameterNames[i] = parameters.get(i).name();
        }
        return (R)LambdaExpressionTrees.parseExpressionFromSingleMethodClass(fn.getClass(), parameterNames);
    }

    public static <R> Fn0<R> toFn0(Class<R> returnType, Expression expression) {
        try {
            String className = "ExpressionFn0_" + expressionId++;
            String source = "class " + className + " extends " + Fn0.class.getName() + "{ public " + LambdaExpressionTrees.typeToString(returnType) + " call() { return " + expression + "; }}";
            return LambdaExpressionTrees.compileAndCreate(className, source);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static <A1, R> Fn1<A1, R> toFn1(Class<R> returnType, Class<A1> a1Type, String a1Name, Expression expression) {
        try {
            String className = "ExpressionFn1_" + expressionId++;
            String source = "class " + className + " extends " + Fn1.class.getName() + "{ public " + LambdaExpressionTrees.typeToString(returnType) + " call(" + LambdaExpressionTrees.typeToString(a1Type) + " " + a1Name + ") { return " + expression + "; } public " + LambdaExpressionTrees.typeToString(returnType) + " call(Object " + a1Name + ") { return call((" + LambdaExpressionTrees.typeToString(a1Type) + ") " + a1Name + ");  }  }";
            return (Fn1)LambdaExpressionTrees.compileAndCreate(className, source);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static <A1, A2, R> Fn2<A1, A2, R> toFn2(Class<R> returnType, Class<A1> a1Type, String a1Name, Class<A2> a2Type, String a2Name, Expression expression) {
        try {
            String className = "ExpressionFn2_" + expressionId++;
            String source = "class " + className + " extends " + Fn2.class.getName() + "{ public " + LambdaExpressionTrees.typeToString(returnType) + " call(" + LambdaExpressionTrees.typeToString(a1Type) + " " + a1Name + ", " + LambdaExpressionTrees.typeToString(a2Type) + " " + a2Name + ") { return " + expression + "; } public " + LambdaExpressionTrees.typeToString(returnType) + " call(Object " + a1Name + ", Object " + a2Name + ") { return call((" + LambdaExpressionTrees.typeToString(a1Type) + ") " + a1Name + ", (" + LambdaExpressionTrees.typeToString(a2Type) + ") " + a2Name + ");  }  }";
            return (Fn2)LambdaExpressionTrees.compileAndCreate(className, source);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public static <A1, A2, A3, R> Fn3<A1, A2, A3, R> toFn3(Class<R> returnType, Class<A1> a1Type, String a1Name, Class<A2> a2Type, String a2Name, Class<A2> a3Type, String a3Name, Expression expression) {
        try {
            String className = "ExpressionFn3_" + expressionId++;
            String source = "class " + className + " extends " + Fn3.class.getName() + "{ public " + LambdaExpressionTrees.typeToString(returnType) + " call(" + LambdaExpressionTrees.typeToString(a1Type) + " " + a1Name + ", " + LambdaExpressionTrees.typeToString(a2Type) + " " + a2Name + ", " + LambdaExpressionTrees.typeToString(a3Type) + " " + a3Name + ") { return " + expression + "; } public " + LambdaExpressionTrees.typeToString(returnType) + " call(Object " + a1Name + ", Object " + a2Name + ", Object " + a3Name + ") { return call((" + LambdaExpressionTrees.typeToString(a1Type) + ") " + a1Name + ", (" + LambdaExpressionTrees.typeToString(a2Type) + ") " + a2Name + ", (" + LambdaExpressionTrees.typeToString(a3Type) + ") " + a3Name + ");  }  }";
            return (Fn3)LambdaExpressionTrees.compileAndCreate(className, source);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    static String typeToString(Class<?> returnType) {
        return returnType.isArray() ? returnType.getComponentType().getName() + "[]" : returnType.getName();
    }

    static <R extends Fn0<?>> R compileAndCreate(String className, String source) throws IOException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> aClass = compiler.compile(className, source);
        Constructor<?> ctor = aClass.getDeclaredConstructors()[0];
        ctor.setAccessible(true);
        return (R)((Fn0)ctor.newInstance(new Object[0]));
    }
}

