/*
 * Decompiled with CFR 0.152.
 */
package org.enumerable.lambda.weaving;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.enumerable.lambda.exception.UncheckedException;
import org.enumerable.lambda.weaving.ClassInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryCompiler {
    public static boolean useECJ = Boolean.valueOf(System.getProperty("lambda.support.expression.useECJ"));
    static JavaCompiler compiler;
    static boolean expressionSupportEnabled;
    public static Map<String, byte[]> bytesByClassName;
    private boolean debugInfo = true;

    public static void registerLambda(String name, byte[] bs) {
        if (expressionSupportEnabled) {
            bytesByClassName.put(name, bs);
        }
    }

    static JavaCompiler createCompiler() {
        try {
            if (useECJ) {
                return (JavaCompiler)Class.forName("org.eclipse.jdt.internal.compiler.tool.EclipseCompiler").newInstance();
            }
            return ToolProvider.getSystemJavaCompiler();
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    public InMemoryCompiler debugInfo(boolean debugInfo) {
        this.debugInfo = debugInfo;
        return this;
    }

    public Class<?> compile(String className, String source) throws IOException {
        JavaCompiler.CompilationTask task;
        boolean success;
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        ForwardingJavaFileManager<StandardJavaFileManager> manager = new ForwardingJavaFileManager<StandardJavaFileManager>(compiler.getStandardFileManager(null, null, null)){

            @Override
            public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
                return new ByteArrayFileObject(className.replace('/', '.'));
            }
        };
        JavaSourceFromString file = new JavaSourceFromString(className, source);
        ArrayList<String> options = new ArrayList<String>(Arrays.asList("-source", "1.5", "-target", "1.5"));
        if (this.debugInfo) {
            options.add("-g");
        }
        if (useECJ) {
            options.add("-warn:-raw");
            options.add("-warn:-deadCode");
            options.add("-warn:-serial");
        }
        if (success = (task = compiler.getTask(null, manager, diagnostics, options, null, Arrays.asList(file))).call().booleanValue()) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw UncheckedException.uncheck(e);
            }
        }
        for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
            System.out.println(diagnostic.getCode());
            System.out.println((Object)diagnostic.getKind());
            System.out.println(diagnostic.getPosition());
            System.out.println(diagnostic.getStartPosition());
            System.out.println(diagnostic.getEndPosition());
            System.out.println(diagnostic.getSource());
            System.out.println(diagnostic.getMessage(null));
        }
        return null;
    }

    static {
        try {
            Class.forName("japa.parser.JavaParser");
            expressionSupportEnabled = true;
            compiler = InMemoryCompiler.createCompiler();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        bytesByClassName = new HashMap<String, byte[]>();
    }

    static class JavaSourceFromString
    extends SimpleJavaFileObject {
        String code;

        JavaSourceFromString(String name, String code) {
            super(URI.create("file:///" + name.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.code = code;
        }

        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.code;
        }
    }

    static class ByteArrayFileObject
    extends SimpleJavaFileObject {
        String className;

        ByteArrayFileObject(String className) {
            super(URI.create("file://" + className.replace('.', '/') + JavaFileObject.Kind.CLASS.extension), JavaFileObject.Kind.CLASS);
            this.className = className;
        }

        public OutputStream openOutputStream() throws IOException {
            return new ByteArrayOutputStream(){

                public void close() throws IOException {
                    super.close();
                    bytesByClassName.put(ByteArrayFileObject.this.className, this.toByteArray());
                    new ClassInjector().inject(this.getClass().getClassLoader(), ByteArrayFileObject.this.className, this.toByteArray());
                }
            };
        }
    }
}

