/*
 * Decompiled with CFR 0.152.
 */
package org.enumerable.lambda.weaving;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import org.enumerable.lambda.exception.LambdaWeavingNotEnabledException;
import org.enumerable.lambda.exception.UncheckedException;
import org.enumerable.lambda.weaving.ClassFilter;
import org.enumerable.lambda.weaving.Debug;
import org.enumerable.lambda.weaving.Version;
import org.enumerable.lambda.weaving.tree.LambdaTreeTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LambdaLoader
extends ClassLoader
implements ClassFileTransformer {
    private static boolean isEnabled;
    private static boolean transformationFailed;
    static String weavingNotEnabledMessage;
    private ClassFilter filter;
    LambdaTreeTransformer transformer = new LambdaTreeTransformer();

    public LambdaLoader() {
        this(ClassFilter.createClassFilter());
    }

    public LambdaLoader(ClassFilter filter) {
        this.filter = filter;
    }

    public static boolean isEnabled() {
        return isEnabled && !transformationFailed;
    }

    public static void ensureIsEnabled() {
        if (!LambdaLoader.isEnabled()) {
            throw new LambdaWeavingNotEnabledException();
        }
    }

    public static void ensureIsEnabledOrExit() {
        if (!LambdaLoader.isEnabled()) {
            System.err.println(LambdaLoader.getNotEnabledMessage());
            System.exit(1);
        }
    }

    public static void bootstrapMainIfNotEnabledAndExitUponItsReturn(String[] args) {
        if (!LambdaLoader.isEnabled()) {
            StackTraceElement caller = Thread.currentThread().getStackTrace()[2];
            if ("main".equals(caller.getMethodName())) {
                try {
                    String className = caller.getClassName();
                    System.out.println(LambdaLoader.getNotEnabledMessage());
                    System.out.println("Will try to reload " + className + " in the same process:");
                    LambdaLoader.launchApplication(className, args);
                    System.exit(0);
                }
                catch (Exception e) {
                    throw UncheckedException.uncheck(e);
                }
            }
            throw new IllegalStateException("Must be called from a main method.");
        }
    }

    public static Object launchApplication(String className, String[] args) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Debug.debug("[main] " + Version.getVersionString());
        isEnabled = true;
        Class<?> c = new LambdaLoader().loadClass(className);
        Method m = c.getMethod("main", String[].class);
        return m.invoke(null, new Object[]{args});
    }

    public static String getNotEnabledMessage() {
        return weavingNotEnabledMessage;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz;
        InputStream in = this.getResourceAsStream(name.replace('.', '/') + ".class");
        try {
            byte[] b = this.transformClass(this, name, in);
            if (b == null) {
                Class<?> clazz2 = super.loadClass(name, resolve);
                return clazz2;
            }
            clazz = this.defineClass(name, b, 0, b.length);
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException silent) {}
        }
        return clazz;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            return this.transformClass(loader != null ? loader : ClassLoader.getSystemClassLoader(), className.replace('/', '.'), new ByteArrayInputStream(classfileBuffer));
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public byte[] transformClass(ClassLoader loader, String name, InputStream in) {
        try {
            if (!this.filter.isToBeInstrumented(name) || transformationFailed) {
                return null;
            }
            return this.transformer.transform(loader, this.filter, name, in);
        }
        catch (Throwable t) {
            transformationFailed = true;
            weavingNotEnabledMessage = t.getMessage();
            System.err.println(Version.getVersionString());
            System.err.println("caught throwable while transforming " + name + ", transformation is disabled from here on");
            throw UncheckedException.uncheck(t);
        }
    }

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        Debug.debug("[premain] " + Version.getVersionString());
        isEnabled = true;
        instrumentation.addTransformer(new LambdaLoader());
    }

    public static void agentmain(String agentArgs, Instrumentation instrumentation) {
        Debug.debug("[agentmain] " + Version.getVersionString());
        isEnabled = true;
        instrumentation.addTransformer(new LambdaLoader());
    }

    public static void main(String[] args) throws Throwable {
        try {
            if (args.length == 0) {
                System.out.println("[launcher] " + Version.getVersionString());
                System.out.println("Usage: class [ARGS]...");
                return;
            }
            Debug.debug("[launcher] " + Version.getVersionString());
            String[] argsCopy = new String[args.length - 1];
            System.arraycopy(args, 1, argsCopy, 0, args.length - 1);
            LambdaLoader.launchApplication(args[0], argsCopy);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    static {
        weavingNotEnabledMessage = "Please start the JVM with -javaagent:enumerable-java-" + Version.getVersion() + ".jar";
        isEnabled = LambdaLoader.class.getClassLoader().getResource("META-INF/lambda.aot.compiled") != null;
    }
}

