/*
 * Decompiled with CFR 0.152.
 */
package org.enumerable.lambda.weaving;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.enumerable.lambda.exception.UncheckedException;
import org.enumerable.lambda.weaving.Debug;

public class LambdaWeavingProperties {
    private static final Properties properties;

    public static String get(String property, boolean nullable) {
        boolean notSet;
        String value = properties.getProperty(property);
        Debug.debug(property + ": " + value);
        boolean bl = notSet = value == null || value.trim().length() == 0;
        if (notSet && nullable) {
            return null;
        }
        if (notSet) {
            throw new IllegalStateException(property + " cannot be null");
        }
        return value;
    }

    static {
        InputStream in = null;
        try {
            in = LambdaWeavingProperties.class.getResourceAsStream("lambda.weaving.properties");
            if (in == null) {
                throw new IllegalStateException("Could not find /org/enumerable/lambda/weaving/lambda.weaving.properties");
            }
            properties = new Properties(System.getProperties());
            properties.load(in);
        }
        catch (IOException e) {
            throw UncheckedException.uncheck(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

