/*
 * Decompiled with CFR 0.152.
 */
package org.enumerable.lambda.weaving.tree;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.enumerable.lambda.exception.UncheckedException;
import org.enumerable.lambda.weaving.ClassFilter;
import org.enumerable.lambda.weaving.Debug;
import org.enumerable.lambda.weaving.LambdaWeavingProperties;
import org.enumerable.lambda.weaving.asm.AnnotationVisitor;
import org.enumerable.lambda.weaving.asm.ClassReader;
import org.enumerable.lambda.weaving.asm.FieldVisitor;
import org.enumerable.lambda.weaving.asm.Label;
import org.enumerable.lambda.weaving.asm.MethodVisitor;
import org.enumerable.lambda.weaving.asm.Opcodes;
import org.enumerable.lambda.weaving.asm.Type;
import org.enumerable.lambda.weaving.asm.commons.Method;
import org.enumerable.lambda.weaving.asm.tree.AbstractInsnNode;
import org.enumerable.lambda.weaving.asm.tree.AnnotationNode;
import org.enumerable.lambda.weaving.asm.tree.ClassNode;
import org.enumerable.lambda.weaving.asm.tree.FieldInsnNode;
import org.enumerable.lambda.weaving.asm.tree.FieldNode;
import org.enumerable.lambda.weaving.asm.tree.IincInsnNode;
import org.enumerable.lambda.weaving.asm.tree.InsnList;
import org.enumerable.lambda.weaving.asm.tree.JumpInsnNode;
import org.enumerable.lambda.weaving.asm.tree.LabelNode;
import org.enumerable.lambda.weaving.asm.tree.LineNumberNode;
import org.enumerable.lambda.weaving.asm.tree.LocalVariableNode;
import org.enumerable.lambda.weaving.asm.tree.MemberNode;
import org.enumerable.lambda.weaving.asm.tree.MethodInsnNode;
import org.enumerable.lambda.weaving.asm.tree.MethodNode;
import org.enumerable.lambda.weaving.asm.tree.TypeInsnNode;
import org.enumerable.lambda.weaving.asm.tree.VarInsnNode;
import org.enumerable.lambda.weaving.asm.tree.analysis.Analyzer;
import org.enumerable.lambda.weaving.asm.tree.analysis.BasicInterpreter;
import org.enumerable.lambda.weaving.asm.tree.analysis.Frame;
import org.enumerable.lambda.weaving.asm.util.ASMifierClassVisitor;
import org.enumerable.lambda.weaving.asm.util.ASMifierMethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LambdaTreeWeaver
implements Opcodes {
    static Type newLambdaAnnotation = LambdaTreeWeaver.getConfigurableAnnotationType("lambda.weaving.annotation.newlambda", false);
    static Type lambdaParameterAnnotation = LambdaTreeWeaver.getConfigurableAnnotationType("lambda.weaving.annotation.lambdaparameter", false);
    static Type lambdaLocalAnnotation = LambdaTreeWeaver.getConfigurableAnnotationType("lambda.weaving.annotation.lambdalocal", true);
    ClassNode c;
    int currentLambdaId = 1;
    List<MethodAnalyzer> methods = new ArrayList<MethodAnalyzer>();
    Map<String, FieldNode> fieldsThatNeedStaticAccessMethod = new HashMap<String, FieldNode>();
    Map<String, MethodNode> methodsThatNeedStaticAccessMethod = new HashMap<String, MethodNode>();
    Map<String, MethodNode> staticAccessMethodsByFieldName = new HashMap<String, MethodNode>();
    Map<String, MethodNode> staticAccessMethodsByMethodNameAndDesc = new HashMap<String, MethodNode>();
    ClassLoader loader;
    ClassFilter filter;
    ClassReader cr;

    LambdaTreeWeaver(ClassLoader loader, ClassFilter filter, ClassReader cr) {
        this.loader = loader;
        this.filter = filter;
        this.cr = cr;
    }

    LambdaTreeWeaver analyze() {
        try {
            if (this.c != null) {
                return this;
            }
            this.c = new ClassNode();
            this.cr.accept(this.c, 0);
            Debug.devDebug(this.c.name);
            Debug.devDebug("");
            for (MethodNode m : this.c.methods) {
                MethodAnalyzer ma = new MethodAnalyzer(m);
                ma.analyze();
                this.methods.add(ma);
            }
            return this;
        }
        catch (Exception e) {
            throw UncheckedException.uncheck(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassNode transform() {
        try {
            if (this.c == null) {
                this.analyze();
            }
            Debug.debug("transforming " + Type.getObjectType(this.c.name).getClassName());
            for (MethodAnalyzer ma : this.methods) {
                try {
                    Debug.debugIndent();
                    ma.transform();
                }
                finally {
                    Debug.debugDedent();
                }
            }
            return this.c;
        }
        catch (IOException e) {
            throw UncheckedException.uncheck(e);
        }
    }

    boolean hasLambdas() {
        for (MethodAnalyzer ma : this.methods) {
            if (ma.lambdas.isEmpty()) continue;
            return true;
        }
        return false;
    }

    List<MethodAnalyzer.LambdaAnalyzer> getLambdas() {
        ArrayList<MethodAnalyzer.LambdaAnalyzer> result = new ArrayList<MethodAnalyzer.LambdaAnalyzer>();
        for (MethodAnalyzer ma : this.methods) {
            result.addAll(ma.lambdas);
        }
        return result;
    }

    Type toArrayType(Type type) {
        return Type.getType("[" + type.getDescriptor());
    }

    boolean isReference(Type type) {
        return type.getSort() == 10 || type.getSort() == 9;
    }

    boolean isPrimitive(Type type) {
        return !this.isReference(type);
    }

    boolean hasAccess(ClassNode c, int acc) {
        return (c.access & acc) != 0;
    }

    boolean hasAccess(MethodNode m, int acc) {
        return m != null && (m.access & acc) != 0;
    }

    boolean hasAccess(FieldNode f, int acc) {
        return f != null && (f.access & acc) != 0;
    }

    MethodNode findMethod(MethodInsnNode mn) throws IOException {
        for (MethodNode m : this.readClassNoCode((String)mn.owner).methods) {
            if (!m.name.equals(mn.name) || !m.desc.equals(mn.desc)) continue;
            return m;
        }
        return null;
    }

    FieldNode findField(FieldInsnNode fn) throws IOException {
        for (FieldNode f : this.readClassNoCode((String)fn.owner).fields) {
            if (!f.name.equals(fn.name) || !f.desc.equals(fn.desc)) continue;
            return f;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassNode readClassNoCode(String internalName) throws IOException {
        if (internalName.equals(this.c.name)) {
            return this.c;
        }
        ClassNode cn = new ClassNode();
        String className = Type.getObjectType(internalName).getClassName();
        if (this.isEnum(className)) {
            return cn;
        }
        InputStream in = null;
        try {
            in = this.loader.getResourceAsStream(className.replace(".", "/") + ".class");
            if (in == null) {
                Debug.debug("could not read: " + className + " for ASM reflection when transforming " + this.c.name);
            }
            new ClassReader(in).accept(cn, 7);
        }
        catch (IOException ignore) {
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return cn;
    }

    boolean isEnum(String className) {
        return className.endsWith("[]");
    }

    boolean hasAnnotation(MemberNode mn, Type a) {
        if (mn.invisibleAnnotations == null) {
            return false;
        }
        for (AnnotationNode an : mn.invisibleAnnotations) {
            if (!Type.getType(an.desc).equals(a)) continue;
            return true;
        }
        return false;
    }

    String getSimpleClassName(Type type) {
        String name = type.getClassName();
        if (!name.contains(".")) {
            return name;
        }
        return name.substring(name.lastIndexOf(46) + 1, name.length());
    }

    void devDebugAsm(MethodNode m) {
        if (!Debug.devDebug) {
            return;
        }
        ASMifierMethodVisitor asm = new ASMifierMethodVisitor();
        m.instructions.accept(asm);
        PrintWriter pw = new PrintWriter(System.out);
        asm.print(pw);
        pw.flush();
    }

    static Type getConfigurableAnnotationType(String property, boolean nullable) {
        return Type.getType("L" + LambdaWeavingProperties.get(property, nullable).replace('.', '/') + ";");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MethodAnalyzer {
        MethodNode m;
        Method method;
        Frame[] frames;
        int currentLambda = 0;
        List<LambdaAnalyzer> lambdas = new ArrayList<LambdaAnalyzer>();
        Map<String, LocalVariableNode> methodLocals = new LinkedHashMap<String, LocalVariableNode>();
        Map<String, LocalVariableNode> methodMutableLocals = new LinkedHashMap<String, LocalVariableNode>();
        int line;

        MethodAnalyzer(MethodNode m) {
            this.m = m;
            this.method = new Method(m.name, m.desc);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void transform() throws IOException {
            if (this.lambdas.isEmpty()) {
                return;
            }
            Debug.debug("processing " + this.method);
            InsnList instructions = this.m.instructions;
            this.m.instructions = new InsnList();
            for (LocalVariableNode local : this.getLocalsMutableFromLambdas().values()) {
                this.initArray(this.m, local);
            }
            for (int i = 0; i < instructions.size(); ++i) {
                LocalVariableNode local;
                AbstractInsnNode n = instructions.get(i);
                if (this.currentLambda < this.lambdas.size() && i == this.lambdas.get(this.currentLambda).getStart()) {
                    LambdaAnalyzer lambda = this.lambdas.get(this.currentLambda);
                    i = this.lambdas.get(this.currentLambda).getEnd();
                    ++this.currentLambda;
                    try {
                        Debug.debugIndent();
                        lambda.transform(instructions);
                    }
                    finally {
                        Debug.debugDedent();
                    }
                    lambda.instantiate(this.m, null);
                    continue;
                }
                if (n.getType() == 2) {
                    VarInsnNode vin = (VarInsnNode)n;
                    local = this.getLocalVariable(vin.var);
                    if (local != null && this.getLocalsMutableFromLambdas().containsKey(local.name)) {
                        this.loadArrayFromLocal(this.m, local);
                        if (this.isStoreInstruction(vin)) {
                            this.storeTopOfStackInArray(this.m, Type.getType(local.desc));
                            continue;
                        }
                        this.loadFirstElementOfArray(this.m, Type.getType(local.desc));
                        continue;
                    }
                    n.accept(this.m);
                    continue;
                }
                if (n.getType() == 9) {
                    IincInsnNode iinc = (IincInsnNode)n;
                    local = this.getLocalVariable(iinc.var);
                    if (local != null && this.getLocalsMutableFromLambdas().containsKey(local.name)) {
                        this.loadArrayFromLocal(this.m, local);
                        this.incrementInArray(this.m, iinc.incr);
                        continue;
                    }
                    n.accept(this.m);
                    continue;
                }
                n.accept(this.m);
            }
            this.endMethod(this.m);
            Debug.devDebug("after ================= ");
            LambdaTreeWeaver.this.devDebugAsm(this.m);
        }

        void endMethod(MethodVisitor mv) {
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        LocalVariableNode getLocalVariable(int var) {
            for (LocalVariableNode local : this.m.localVariables) {
                if (var != local.index) continue;
                return local;
            }
            return null;
        }

        void analyze() throws Exception {
            this.frames = new Analyzer(new BasicInterpreter()).analyze(LambdaTreeWeaver.this.c.name, this.m);
            this.line = 0;
            for (int i = 0; i < this.m.instructions.size(); ++i) {
                MethodInsnNode mi;
                AbstractInsnNode n = this.m.instructions.get(i);
                int type = n.getType();
                if (type == 5 && this.isNewLambdaMethod(mi = (MethodInsnNode)n)) {
                    List<int[]> argumentRanges = this.findArgumentInstructionRangesOfLambda(i, Type.getArgumentTypes(mi.desc).length);
                    this.lambdas.add(0, new LambdaAnalyzer(LambdaTreeWeaver.this.currentLambdaId++, this.line, mi, argumentRanges));
                }
                if (type == 2) {
                    this.localVariable((VarInsnNode)n);
                }
                if (type == 9) {
                    this.localVariable((IincInsnNode)n);
                }
                if (type != 14) continue;
                this.line = ((LineNumberNode)n).line;
            }
            Collections.sort(this.lambdas, new Comparator<LambdaAnalyzer>(){

                @Override
                public int compare(LambdaAnalyzer o1, LambdaAnalyzer o2) {
                    return o1.getStart() - o2.getStart();
                }
            });
            for (LambdaAnalyzer lambda : this.lambdas) {
                lambda.analyze();
            }
            if (!this.lambdas.isEmpty()) {
                Debug.devDebug("");
                Debug.devDebug("before ================ ");
                LambdaTreeWeaver.this.devDebugAsm(this.m);
            }
        }

        List<int[]> findArgumentInstructionRangesOfLambda(int end, int arguments) {
            ArrayList<int[]> argumentRanges = new ArrayList<int[]>();
            if (arguments == 0) {
                argumentRanges.add(new int[]{end, end - 1});
            }
            while (arguments-- > 0) {
                int start = this.findInstructionWithRelativeStackDepthOf(end, -1);
                argumentRanges.add(0, new int[]{start, end - 1});
                end = start;
            }
            return argumentRanges;
        }

        int findInstructionWithRelativeStackDepthOf(int index, int relativeDepth) {
            if (relativeDepth == 0) {
                return index;
            }
            int depth = this.getStackSize(index) + relativeDepth;
            for (int i = index - 1; i >= 0; --i) {
                if (this.getStackSize(i) != depth) continue;
                if (i > 0) {
                    AbstractInsnNode n = this.m.instructions.get(i - 1);
                    if (n.getType() == 7) {
                        return this.resolveBranches(i, (LabelNode)n);
                    }
                    if (n.getType() == 13 || n.getType() == 6) continue;
                }
                return i;
            }
            throw new IllegalStateException("Could not find previous stack depth of " + depth + " at " + this.sourceAndLine());
        }

        int resolveBranches(int end, LabelNode label) {
            int start;
            for (int j = start = this.lambdas.isEmpty() ? 0 : this.lambdas.get(this.lambdas.size() - 1).getEnd(); j < end; ++j) {
                AbstractInsnNode n = this.m.instructions.get(j);
                if (n.getType() != 6 || ((JumpInsnNode)n).label != label) continue;
                switch (n.getOpcode()) {
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 198: 
                    case 199: {
                        return this.findInstructionWithRelativeStackDepthOf(j, -1);
                    }
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: {
                        return this.findInstructionWithRelativeStackDepthOf(j, -2);
                    }
                }
            }
            return end;
        }

        int getStackSize(int i) {
            return this.frames[i] == null ? 0 : this.frames[i].getStackSize();
        }

        LocalVariableNode localVariable(VarInsnNode vin) {
            LocalVariableNode local = this.getLocalVariable(vin.var);
            if (local == null) {
                return null;
            }
            if (this.isStoreInstruction(vin) && this.methodLocals.containsKey(local.name)) {
                this.methodMutableLocals.put(local.name, local);
            }
            this.methodLocals.put(local.name, local);
            return local;
        }

        LocalVariableNode localVariable(IincInsnNode iin) {
            LocalVariableNode local = this.getLocalVariable(iin.var);
            if (local == null) {
                return local;
            }
            this.methodMutableLocals.put(local.name, local);
            this.methodLocals.put(local.name, local);
            return local;
        }

        boolean isStoreInstruction(VarInsnNode vin) {
            return vin.getOpcode() >= 54 && vin.getOpcode() <= 58;
        }

        void loadArrayFromLocal(MethodVisitor mv, LocalVariableNode local) {
            mv.visitVarInsn(25, local.index);
        }

        void loadFirstElementOfArray(MethodVisitor mv, Type type) {
            mv.visitInsn(3);
            mv.visitInsn(type.getOpcode(46));
        }

        void storeTopOfStackInArray(MethodVisitor mv, Type type) {
            mv.visitInsn(3);
            mv.visitInsn(type.getSize() == 2 ? 94 : 93);
            mv.visitInsn(88);
            mv.visitInsn(type.getOpcode(79));
        }

        Map<String, LocalVariableNode> getLocalsMutableFromLambdas() {
            HashMap<String, LocalVariableNode> localsMutableFromLambdas = new HashMap<String, LocalVariableNode>();
            for (LambdaAnalyzer lambda : this.lambdas) {
                localsMutableFromLambdas.putAll(lambda.getMutableLocals());
            }
            return localsMutableFromLambdas;
        }

        void initArray(MethodVisitor mv, LocalVariableNode local) {
            mv.visitInsn(4);
            this.newArray(mv, Type.getType(local.desc));
            if (this.isMethodArgument(local)) {
                this.initializeArrayOnTopOfStackWithCurrentValueOfLocal(mv, local);
            }
            mv.visitVarInsn(58, local.index);
        }

        boolean isMethodArgument(LocalVariableNode local) {
            return local.index <= Type.getArgumentTypes(this.m.desc).length;
        }

        void initializeArrayOnTopOfStackWithCurrentValueOfLocal(MethodVisitor mv, LocalVariableNode local) {
            this.initializeArrayOnTopOfStackWithCurrentValueOfLocal(mv, Type.getType(local.desc), local.index);
        }

        void initializeArrayOnTopOfStackWithCurrentValueOfLocal(MethodVisitor mv, Type type, int index) {
            mv.visitInsn(89);
            mv.visitInsn(3);
            mv.visitVarInsn(type.getOpcode(21), index);
            mv.visitInsn(type.getOpcode(79));
        }

        void newArray(MethodVisitor mv, Type type) {
            int arrayType;
            switch (type.getSort()) {
                case 1: {
                    arrayType = 4;
                    break;
                }
                case 2: {
                    arrayType = 5;
                    break;
                }
                case 3: {
                    arrayType = 8;
                    break;
                }
                case 4: {
                    arrayType = 9;
                    break;
                }
                case 5: {
                    arrayType = 10;
                    break;
                }
                case 6: {
                    arrayType = 6;
                    break;
                }
                case 7: {
                    arrayType = 11;
                    break;
                }
                case 8: {
                    arrayType = 7;
                    break;
                }
                default: {
                    mv.visitTypeInsn(189, type.getInternalName());
                    return;
                }
            }
            mv.visitIntInsn(188, arrayType);
        }

        void incrementInArray(MethodVisitor mv, int increment) {
            mv.visitInsn(3);
            mv.visitInsn(92);
            mv.visitInsn(46);
            this.loadInt(mv, increment);
            mv.visitInsn(96);
            mv.visitInsn(79);
        }

        void loadInt(MethodVisitor mv, int value) {
            if (value >= -128 && value <= 127) {
                mv.visitIntInsn(16, value);
            } else if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
                mv.visitIntInsn(17, value);
            } else {
                mv.visitLdcInsn(value);
            }
        }

        boolean isMethodParameter(LocalVariableNode local) {
            return local.index != 0 && local.index < this.method.getArgumentTypes().length;
        }

        boolean isNewLambdaMethod(MethodInsnNode mi) throws IOException {
            MethodNode m = LambdaTreeWeaver.this.findMethod(mi);
            if (m == null) {
                return false;
            }
            boolean hasAnnotation = LambdaTreeWeaver.this.hasAnnotation(m, newLambdaAnnotation);
            if (hasAnnotation) {
                if (LambdaTreeWeaver.this.hasAccess(m, 8)) {
                    return true;
                }
                throw new IllegalStateException("Tried to call non static new lambda method " + m.name + " at " + this.sourceAndLine());
            }
            return false;
        }

        boolean isLambdaParameterField(FieldInsnNode fi) throws IOException {
            FieldNode f = LambdaTreeWeaver.this.findField(fi);
            if (f == null) {
                return false;
            }
            boolean hasAnnotation = LambdaTreeWeaver.this.hasAnnotation(f, lambdaParameterAnnotation);
            if (hasAnnotation) {
                if (LambdaTreeWeaver.this.hasAccess(f, 8)) {
                    return true;
                }
                throw new IllegalStateException("Tried to define non static lambda parameter " + f.name + " at " + this.sourceAndLine());
            }
            return false;
        }

        String sourceAndLine() {
            return LambdaTreeWeaver.this.c.sourceFile != null ? "(" + LambdaTreeWeaver.this.c.sourceFile + ":" + this.line + ")" : "(Unknown Source)";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class LambdaAnalyzer {
            LambdaAnalyzer parent;
            int id;
            int line;
            Method newLambdaMethod;
            List<Type> newLambdaParameterTypes;
            Type lambdaType;
            Type expressionType;
            Set<String> parametersWithDefaultValue = new HashSet<String>();
            Set<String> parametersMutableFromChildLambdas = new HashSet<String>();
            Map<String, FieldNode> parameters = new LinkedHashMap<String, FieldNode>();
            Map<String, String> parameterOwners = new LinkedHashMap<String, String>();
            Map<String, FieldNode> parentParameters = new LinkedHashMap<String, FieldNode>();
            Map<String, LocalVariableNode> locals = new LinkedHashMap<String, LocalVariableNode>();
            List<int[]> argumentRanges;
            Method sam;
            ClassNode lambda;
            MethodNode saMn;
            ASMifierMethodVisitor devDebugAsm = new ASMifierMethodVisitor();

            LambdaAnalyzer(int id, int line, MethodInsnNode mi, List<int[]> argumentRanges) {
                this.id = id;
                this.line = line;
                this.argumentRanges = argumentRanges;
                this.newLambdaMethod = new Method(mi.name, mi.desc);
                this.newLambdaParameterTypes = Arrays.asList(this.newLambdaMethod.getArgumentTypes());
                Type type = this.expressionType = this.newLambdaParameterTypes.isEmpty() ? Type.getType(Object.class) : this.newLambdaParameterTypes.get(this.newLambdaParameterTypes.size() - 1);
                if (!this.newLambdaParameterTypes.isEmpty()) {
                    this.newLambdaParameterTypes = this.newLambdaParameterTypes.subList(0, this.newLambdaParameterTypes.size() - 1);
                }
                this.lambdaType = this.resolveLambdaType();
            }

            void transform(InsnList instructions) throws IOException {
                this.debugLambdaStart();
                this.lambda = new ClassNode();
                this.lambda.visit(49, 4113, this.lambdaClass(), null, this.getSuperType().getInternalName(), this.getLambdaInterfaces());
                this.lambda.visitSource(LambdaTreeWeaver.this.c.sourceFile, null);
                this.createLambdaConstructor();
                this.createSAMethod();
                for (String parameter : this.parametersWithDefaultValue) {
                    int[] range = this.argumentRanges.get(this.getParameterIndex(parameter));
                    this.captureDefaultParameterValue(parameter, range[0], range[1], instructions);
                }
                for (String parameter : this.parametersMutableFromChildLambdas) {
                    if (!this.parameters.containsKey(parameter)) continue;
                    int index = this.getParameterRealLocalIndex(parameter);
                    this.initArray(this.saMn, this.getParameterTypes().get(this.getParameterIndex(parameter)), index);
                }
                for (int i = this.getBodyStart(); i < this.getEnd(); ++i) {
                    AbstractInsnNode n = instructions.get(i);
                    if (MethodAnalyzer.this.currentLambda < MethodAnalyzer.this.lambdas.size() && i == MethodAnalyzer.this.lambdas.get(MethodAnalyzer.this.currentLambda).getStart()) {
                        LambdaAnalyzer la = MethodAnalyzer.this.lambdas.get(MethodAnalyzer.this.currentLambda);
                        i = MethodAnalyzer.this.lambdas.get(MethodAnalyzer.this.currentLambda).getEnd();
                        ++MethodAnalyzer.this.currentLambda;
                        la.transform(instructions);
                        la.instantiate(this.saMn, this);
                        continue;
                    }
                    if (!this.isInSAMBody(i)) continue;
                    this.handleInsnNodeInSAM(this.saMn, n);
                }
                this.returnFromSAMethod();
                this.lambda.visitOuterClass(LambdaTreeWeaver.this.c.name, MethodAnalyzer.this.m.name, MethodAnalyzer.this.m.desc);
                LambdaTreeWeaver.this.c.visitInnerClass(this.lambdaClass(), LambdaTreeWeaver.this.c.name, null, 0);
                Debug.devDebug("new lambda ================= ");
                if (Debug.devDebug) {
                    this.lambda.accept(new ASMifierClassVisitor(new PrintWriter(System.out)));
                }
            }

            void debugLambdaStart() {
                String localsString = "";
                if (!this.locals.isEmpty()) {
                    localsString = " closing over " + this.locals.keySet();
                }
                Debug.debug("lambda #" + LambdaTreeWeaver.this.getSimpleClassName(this.expressionType) + this.getTypedParametersString() + localsString + " as " + this.sam + " in " + LambdaTreeWeaver.this.getSimpleClassName(this.lambdaType) + " at " + this.sourceAndLine());
            }

            void handleInsnNodeInSAM(MethodVisitor mv, AbstractInsnNode n) throws IOException {
                int type = n.getType();
                if (type == 2) {
                    VarInsnNode vin = (VarInsnNode)n;
                    LocalVariableNode local = MethodAnalyzer.this.getLocalVariable(vin.var);
                    this.debugLocalVariableAccess(local, MethodAnalyzer.this.isStoreInstruction(vin));
                    if (local == null) {
                        n.accept(mv);
                    } else if (MethodAnalyzer.this.getLocalsMutableFromLambdas().containsKey(local.name)) {
                        this.loadLambdaField(mv, local, LambdaTreeWeaver.this.toArrayType(Type.getType(local.desc)));
                        if (MethodAnalyzer.this.isStoreInstruction(vin)) {
                            MethodAnalyzer.this.storeTopOfStackInArray(mv, Type.getType(local.desc));
                        } else {
                            MethodAnalyzer.this.loadFirstElementOfArray(mv, Type.getType(local.desc));
                        }
                    } else {
                        this.loadLambdaField(mv, local, Type.getType(local.desc));
                    }
                } else if (type == 4) {
                    FieldInsnNode fin = (FieldInsnNode)n;
                    if (MethodAnalyzer.this.isLambdaParameterField(fin)) {
                        this.accessParameter(mv, fin);
                    } else if (this.isPrivateFieldOnOwnerWhichNeedsAcccessMethodFromLambda(fin)) {
                        MethodNode am = this.getAccessMethodReplacingPrivateFieldAccess(fin);
                        mv.visitMethodInsn(184, LambdaTreeWeaver.this.c.name, am.name, am.desc);
                    } else {
                        n.accept(mv);
                    }
                } else if (type == 9) {
                    IincInsnNode iinc = (IincInsnNode)n;
                    LocalVariableNode local = MethodAnalyzer.this.getLocalVariable(iinc.var);
                    if (local != null) {
                        this.loadLambdaField(mv, local, LambdaTreeWeaver.this.toArrayType(Type.getType(local.desc)));
                        MethodAnalyzer.this.incrementInArray(mv, iinc.incr);
                    }
                } else if (type == 5) {
                    MethodInsnNode mn = (MethodInsnNode)n;
                    if (this.isPrivateMethodOnOwnerWhichNeedsAcccessMethodFromLambda(mn)) {
                        MethodNode am = this.getAccessMethodReplacingPrivateMethodInvocation(mn);
                        mv.visitMethodInsn(184, LambdaTreeWeaver.this.c.name, am.name, am.desc);
                    } else {
                        n.accept(mv);
                    }
                } else {
                    n.accept(mv);
                }
            }

            void initArray(MethodVisitor mv, Type type, int index) {
                mv.visitInsn(4);
                MethodAnalyzer.this.newArray(mv, type);
                MethodAnalyzer.this.initializeArrayOnTopOfStackWithCurrentValueOfLocal(mv, type, index);
                mv.visitVarInsn(58, index);
            }

            MethodNode getAccessMethodReplacingPrivateFieldAccess(FieldInsnNode fn) {
                int opcode = fn.getOpcode();
                boolean write = opcode == 181 || opcode == 179;
                String key = fn.name.substring(0, 1).toUpperCase() + fn.name.substring(1);
                key = (write ? "set" : "get") + key;
                if (LambdaTreeWeaver.this.staticAccessMethodsByFieldName.containsKey(key = key + (opcode == 178 || opcode == 179 ? "Static" : ""))) {
                    return LambdaTreeWeaver.this.staticAccessMethodsByFieldName.get(key);
                }
                ArrayList<Type> argumentTypes = new ArrayList<Type>();
                if (opcode == 180 || opcode == 181) {
                    argumentTypes.add(Type.getObjectType(fn.owner));
                }
                if (write) {
                    argumentTypes.add(Type.getType(fn.desc));
                }
                Type returnType = Type.getType(fn.desc);
                MethodNode am = this.createAccessMethodAndLoadArguments("field$" + fn.name, argumentTypes, returnType);
                fn.accept(am);
                if (write) {
                    int indexOfNewFieldValue = argumentTypes.size() - 1;
                    am.visitVarInsn(((Type)argumentTypes.get(indexOfNewFieldValue)).getOpcode(21), indexOfNewFieldValue);
                }
                am.visitInsn(returnType.getOpcode(172));
                am.visitMaxs(0, 0);
                am.visitEnd();
                LambdaTreeWeaver.this.staticAccessMethodsByFieldName.put(key, am);
                return am;
            }

            void debugLocalVariableAccess(LocalVariableNode local, boolean store) {
                boolean readOnly = MethodAnalyzer.this.methodMutableLocals.containsKey(local.name);
                Debug.debug("variable " + local.name + " " + LambdaTreeWeaver.this.getSimpleClassName(Type.getType(local.desc)) + (store ? (readOnly ? " initalized in" : " stored in") : " read from") + (readOnly ? " final" : " wrapped array in") + " lambda field " + this.getFieldNameForLocal(local) + (MethodAnalyzer.this.isMethodParameter(local) ? " method parameter " : " local ") + local.name);
            }

            void debugLambdaParameterAccess(FieldInsnNode fin, int realLocalIndex) {
                Debug.debug("parameter " + fin.name + " " + LambdaTreeWeaver.this.getSimpleClassName(Type.getType(fin.desc)) + (fin.getOpcode() == 179 ? " stored in" : " read from") + " lambda local " + realLocalIndex);
            }

            MethodNode getAccessMethodReplacingPrivateMethodInvocation(MethodInsnNode mn) {
                String key = mn.name + mn.desc;
                if (LambdaTreeWeaver.this.staticAccessMethodsByMethodNameAndDesc.containsKey(key)) {
                    return LambdaTreeWeaver.this.staticAccessMethodsByMethodNameAndDesc.get(mn.name + mn.desc);
                }
                ArrayList<Type> argumentTypes = new ArrayList<Type>();
                int opcode = mn.getOpcode();
                if (opcode != 184) {
                    argumentTypes.add(Type.getObjectType(mn.owner));
                }
                Collections.addAll(argumentTypes, Type.getArgumentTypes(mn.desc));
                MethodNode am = this.createAccessMethodAndLoadArguments("method$" + mn.name, argumentTypes, Type.getReturnType(mn.desc));
                mn.accept(am);
                am.visitInsn(Type.getReturnType(mn.desc).getOpcode(172));
                am.visitMaxs(0, 0);
                am.visitEnd();
                LambdaTreeWeaver.this.staticAccessMethodsByMethodNameAndDesc.put(key, am);
                return am;
            }

            MethodNode createAccessMethodAndLoadArguments(String name, List<Type> argumentTypes, Type returnType) {
                String accessMethodDescriptor = Type.getMethodDescriptor(returnType, argumentTypes.toArray(new Type[0]));
                String accessMethodName = "access$lambda$" + name;
                MethodNode am = (MethodNode)LambdaTreeWeaver.this.c.visitMethod(4104, accessMethodName, accessMethodDescriptor, null, null);
                am.visitCode();
                int i = 0;
                for (Type type : argumentTypes) {
                    am.visitVarInsn(type.getOpcode(21), i++);
                }
                return am;
            }

            boolean isPrivateFieldOnOwnerWhichNeedsAcccessMethodFromLambda(FieldInsnNode fn) throws IOException {
                return LambdaTreeWeaver.this.c.name.equals(fn.owner) && LambdaTreeWeaver.this.hasAccess(LambdaTreeWeaver.this.findField(fn), 2);
            }

            boolean isPrivateMethodOnOwnerWhichNeedsAcccessMethodFromLambda(MethodInsnNode mn) throws IOException {
                return LambdaTreeWeaver.this.c.name.equals(mn.owner) && (183 == mn.getOpcode() || 184 == mn.getOpcode()) && LambdaTreeWeaver.this.hasAccess(LambdaTreeWeaver.this.findMethod(mn), 2);
            }

            void captureDefaultParameterValue(String name, int start, int end, InsnList insns) throws IOException {
                Type returnType;
                int parameterIndex = this.getParameterIndex(name);
                Type defaultParameterValueType = this.getParameterTypes().get(parameterIndex);
                Debug.debug("parameter " + name + " " + LambdaTreeWeaver.this.getSimpleClassName(defaultParameterValueType) + " has default value");
                MethodNode mv = (MethodNode)this.lambda.visitMethod(4100, "default$" + (parameterIndex + 1), Type.getMethodDescriptor(Type.getType(Object.class), new Type[0]), null, null);
                mv.visitCode();
                for (int i = start; i < end; ++i) {
                    this.handleInsnNodeInSAM(mv, insns.get(i));
                }
                Type type = returnType = LambdaTreeWeaver.this.isReference(defaultParameterValueType) ? defaultParameterValueType : this.getBoxedType(defaultParameterValueType);
                if (LambdaTreeWeaver.this.isPrimitive(defaultParameterValueType)) {
                    this.box(mv, defaultParameterValueType);
                }
                mv.visitInsn(returnType.getOpcode(172));
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }

            void accessParameter(MethodVisitor mv, FieldInsnNode fin) throws IOException {
                Type type = Type.getType(fin.desc);
                if (this.parentParameters.containsKey(fin.name)) {
                    this.accessParentParameter(mv, fin, type);
                    return;
                }
                int realLocalIndex = this.getParameterRealLocalIndex(fin.name);
                this.debugLambdaParameterAccess(fin, realLocalIndex);
                if (this.parametersMutableFromChildLambdas.contains(fin.name)) {
                    mv.visitVarInsn(25, realLocalIndex);
                    if (fin.getOpcode() == 179) {
                        MethodAnalyzer.this.storeTopOfStackInArray(mv, type);
                    } else {
                        MethodAnalyzer.this.loadFirstElementOfArray(mv, type);
                    }
                } else if (fin.getOpcode() == 179) {
                    mv.visitVarInsn(type.getOpcode(54), realLocalIndex);
                } else {
                    mv.visitVarInsn(type.getOpcode(21), realLocalIndex);
                    if (LambdaTreeWeaver.this.isReference(type)) {
                        mv.visitTypeInsn(192, type.getInternalName());
                    }
                }
            }

            void accessParentParameter(MethodVisitor mv, FieldInsnNode fin, Type type) {
                mv.visitVarInsn(25, 0);
                if (this.parametersMutableFromChildLambdas.contains(fin.name)) {
                    mv.visitFieldInsn(180, this.lambdaClass(), this.getParentParameterName(fin.name), LambdaTreeWeaver.this.toArrayType(type).getDescriptor());
                    if (fin.getOpcode() == 179) {
                        MethodAnalyzer.this.storeTopOfStackInArray(mv, type);
                    } else {
                        MethodAnalyzer.this.loadFirstElementOfArray(mv, type);
                    }
                } else {
                    mv.visitFieldInsn(180, this.lambdaClass(), this.getParentParameterName(fin.name), type.getDescriptor());
                }
                Debug.debug("parameter " + fin.name + " " + LambdaTreeWeaver.this.getSimpleClassName(Type.getType(fin.desc)) + (fin.getOpcode() == 179 ? " stored in" : " read from") + " parent lambda parameter");
            }

            String getParentParameterName(String name) {
                return name + "$parentParameter";
            }

            int getParameterRealLocalIndex(String name) {
                List<Type> parameterTypes = this.getParameterTypes();
                int index = 1;
                for (int i = 0; i < parameterTypes.size() && this.getParameterIndex(name) != i; ++i) {
                    index += parameterTypes.get(i).getSize();
                }
                return index;
            }

            void loadLambdaField(MethodVisitor mv, LocalVariableNode local, Type type) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.lambdaClass(), this.getFieldNameForLocal(local), type.getDescriptor());
            }

            void createSAMethod() {
                this.saMn = (MethodNode)this.lambda.visitMethod(4097, this.sam.getName(), this.sam.getDescriptor(), null, null);
                this.addLambdaParameterAnnotations();
                this.saMn.visitCode();
                this.insertLineNumber();
                this.convertMethodArgumentsToLambdaParameterTypes();
            }

            void insertLineNumber() {
                Label lineLabel = new Label();
                this.saMn.visitLabel(lineLabel);
                this.saMn.visitLineNumber(this.line, lineLabel);
            }

            void addLambdaParameterAnnotations() {
                if (lambdaLocalAnnotation == null) {
                    return;
                }
                int i = 0;
                for (String parameter : this.parameters.keySet()) {
                    AnnotationVisitor annotation = this.saMn.visitParameterAnnotation(i++, lambdaLocalAnnotation.getDescriptor(), true);
                    annotation.visit("name", parameter);
                    annotation.visit("parameterClass", Type.getObjectType(this.parameterOwners.get(parameter)).getClassName());
                    annotation.visitEnd();
                }
            }

            void convertMethodArgumentsToLambdaParameterTypes() {
                Type[] methodParameterTypes = this.sam.getArgumentTypes();
                Type[] lambdaParameterTypes = this.getParameterTypes().toArray(new Type[0]);
                for (int i = 0; i < methodParameterTypes.length; ++i) {
                    Type methodParameterType = methodParameterTypes[i];
                    Type lambdaParameterType = lambdaParameterTypes[i];
                    if (methodParameterType.equals(lambdaParameterType) || LambdaTreeWeaver.this.isReference(methodParameterType) && LambdaTreeWeaver.this.isReference(lambdaParameterType)) continue;
                    this.convertMethodArgumentIntoLambdaParameterType(i, methodParameterType, lambdaParameterType);
                }
            }

            void convertMethodArgumentIntoLambdaParameterType(int parameterIndex, Type methodParameterType, Type lambdaParameterType) {
                int localIndex = this.getParameterRealLocalIndex(this.getParameter(parameterIndex));
                Debug.debug("parameter " + this.getParameter(parameterIndex) + " converted from " + LambdaTreeWeaver.this.getSimpleClassName(methodParameterType) + " to " + LambdaTreeWeaver.this.getSimpleClassName(lambdaParameterType) + " in lambda local " + localIndex);
                if (LambdaTreeWeaver.this.isReference(methodParameterType) && LambdaTreeWeaver.this.isPrimitive(lambdaParameterType)) {
                    this.unboxLocal(this.saMn, localIndex, lambdaParameterType);
                } else if (LambdaTreeWeaver.this.isPrimitive(methodParameterType) && LambdaTreeWeaver.this.isPrimitive(lambdaParameterType)) {
                    this.convertNarrowlyBetweenPrimitiveWiderMethodArgumentTypeIntoLambdaParameterType(methodParameterType, lambdaParameterType, localIndex);
                }
            }

            void convertNarrowlyBetweenPrimitiveWiderMethodArgumentTypeIntoLambdaParameterType(Type methodParameterType, Type lambdaParameterType, int localIndex) {
                if (Type.DOUBLE_TYPE == methodParameterType) {
                    switch (lambdaParameterType.getSort()) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            this.convertPrimitive(this.saMn, methodParameterType, lambdaParameterType, localIndex, 142);
                            break;
                        }
                        case 6: {
                            this.convertPrimitive(this.saMn, methodParameterType, lambdaParameterType, localIndex, 144);
                            break;
                        }
                        case 7: {
                            this.convertPrimitive(this.saMn, methodParameterType, lambdaParameterType, localIndex, 143);
                        }
                    }
                } else if (Type.LONG_TYPE == methodParameterType) {
                    this.convertPrimitive(this.saMn, methodParameterType, lambdaParameterType, localIndex, 136);
                }
            }

            void convertPrimitive(MethodNode mv, Type from, Type to, int local, int opcode) {
                mv.visitVarInsn(from.getOpcode(21), local);
                mv.visitInsn(opcode);
                mv.visitVarInsn(to.getOpcode(54), local);
            }

            void unboxLocal(MethodNode mv, int local, Type type) {
                mv.visitVarInsn(25, local);
                this.unbox(mv, type);
                mv.visitVarInsn(type.getOpcode(54), local);
            }

            void unbox(MethodNode mv, Type primitiveType) {
                Type type = Type.getType(Number.class);
                switch (primitiveType.getSort()) {
                    case 0: 
                    case 9: 
                    case 10: {
                        return;
                    }
                    case 2: {
                        type = Type.getType(Character.class);
                        break;
                    }
                    case 1: {
                        type = Type.getType(Boolean.class);
                    }
                }
                String descriptor = Type.getMethodDescriptor(primitiveType, new Type[0]);
                String name = primitiveType.getClassName() + "Value";
                mv.visitTypeInsn(192, type.getInternalName());
                mv.visitMethodInsn(182, type.getInternalName(), name, descriptor);
            }

            Type getBoxedType(Type type) {
                switch (type.getSort()) {
                    case 1: {
                        return Type.getType(Boolean.class);
                    }
                    case 2: {
                        return Type.getType(Character.class);
                    }
                    case 3: {
                        return Type.getType(Byte.class);
                    }
                    case 4: {
                        return Type.getType(Short.class);
                    }
                    case 5: {
                        return Type.getType(Integer.class);
                    }
                    case 6: {
                        return Type.getType(Float.class);
                    }
                    case 7: {
                        return Type.getType(Long.class);
                    }
                    case 8: {
                        return Type.getType(Double.class);
                    }
                }
                return type;
            }

            void returnFromSAMethod() {
                if (this.getStart() == this.getEnd()) {
                    this.saMn.visitInsn(1);
                }
                this.handleBoxingAndUnboxingOfReturnFromLambda(this.sam.getReturnType(), this.expressionType);
                this.saMn.visitInsn(this.sam.getReturnType().getOpcode(172));
                MethodAnalyzer.this.endMethod(this.saMn);
            }

            void handleBoxingAndUnboxingOfReturnFromLambda(Type returnType, Type lambdaExpressionType) {
                if (LambdaTreeWeaver.this.isPrimitive(returnType) && LambdaTreeWeaver.this.isReference(lambdaExpressionType)) {
                    this.unbox(this.saMn, returnType);
                    Debug.debug("unboxed return value with type " + LambdaTreeWeaver.this.getSimpleClassName(lambdaExpressionType) + " as " + LambdaTreeWeaver.this.getSimpleClassName(returnType));
                }
                if (LambdaTreeWeaver.this.isReference(returnType) && LambdaTreeWeaver.this.isPrimitive(lambdaExpressionType)) {
                    this.box(this.saMn, lambdaExpressionType);
                    Debug.debug("boxed return value with type " + LambdaTreeWeaver.this.getSimpleClassName(lambdaExpressionType) + " as " + LambdaTreeWeaver.this.getSimpleClassName(returnType));
                }
            }

            void box(MethodVisitor mv, Type type) {
                if (LambdaTreeWeaver.this.isReference(type)) {
                    return;
                }
                Type boxed = this.getBoxedType(type);
                String descriptor = Type.getMethodDescriptor(boxed, new Type[]{type});
                String name = "valueOf";
                mv.visitMethodInsn(184, boxed.getInternalName(), name, descriptor);
            }

            boolean isInSAMBody(int index) {
                return index >= this.getBodyStart() && index != this.getEnd();
            }

            void createLambdaConstructor() throws IOException {
                Type[] parameters = this.getConstructorParameters();
                String descriptor = Type.getMethodDescriptor(Type.VOID_TYPE, parameters);
                MethodVisitor mv = this.lambda.visitMethod(1, "<init>", descriptor, null, null);
                mv.visitCode();
                this.createAndInitializeFieldsWithAccessedLocals(mv, parameters);
                this.invokeSuperConstructor(mv);
                mv.visitInsn(177);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }

            void instantiate(MethodVisitor mv, LambdaAnalyzer parentLambda) {
                mv.visitTypeInsn(187, this.lambdaClass());
                mv.visitInsn(89);
                this.loadAccessedLocals(mv, parentLambda);
                String descriptor = Type.getMethodDescriptor(Type.VOID_TYPE, this.getConstructorParameters());
                mv.visitMethodInsn(183, this.lambdaClass(), "<init>", descriptor);
            }

            void loadAccessedLocals(MethodVisitor mv, LambdaAnalyzer parentLambda) {
                Type type;
                for (FieldNode f : this.parentParameters.values()) {
                    type = Type.getType(f.desc);
                    if (this.parametersMutableFromChildLambdas.contains(f.name)) {
                        type = LambdaTreeWeaver.this.toArrayType(type);
                    }
                    if (parentLambda.parameters.containsKey(f.name)) {
                        mv.visitVarInsn(type.getOpcode(21), parentLambda.getParameterRealLocalIndex(f.name));
                        if (!LambdaTreeWeaver.this.isReference(type)) continue;
                        mv.visitTypeInsn(192, type.getInternalName());
                        continue;
                    }
                    mv.visitVarInsn(25, 0);
                    mv.visitFieldInsn(180, parentLambda.lambda.name, this.getParentParameterName(f.name), type.getDescriptor());
                }
                for (LocalVariableNode local : this.locals.values()) {
                    type = Type.getType(local.desc);
                    if (MethodAnalyzer.this.methodMutableLocals.containsKey(local.name)) {
                        type = LambdaTreeWeaver.this.toArrayType(type);
                    }
                    if (parentLambda != null) {
                        mv.visitVarInsn(25, 0);
                        mv.visitFieldInsn(180, parentLambda.lambda.name, this.getFieldNameForLocal(local), type.getDescriptor());
                        continue;
                    }
                    mv.visitVarInsn(type.getOpcode(21), local.index);
                }
            }

            void invokeSuperConstructor(MethodVisitor mv) throws IOException {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(183, this.getSuperType().getInternalName(), "<init>", "()V");
            }

            void createAndInitializeFieldsWithAccessedLocals(MethodVisitor mv, Type[] parameters) {
                Type type;
                int i = 1;
                for (FieldNode f : this.parentParameters.values()) {
                    type = parameters[i - 1];
                    this.loadFieldFromArgument(mv, i++, f.name, this.getParentParameterName(f.name), type);
                }
                for (LocalVariableNode local : this.locals.values()) {
                    type = parameters[i - 1];
                    this.loadFieldFromArgument(mv, i++, local.name, this.getFieldNameForLocal(local), type);
                }
            }

            void loadFieldFromArgument(MethodVisitor mv, int i, String name, String fieldName, Type type) {
                FieldVisitor fieldVisitor = this.lambda.visitField(4114, fieldName, type.getDescriptor(), null, null);
                this.addLambdaLocalAnnotation(name, fieldVisitor);
                fieldVisitor.visitEnd();
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(type.getOpcode(21), i);
                mv.visitFieldInsn(181, this.lambdaClass(), fieldName, type.getDescriptor());
            }

            String getFieldNameForLocal(LocalVariableNode local) {
                return local.name + "$" + local.index;
            }

            void addLambdaLocalAnnotation(String local, FieldVisitor fieldVisitor) {
                if (lambdaLocalAnnotation == null) {
                    return;
                }
                AnnotationVisitor annotationVisitor = fieldVisitor.visitAnnotation(lambdaLocalAnnotation.getDescriptor(), true);
                annotationVisitor.visit("isReadOnly", !MethodAnalyzer.this.methodMutableLocals.containsKey(local));
                annotationVisitor.visit("name", local);
                annotationVisitor.visitEnd();
            }

            Type getSuperType() throws IOException {
                Type type = this.lambdaType;
                if (LambdaTreeWeaver.this.hasAccess(LambdaTreeWeaver.this.readClassNoCode(type.getInternalName()), 512)) {
                    type = Type.getType(Object.class);
                }
                return type;
            }

            String[] getLambdaInterfaces() throws IOException {
                Type type = this.lambdaType;
                if (LambdaTreeWeaver.this.hasAccess(LambdaTreeWeaver.this.readClassNoCode(type.getInternalName()), 512)) {
                    return new String[]{type.getInternalName()};
                }
                return null;
            }

            Type[] getConstructorParameters() {
                Type type;
                ArrayList<Type> result = new ArrayList<Type>();
                for (FieldNode parentParameter : this.parentParameters.values()) {
                    type = Type.getType(parentParameter.desc);
                    result.add(this.parametersMutableFromChildLambdas.contains(parentParameter.name) ? LambdaTreeWeaver.this.toArrayType(type) : type);
                }
                for (String local : this.locals.keySet()) {
                    type = this.getLocalVariableType(local);
                    result.add(MethodAnalyzer.this.methodMutableLocals.containsKey(local) ? LambdaTreeWeaver.this.toArrayType(type) : type);
                }
                return result.toArray(new Type[0]);
            }

            String getTypedParametersString() {
                ArrayList<String> result = new ArrayList<String>();
                for (FieldNode parameter : this.parameters.values()) {
                    result.add(LambdaTreeWeaver.this.getSimpleClassName(Type.getType(parameter.desc)) + " " + parameter.name);
                }
                return this.toParameterString(result);
            }

            String toParameterString(Collection<?> parameters) {
                StringBuilder sb = new StringBuilder(parameters.toString());
                sb.setCharAt(0, '(');
                sb.setCharAt(sb.length() - 1, ')');
                return sb.toString();
            }

            String sourceAndLine() {
                return LambdaTreeWeaver.this.c.sourceFile != null ? "(" + LambdaTreeWeaver.this.c.sourceFile + ":" + this.line + ")" : "(Unknown Source)";
            }

            Type resolveLambdaType() {
                AbstractInsnNode n;
                Type lambdaType = this.newLambdaMethod.getReturnType();
                if (Type.getType(Object.class).equals(lambdaType) && MethodAnalyzer.this.m.instructions.size() > this.getEnd() && (n = MethodAnalyzer.this.m.instructions.get(this.getEnd() + 1)).getOpcode() == 192) {
                    lambdaType = Type.getObjectType(((TypeInsnNode)n).desc);
                }
                return lambdaType;
            }

            void analyze() throws IOException {
                int i;
                Debug.devDebug("lambda ================ " + this.getStart() + " -> " + this.getEnd());
                this.devDebugPrintInstructionHeader();
                this.resolveParentLambda();
                int childLambda = MethodAnalyzer.this.lambdas.indexOf(this) + 1;
                boolean inChildLambda = false;
                for (i = this.getStart(); i < this.getEnd(); ++i) {
                    FieldNode f;
                    int type;
                    AbstractInsnNode n = MethodAnalyzer.this.m.instructions.get(i);
                    this.devDebugPrintInstruction(i, i - this.getStart(), MethodAnalyzer.this.frames[i], n);
                    if (childLambda < MethodAnalyzer.this.lambdas.size() && i >= MethodAnalyzer.this.lambdas.get(childLambda).getStart()) {
                        inChildLambda = true;
                    }
                    if (childLambda < MethodAnalyzer.this.lambdas.size() && i > MethodAnalyzer.this.lambdas.get(childLambda).getEnd()) {
                        inChildLambda = false;
                        ++childLambda;
                    }
                    if ((type = n.getType()) == 2) {
                        this.methodLocalVariable((VarInsnNode)n);
                    }
                    if (type == 5) {
                        MethodNode m;
                        MethodInsnNode min = (MethodInsnNode)n;
                        if (min.owner.equals(LambdaTreeWeaver.this.c.name) && LambdaTreeWeaver.this.hasAccess(m = LambdaTreeWeaver.this.findMethod(min), 2)) {
                            LambdaTreeWeaver.this.methodsThatNeedStaticAccessMethod.put(m.name, m);
                        }
                    }
                    if (type != 4) continue;
                    FieldInsnNode fin = (FieldInsnNode)n;
                    if (MethodAnalyzer.this.isLambdaParameterField(fin) && !inChildLambda) {
                        this.lambdaParameter(fin);
                        continue;
                    }
                    if (!fin.owner.equals(LambdaTreeWeaver.this.c.name) || !LambdaTreeWeaver.this.hasAccess(f = LambdaTreeWeaver.this.findField(fin), 2)) continue;
                    LambdaTreeWeaver.this.fieldsThatNeedStaticAccessMethod.put(f.name, f);
                }
                Debug.devDebug("end =================== " + this.getStart() + " -> " + this.getEnd());
                i = 0;
                for (int[] range : this.argumentRanges) {
                    String parameter = ++i >= this.parameters.keySet().size() ? "<missing>" : this.getParameter(i);
                    Debug.devDebug("    " + (i == this.argumentRanges.size() - 1 ? "body: " : "argument " + parameter + ": ") + range[0] + " -> " + range[1]);
                }
                Debug.devDebug("    type: " + this.lambdaType);
                Debug.devDebug("    class: " + this.lambdaClass());
                this.sam = this.findSAM(this.lambdaType);
                if (this.sam == null) {
                    throw new IllegalStateException("Found no potential abstract method to override at " + this.sourceAndLine());
                }
                Debug.devDebug("    SAM is: " + this.sam);
                Debug.devDebug("    parameters: " + this.parameters.keySet());
                Debug.devDebug("    method parameter types: " + this.newLambdaParameterTypes);
                Debug.devDebug("    expression type: " + this.expressionType);
                Debug.devDebug("    mutable locals: " + this.getMutableLocals().keySet());
                Debug.devDebug("    final locals: " + this.locals.keySet());
                if (this.parent != null) {
                    Debug.devDebug("    parent: " + this.parent.getStart() + " -> " + this.parent.getEnd());
                }
                if (this.newLambdaParameterTypes.size() != this.parameters.size()) {
                    throw new IllegalStateException("Got " + this.parameters.keySet() + " as parameters need exactly " + this.newLambdaParameterTypes.size() + " at " + this.sourceAndLine());
                }
            }

            void devDebugPrintInstructionHeader() {
                if (!Debug.devDebug) {
                    return;
                }
                System.out.print("index\t");
                System.out.print("stack");
                System.out.println("");
            }

            void devDebugPrintInstruction(int index, int textIndex, Frame frame, AbstractInsnNode n) {
                if (!Debug.devDebug) {
                    return;
                }
                n.accept(this.devDebugAsm);
                System.out.print(index + "\t");
                System.out.print(frame + "\t\t");
                System.out.print(this.devDebugAsm.getText().get(textIndex));
            }

            void resolveParentLambda() {
                for (LambdaAnalyzer lambda : MethodAnalyzer.this.lambdas) {
                    if (lambda.getEnd() <= this.getEnd() || lambda.getStart() >= this.getStart()) continue;
                    this.parent = lambda;
                }
            }

            Method findSAM(Type type) throws IOException {
                ClassNode cn = LambdaTreeWeaver.this.readClassNoCode(type.getInternalName());
                for (MethodNode mn : cn.methods) {
                    if (!LambdaTreeWeaver.this.hasAccess(mn, 1024) || Type.getArgumentTypes(mn.desc).length != this.newLambdaParameterTypes.size()) continue;
                    return new Method(mn.name, mn.desc);
                }
                for (String anInterface : cn.interfaces) {
                    Method foundSam = this.findSAM(Type.getObjectType(anInterface));
                    if (foundSam == null) continue;
                    return foundSam;
                }
                if (cn.superName != null) {
                    return this.findSAM(Type.getObjectType(cn.superName));
                }
                return null;
            }

            void lambdaParameter(FieldInsnNode fin) throws IOException {
                FieldNode f = LambdaTreeWeaver.this.findField(fin);
                if (!this.parameters.containsKey(f.name)) {
                    boolean hasDefaultValue;
                    if (this.parameters.size() == this.newLambdaParameterTypes.size()) {
                        if (!this.resolveParameter(fin)) {
                            throw new IllegalStateException("Tried to define extra parameter, " + f.name + ", arity is " + this.newLambdaParameterTypes.size() + ", defined parameters are " + this.parameters.keySet() + " at " + this.sourceAndLine());
                        }
                        return;
                    }
                    Type argumentType = Type.getType(fin.desc);
                    this.parameters.put(f.name, f);
                    this.parameterOwners.put(f.name, fin.owner);
                    boolean bl = hasDefaultValue = fin.getOpcode() == 179;
                    if (hasDefaultValue) {
                        this.parametersWithDefaultValue.add(f.name);
                    }
                    Debug.devDebug("  --  defined parameter " + fin.name + " " + argumentType.getClassName() + " as " + this.parameters.size() + " out of " + this.newLambdaParameterTypes.size() + (hasDefaultValue ? " (has default value starting at " + this.argumentRanges.get(this.getParameterIndex(f.name))[0] + ")" : ""));
                } else {
                    Debug.devDebug("  --  accessed parameter " + fin.name + " " + Type.getType(f.desc).getClassName() + " (" + (fin.getOpcode() == 179 ? "write" : "read") + ")");
                }
            }

            boolean resolveParameter(FieldInsnNode fin) throws IOException {
                if (this.parameters.containsKey(fin.name)) {
                    if (fin.getOpcode() == 179) {
                        this.parametersMutableFromChildLambdas.add(fin.name);
                    }
                    return true;
                }
                if (this.parent == null) {
                    return false;
                }
                if (fin.getOpcode() == 179) {
                    this.parametersMutableFromChildLambdas.add(fin.name);
                }
                this.parentParameters.put(fin.name, LambdaTreeWeaver.this.findField(fin));
                return this.parent.resolveParameter(fin);
            }

            void methodLocalVariable(VarInsnNode vin) {
                LocalVariableNode local = MethodAnalyzer.this.localVariable(vin);
                if (local == null) {
                    throw new IllegalStateException("Debug information is needed to close over local variables or parameters, please recompile with -g.");
                }
                this.locals.put(local.name, local);
                Debug.devDebug("  --  accessed var " + local.index + " " + local.name + " " + Type.getType(local.desc).getClassName() + " write: " + MethodAnalyzer.this.isStoreInstruction(vin));
            }

            String lambdaClass() {
                String lambdaClass = this.lambdaType.getInternalName();
                lambdaClass = lambdaClass.substring(lambdaClass.lastIndexOf("/") + 1, lambdaClass.length());
                return LambdaTreeWeaver.this.c.name + "$" + (this.line > 0 ? String.format("%04d_", this.line) : "") + lambdaClass + "_" + this.id;
            }

            List<Type> getParameterTypes() {
                ArrayList<Type> result = new ArrayList<Type>();
                for (FieldNode f : this.parameters.values()) {
                    result.add(Type.getType(f.desc));
                }
                return result;
            }

            Type getLocalVariableType(String local) {
                return Type.getType(this.locals.get((Object)local).desc);
            }

            boolean returnNeedsUnboxing() {
                return LambdaTreeWeaver.this.isReference(this.expressionType) && LambdaTreeWeaver.this.isPrimitive(this.sam.getReturnType());
            }

            boolean returnNeedsBoxing() {
                return LambdaTreeWeaver.this.isPrimitive(this.expressionType) && LambdaTreeWeaver.this.isReference(this.sam.getReturnType());
            }

            boolean parameterDefaultValueNeedsBoxing(String name) {
                return LambdaTreeWeaver.this.isPrimitive(Type.getType(this.parameters.get((Object)name).desc));
            }

            boolean parameterNeedsUnboxing(String name) {
                int index = this.getParameterIndex(name);
                Type samParameterType = this.sam.getArgumentTypes()[index];
                return LambdaTreeWeaver.this.isPrimitive(this.getParameterTypes().get(index)) && LambdaTreeWeaver.this.isReference(samParameterType);
            }

            boolean parameterNeedsBoxing(String name) {
                int index = this.getParameterIndex(name);
                Type samParameterType = this.sam.getArgumentTypes()[index];
                return LambdaTreeWeaver.this.isReference(this.getParameterTypes().get(index)) && LambdaTreeWeaver.this.isPrimitive(samParameterType);
            }

            int getParameterIndex(String name) {
                return new ArrayList<String>(this.parameters.keySet()).indexOf(name);
            }

            String getParameter(int index) {
                return new ArrayList<String>(this.parameters.keySet()).get(index);
            }

            boolean parameterNeedsNarrowConversionFromActualArgument(String name) {
                return this.parameterNarrowConversionOpcode(name) != -1;
            }

            int parameterNarrowConversionOpcode(String name) {
                int index = this.getParameterIndex(name);
                Type samParameterType = this.sam.getArgumentTypes()[index];
                Type parameterType = this.getParameterTypes().get(index);
                if (parameterType.equals(samParameterType)) {
                    return -1;
                }
                if (Type.DOUBLE_TYPE == samParameterType) {
                    switch (parameterType.getSort()) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            return 142;
                        }
                        case 6: {
                            return 144;
                        }
                        case 7: {
                            return 143;
                        }
                    }
                } else if (Type.LONG_TYPE == samParameterType) {
                    return 136;
                }
                return -1;
            }

            Map<String, LocalVariableNode> getMutableLocals() {
                HashMap<String, LocalVariableNode> result = new HashMap<String, LocalVariableNode>(MethodAnalyzer.this.methodMutableLocals);
                result.keySet().retainAll(this.locals.keySet());
                return result;
            }

            int getStart() {
                return this.argumentRanges.get(0)[0];
            }

            int getEnd() {
                return this.argumentRanges.get(this.argumentRanges.size() - 1)[1] + 1;
            }

            int getBodyStart() {
                return this.argumentRanges.get(this.argumentRanges.size() - 1)[0];
            }
        }
    }
}

