/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.components.annotate;

import com.google.common.base.Strings;
import javax.inject.Named;
import org.datacleaner.api.Analyzer;
import org.datacleaner.api.Concurrent;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Description;
import org.datacleaner.api.HasLabelAdvice;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.Provided;
import org.datacleaner.components.annotate.MarkRowsAnalyzerResult;
import org.datacleaner.storage.RowAnnotation;
import org.datacleaner.storage.RowAnnotationFactory;

@Named(value="Mark rows")
@Concurrent(value=true)
@Description(value="Allows the user to mark records with a given description, label, tag or annotation. Each record will be collected and counted, but not written to any external store.\nThis analyzer is particularly useful in combination with other transformations and filtering components - unlocking scenarios where complicated validation logic can be implemented and measured.")
public class MarkRowsAnalyzer
implements Analyzer<MarkRowsAnalyzerResult>,
HasLabelAdvice {
    @Configured
    InputColumn<?>[] columns;
    @Configured
    String conditionDescription = "...";
    @Provided
    RowAnnotation rowAnnotation;
    @Provided
    RowAnnotationFactory rowAnnotationFactory;

    public MarkRowsAnalyzerResult getResult() {
        return new MarkRowsAnalyzerResult(this.rowAnnotation, this.rowAnnotationFactory, this.columns);
    }

    public void run(InputRow row, int distinctCount) {
        this.rowAnnotationFactory.annotate(row, distinctCount, this.rowAnnotation);
    }

    public String getSuggestedLabel() {
        if (!Strings.isNullOrEmpty((String)this.conditionDescription)) {
            return "Mark rows as " + this.conditionDescription;
        }
        return null;
    }
}

