/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.components.annotate;

import java.util.Collection;
import org.datacleaner.api.AnalyzerResultReducer;
import org.datacleaner.api.InputColumn;
import org.datacleaner.components.annotate.MarkRowsAnalyzerResult;
import org.datacleaner.storage.RowAnnotation;
import org.datacleaner.storage.RowAnnotationImpl;

public class MarkRowsAnalyzerResultReducer
implements AnalyzerResultReducer<MarkRowsAnalyzerResult> {
    public MarkRowsAnalyzerResult reduce(Collection<? extends MarkRowsAnalyzerResult> results) {
        InputColumn[] highlightedColumns = null;
        RowAnnotationImpl annotation = new RowAnnotationImpl();
        for (MarkRowsAnalyzerResult markRowsAnalyzerResult : results) {
            int annotatedRowCount = markRowsAnalyzerResult.getAnnotatedRowCount();
            annotation.incrementRowCount(annotatedRowCount);
            if (highlightedColumns != null && highlightedColumns.length != 0) continue;
            highlightedColumns = markRowsAnalyzerResult.getHighlightedColumns();
        }
        return new MarkRowsAnalyzerResult((RowAnnotation)annotation, null, highlightedColumns);
    }
}

