/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.fields;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.xBaseJ.DBF;
import org.xBaseJ.DbaseUtils;
import org.xBaseJ.xBaseJException;

public abstract class Field
implements Cloneable,
Externalizable {
    protected String name;
    protected int nength = 0;
    protected byte[] buffer;
    protected boolean deleted;
    protected ByteBuffer bytebuffer;
    protected long myoffset;
    public static String otherValidCharacters = null;

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.nength = in.readInt();
        in.readFully(this.buffer);
        this.deleted = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeInt(this.nength);
        out.write(this.buffer);
        out.writeBoolean(this.deleted);
    }

    public Object clone() throws CloneNotSupportedException {
        Field tField = (Field)super.clone();
        tField.name = new String(this.name);
        tField.nength = this.nength;
        return tField;
    }

    private void validateName(String iName) throws xBaseJException {
        if (otherValidCharacters == null) {
            try {
                otherValidCharacters = DbaseUtils.getxBaseJProperty("otherValidCharactersInFieldNames");
            }
            catch (IOException e) {
                otherValidCharacters = "";
            }
            if (otherValidCharacters == null) {
                otherValidCharacters = "";
            }
        }
        if (iName == null) {
            throw new xBaseJException("Missing field name");
        }
        if (iName.length() == 0) {
            throw new xBaseJException("Missing field name");
        }
        if (iName.length() > 10) {
            throw new xBaseJException("Invalid field name " + iName);
        }
        for (int i = 0; i < iName.length(); ++i) {
            if (Character.isLetter(iName.charAt(i)) || Character.isDigit(iName.charAt(i)) || iName.charAt(i) == '_' || otherValidCharacters.indexOf(iName.charAt(i)) > -1) continue;
            throw new xBaseJException("Invalid field name " + iName + ", character invalid at " + i);
        }
    }

    public Field() {
        int tlength = this.nength == 0 ? 1 : this.nength;
        this.buffer = new byte[tlength];
        this.buffer[0] = 32;
    }

    public void setField(String iName, int iLength, ByteBuffer inbuffer) throws xBaseJException {
        this.name = iName.trim();
        this.validateName(this.name);
        this.nength = iLength;
        this.setBuffer(inbuffer);
    }

    public void setBuffer(ByteBuffer inBuffer) {
        this.bytebuffer = inBuffer;
        this.setBufferSpace();
    }

    public void setBufferSpace() {
        this.buffer = new byte[this.nength];
    }

    public String getName() {
        return this.name;
    }

    public int getLength() {
        return this.nength;
    }

    public abstract char getType();

    public int getDecimalPositionCount() {
        return 0;
    }

    public void read() throws IOException, xBaseJException {
        this.bytebuffer.get(this.buffer);
    }

    public String get() {
        String s;
        int k;
        for (k = 0; k < this.nength && this.buffer[k] != 0; ++k) {
        }
        if (k == 0) {
            return "";
        }
        try {
            s = new String(this.buffer, 0, k, DBF.encodedType);
        }
        catch (UnsupportedEncodingException UEE) {
            s = new String(this.buffer, 0, k);
        }
        return s;
    }

    public byte[] getBytes() {
        return this.buffer;
    }

    public void write() throws IOException, xBaseJException {
        this.bytebuffer.put(this.buffer);
    }

    public void update() throws IOException, xBaseJException {
        this.bytebuffer.put(this.buffer);
    }

    public void put(String inValue) throws xBaseJException {
        byte[] b;
        if (inValue.length() > this.nength) {
            throw new xBaseJException("Field length too long");
        }
        int i = Math.min(inValue.length(), this.nength);
        try {
            b = inValue.getBytes(DBF.encodedType);
        }
        catch (UnsupportedEncodingException UEE) {
            b = inValue.getBytes();
        }
        for (i = 0; i < b.length; ++i) {
            this.buffer[i] = b[i];
        }
        int fill = DbaseUtils.fieldFilledWithSpaces() ? 32 : 0;
        for (i = inValue.length(); i < this.nength; ++i) {
            this.buffer[i] = fill;
        }
    }

    public void put(byte[] inValue) throws xBaseJException {
        int i;
        if (inValue.length > this.nength) {
            throw new xBaseJException("Field length too long");
        }
        for (i = 0; i < inValue.length; ++i) {
            this.buffer[i] = inValue[i];
        }
        while (i < this.nength) {
            this.buffer[i] = DbaseUtils.fieldFilledWithSpaces() ? 32 : 0;
            ++i;
        }
    }
}

