/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.indexes;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import org.xBaseJ.DBF;
import org.xBaseJ.DbaseUtils;
import org.xBaseJ.indexes.MDXFile;

public class TagHeader {
    RandomAccessFile nfile;
    long pos;
    int top_Node = 0;
    int pagesused = 0;
    byte flags;
    byte keyType;
    byte sql;
    byte resrvd3;
    short key_length;
    short key_per_Node;
    short notused;
    short key_entry_size;
    short changes;
    byte resrvd4;
    byte unique_key;
    byte[] key_definition = new byte[101];
    byte[] for_expression = new byte[101];
    byte[] resrvd5 = new byte[14];
    int[] unknown = new int[4];
    public MDXFile mfile;
    public String NDXString;

    public TagHeader(MDXFile ifile, short ipos) throws IOException {
        this.mfile = ifile;
        this.nfile = ifile.getRandomAccessFile();
        this.setPos(ipos);
        this.read();
    }

    public TagHeader(MDXFile ifile, short ipos, short len, char type, boolean unique) throws IOException {
        this.mfile = ifile;
        this.nfile = ifile.getRandomAccessFile();
        this.setPos(ipos);
        this.resrvd3 = (byte)27;
        this.flags = (byte)(this.flags | 8);
        this.flags = (byte)(this.flags | (byte)(unique ? 2 : 0));
        this.changes = (short)2;
        this.unique_key = 1;
        this.keyType = (byte)type;
        this.key_entry_size = (short)(len + 4);
        this.key_length = len;
        this.key_per_Node = (short)(this.mfile.getAnchor().get_blockbytes() - 16);
        this.key_per_Node = (short)(this.key_per_Node / this.key_entry_size);
        this.unknown[1] = 65536;
        this.unknown[2] = this.mfile.getAnchor().get_nextavailable();
        ifile.getAnchor().update_nextavailable();
        this.unknown[3] = this.top_Node;
        this.write();
    }

    public void reset(RandomAccessFile ifile) {
        this.nfile = ifile;
    }

    public void setPos(short ipos) {
        this.pos = ipos;
        this.pos *= 512L;
    }

    public void read() throws IOException {
        int i;
        this.nfile.seek(this.pos);
        this.top_Node = this.nfile.readInt();
        this.pagesused = this.nfile.readInt();
        this.flags = this.nfile.readByte();
        this.keyType = this.nfile.readByte();
        this.sql = this.nfile.readByte();
        this.resrvd3 = this.nfile.readByte();
        this.key_length = this.nfile.readShort();
        this.key_per_Node = this.nfile.readShort();
        this.notused = this.nfile.readShort();
        this.key_entry_size = this.nfile.readShort();
        this.changes = this.nfile.readShort();
        this.resrvd4 = this.nfile.readByte();
        this.unique_key = this.nfile.readByte();
        this.nfile.read(this.key_definition, 0, 101);
        this.nfile.read(this.for_expression, 0, 101);
        this.nfile.read(this.resrvd5, 0, 14);
        this.unknown[0] = this.nfile.readInt();
        this.unknown[1] = this.nfile.readInt();
        this.unknown[2] = this.nfile.readInt();
        this.unknown[3] = this.nfile.readInt();
        this.redo_numbers();
        for (i = 0; i < 101 && this.key_definition[i] != 0; ++i) {
        }
        try {
            this.NDXString = new String(this.key_definition, 0, i, DBF.encodedType);
        }
        catch (UnsupportedEncodingException UEE) {
            this.NDXString = new String(this.key_definition, 0, i);
        }
    }

    void write() throws IOException {
        this.unknown[3] = this.top_Node;
        this.redo_numbers();
        this.nfile.seek(this.pos);
        this.nfile.writeInt(this.top_Node);
        this.nfile.writeInt(this.pagesused);
        this.nfile.writeByte(this.flags);
        this.nfile.writeByte(this.keyType);
        this.nfile.writeByte(this.sql);
        this.nfile.writeByte(this.resrvd3);
        this.nfile.writeShort(this.key_length);
        this.nfile.writeShort(this.key_per_Node);
        this.nfile.writeShort(this.notused);
        this.nfile.writeShort(this.key_entry_size);
        this.nfile.writeShort(this.changes);
        this.nfile.writeByte(this.resrvd4);
        this.nfile.writeByte(this.unique_key);
        this.nfile.write(this.key_definition, 0, 101);
        this.nfile.write(this.for_expression, 0, 101);
        this.nfile.write(this.resrvd5, 0, 14);
        this.nfile.writeInt(this.unknown[0]);
        this.nfile.writeInt(this.unknown[1]);
        this.nfile.writeInt(this.unknown[2]);
        this.nfile.writeInt(this.unknown[3]);
        this.redo_numbers();
    }

    void redo_numbers() {
        this.top_Node = DbaseUtils.x86(this.top_Node);
        this.pagesused = DbaseUtils.x86(this.pagesused);
        this.key_length = DbaseUtils.x86(this.key_length);
        this.key_per_Node = DbaseUtils.x86(this.key_per_Node);
        this.notused = DbaseUtils.x86(this.notused);
        this.key_entry_size = DbaseUtils.x86(this.key_entry_size);
        this.changes = DbaseUtils.x86(this.changes);
        this.unknown[0] = DbaseUtils.x86(this.unknown[0]);
        this.unknown[1] = DbaseUtils.x86(this.unknown[1]);
        this.unknown[2] = DbaseUtils.x86(this.unknown[2]);
        this.unknown[3] = DbaseUtils.x86(this.unknown[3]);
    }
}

