/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.sas.metamodel;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.TableType;
import org.eobjects.metamodel.sas.SasReader;
import org.eobjects.metamodel.sas.metamodel.ColumnBuildingSasCallback;

final class SasTable
extends MutableTable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final File _file;
    private final List<Column> _columns;
    private boolean _columnsLoaded;

    public SasTable(File file, Schema schema) {
        super(SasTable.createName(file), TableType.TABLE, schema);
        this._file = file;
        this._columns = new ArrayList<Column>();
        this._columnsLoaded = false;
    }

    private static String createName(File file) {
        String name = file.getName();
        if (name.endsWith(".sas7bdat")) {
            name = name.substring(0, name.length() - 9);
        }
        return name;
    }

    public File getFile() {
        return this._file;
    }

    protected List<Column> getColumnsInternal() {
        if (!this._columnsLoaded) {
            this._columnsLoaded = true;
            SasReader sasReader = new SasReader(this._file);
            sasReader.read(new ColumnBuildingSasCallback((Table)this, this._columns));
        }
        return this._columns;
    }
}

