/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.sas.metamodel;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.QueryPostprocessDataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.RowPublisherDataSet;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.Action;
import org.eobjects.metamodel.sas.CountReaderCallback;
import org.eobjects.metamodel.sas.SasFilenameFilter;
import org.eobjects.metamodel.sas.SasReader;
import org.eobjects.metamodel.sas.metamodel.SasRowPublisherAction;
import org.eobjects.metamodel.sas.metamodel.SasTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SasDataContext
extends QueryPostprocessDataContext {
    private static final Logger logger = LoggerFactory.getLogger(SasDataContext.class);
    private final File _directory;

    public SasDataContext(String directoryPath) {
        this(new File(directoryPath));
    }

    public SasDataContext(File directory) {
        if (directory == null) {
            throw new IllegalArgumentException("Directory cannot be null");
        }
        if (!directory.exists()) {
            throw new IllegalArgumentException("Directory does not exist");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory + " is not a directory");
        }
        this._directory = directory;
    }

    protected Schema getMainSchema() throws MetaModelException {
        MutableSchema schema = new MutableSchema(this.getMainSchemaName());
        Object[] tableFiles = this._directory.listFiles(new SasFilenameFilter());
        if (tableFiles.length == 0) {
            logger.warn("Directory did not contain any SAS tables: {}", (Object)this._directory);
        }
        Arrays.sort(tableFiles);
        for (Object file : tableFiles) {
            SasTable table = new SasTable((File)file, (Schema)schema);
            schema.addTable((MutableTable)table);
        }
        return schema;
    }

    protected String getMainSchemaName() throws MetaModelException {
        return this._directory.getName();
    }

    protected Number executeCountQuery(Table table, List<FilterItem> whereItems, boolean functionApproximationAllowed) {
        if (whereItems.isEmpty()) {
            SasTable sasTable = (SasTable)table;
            File file = sasTable.getFile();
            SasReader sasReader = new SasReader(file);
            CountReaderCallback callback = new CountReaderCallback();
            sasReader.read(callback);
            int count = callback.getCount();
            return count;
        }
        return super.executeCountQuery(table, whereItems, functionApproximationAllowed);
    }

    protected DataSet materializeMainSchemaTable(Table table, Column[] columns, int maxRows) {
        SasTable sasTable = (SasTable)table;
        File file = sasTable.getFile();
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>(columns.length);
        for (int i = 0; i < columns.length; ++i) {
            selectItems.add(new SelectItem(columns[i]));
        }
        SasReader sasReader = new SasReader(file);
        return new RowPublisherDataSet(selectItems.toArray(new SelectItem[selectItems.size()]), maxRows, (Action)new SasRowPublisherAction(sasReader, columns, maxRows));
    }
}

