/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.sas;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eobjects.metamodel.sas.IO;
import org.eobjects.metamodel.sas.SasColumnType;
import org.eobjects.metamodel.sas.SasHeader;
import org.eobjects.metamodel.sas.SasReaderCallback;
import org.eobjects.metamodel.sas.SasReaderException;
import org.eobjects.metamodel.sas.SasSubHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SasReader {
    private static final Logger logger = LoggerFactory.getLogger(SasReader.class);
    private static final byte[] SUBH_ROWSIZE = IO.toBytes(247, 247, 247, 247);
    private static final byte[] SUBH_COLSIZE = IO.toBytes(246, 246, 246, 246);
    private static final byte[] SUBH_COLTEXT = IO.toBytes(253, 255, 255, 255);
    private static final byte[] SUBH_COLATTR = IO.toBytes(252, 255, 255, 255);
    private static final byte[] SUBH_COLNAME = IO.toBytes(255, 255, 255, 255);
    private static final byte[] SUBH_COLLABS = IO.toBytes(254, 251, 255, 255);
    private static final byte[] MAGIC = IO.toBytes(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 194, 234, 129, 96, 179, 20, 17, 207, 189, 146, 8, 0, 9, 199, 49, 140, 24, 31, 16, 17);
    private final File _file;

    public SasReader(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null");
        }
        this._file = file;
    }

    public File getFile() {
        return this._file;
    }

    protected static boolean isMagicNumber(int[] data) {
        return SasReader.isMagicNumber(IO.toBytes(data));
    }

    protected static boolean isMagicNumber(byte[] data) {
        return SasReader.isIdentical(data, MAGIC);
    }

    private static boolean isIdentical(byte[] data, byte[] expected) {
        if (data == null) {
            return false;
        }
        byte[] comparedBytes = data.length > expected.length ? Arrays.copyOf(data, expected.length) : data;
        return Arrays.equals(expected, comparedBytes);
    }

    public void read(SasReaderCallback callback) throws SasReaderException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(this._file);
            SasHeader header = this.readHeader(is);
            logger.info("({}) Header: {}", (Object)this._file, (Object)header);
            logger.debug("Header: {}", (Object)header.toString());
            this.readPages(is, header, callback);
            logger.info("({}) Done!", (Object)this._file);
        }
        catch (Exception e) {
            if (e instanceof SasReaderException) {
                throw (SasReaderException)e;
            }
            throw new SasReaderException("Unhandled exception occurred while reading sas7bdat file!", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void readPages(FileInputStream is, SasHeader header, SasReaderCallback callback) throws Exception {
        ArrayList<SasSubHeader> subHeaders = new ArrayList<SasSubHeader>();
        ArrayList<Integer> columnOffsets = new ArrayList<Integer>();
        ArrayList<Integer> columnLengths = new ArrayList<Integer>();
        ArrayList<SasColumnType> columnTypes = new ArrayList<SasColumnType>();
        boolean subHeadersParsed = false;
        int rowCount = 0;
        int pageSize = header.getPageSize();
        int pageCount = header.getPageCount();
        int row_count = -1;
        int row_count_fp = -1;
        int row_length = -1;
        int col_count = -1;
        for (int pageNumber = 0; pageNumber < pageCount; ++pageNumber) {
            int base;
            int row_count_p;
            logger.info("({}) Reading page no. {}", (Object)this._file, (Object)pageNumber);
            byte[] pageData = new byte[pageSize];
            int read = is.read(pageData);
            if (read == -1) break;
            byte pageType = IO.readByte(pageData, 17);
            switch (pageType) {
                case 0: 
                case 1: 
                case 2: {
                    logger.info("({}) page type supported: {}", (Object)this._file, (Object)pageType);
                    break;
                }
                case 4: {
                    logger.info("({}) page type not fully supported: {}", (Object)this._file, (Object)pageType);
                    break;
                }
                default: {
                    throw new SasReaderException("Page " + pageNumber + " has unknown type: " + pageType);
                }
            }
            if (pageType == 0 || pageType == 2) {
                int subhCount = IO.readInt(pageData, 20);
                for (int subHeaderNumber = 0; subHeaderNumber < subhCount; ++subHeaderNumber) {
                    int base2 = 24 + subHeaderNumber * 12;
                    int offset = IO.readInt(pageData, base2);
                    int length = IO.readInt(pageData, base2 + 4);
                    if (length <= 0) continue;
                    byte[] rawData = IO.readBytes(pageData, offset, length);
                    byte[] signatureData = IO.readBytes(rawData, 0, 4);
                    SasSubHeader subHeader = new SasSubHeader(rawData, signatureData);
                    subHeaders.add(subHeader);
                }
            }
            if (pageType != 1 && pageType != 2) continue;
            if (!subHeadersParsed) {
                int col_count_6;
                SasSubHeader rowSize = this.getSubHeader(subHeaders, SUBH_ROWSIZE, "ROWSIZE");
                row_length = IO.readInt(rowSize.getRawData(), 20);
                row_count = IO.readInt(rowSize.getRawData(), 24);
                int col_count_7 = IO.readInt(rowSize.getRawData(), 36);
                row_count_fp = IO.readInt(rowSize.getRawData(), 60);
                SasSubHeader colSize = this.getSubHeader(subHeaders, SUBH_COLSIZE, "COLSIZE");
                col_count = col_count_6 = IO.readInt(colSize.getRawData(), 4);
                if (col_count_7 != col_count_6) {
                    logger.warn("({}) Column count mismatch: {} vs. {}", new Object[]{this._file, col_count_6, col_count_7});
                }
                SasSubHeader colText = this.getSubHeader(subHeaders, SUBH_COLTEXT, "COLTEXT");
                List<SasSubHeader> colAttrHeaders = this.getSubHeaders(subHeaders, SUBH_COLATTR, "COLATTR");
                if (colAttrHeaders.isEmpty()) {
                    throw new SasReaderException("No column attribute subheader found");
                }
                SasSubHeader colAttr = colAttrHeaders.size() == 1 ? colAttrHeaders.get(0) : this.spliceColAttrSubHeaders(colAttrHeaders);
                SasSubHeader colName = this.getSubHeader(subHeaders, SUBH_COLNAME, "COLNAME");
                List<SasSubHeader> colLabels = this.getSubHeaders(subHeaders, SUBH_COLLABS, "COLLABS");
                if (!colLabels.isEmpty() && colLabels.size() != col_count) {
                    throw new SasReaderException("Unexpected column label count (" + colLabels.size() + ") expected 0 or " + col_count);
                }
                for (int i = 0; i < col_count; ++i) {
                    String label;
                    String columnName;
                    int base3 = 12 + i * 8;
                    byte amd = IO.readByte(colName.getRawData(), base3);
                    if (amd == 0) {
                        int off = IO.readShort(colName.getRawData(), base3 + 2) + 4;
                        short len = IO.readShort(colName.getRawData(), base3 + 4);
                        columnName = IO.readString(colText.getRawData(), off, len);
                    } else {
                        columnName = "COL" + i;
                    }
                    if (colLabels != null && !colLabels.isEmpty()) {
                        base3 = 42;
                        byte[] rawData = colLabels.get(i).getRawData();
                        int off = IO.readShort(rawData, base3) + 4;
                        short len = IO.readShort(rawData, base3 + 2);
                        label = len > 0 ? IO.readString(colText.getRawData(), off, len) : null;
                    } else {
                        label = null;
                    }
                    base3 = 12 + i * 12;
                    int offset = IO.readInt(colAttr.getRawData(), base3);
                    columnOffsets.add(offset);
                    int length = IO.readInt(colAttr.getRawData(), base3 + 4);
                    columnLengths.add(length);
                    short columnTypeCode = IO.readShort(colAttr.getRawData(), base3 + 10);
                    SasColumnType columnType = columnTypeCode == 1 ? SasColumnType.NUMERIC : SasColumnType.CHARACTER;
                    columnTypes.add(columnType);
                    if (logger.isDebugEnabled()) {
                        logger.debug("({}) column no. {} read: name={},label={},type={},length={}", new Object[]{this._file, i, columnName, label, columnType, length});
                    }
                    callback.column(i, columnName, label, columnType, length);
                }
                subHeadersParsed = true;
            }
            if (!callback.readData()) {
                logger.info("({}) Callback decided to not read data", (Object)this._file);
                return;
            }
            if (pageType == 2) {
                row_count_p = row_count_fp;
                base = 24 + subHeaders.size() * 12 + 12;
                base += base % 8;
            } else {
                row_count_p = IO.readInt(pageData, 18);
                base = 24;
            }
            if (row_count_p > row_count) {
                row_count_p = row_count;
            }
            for (int row = 0; row < row_count_p; ++row) {
                boolean next;
                Object[] rowData = new Object[col_count];
                for (int col = 0; col < col_count; ++col) {
                    Object value;
                    int off = base + (Integer)columnOffsets.get(col);
                    int len = (Integer)columnLengths.get(col);
                    SasColumnType columnType = (SasColumnType)((Object)columnTypes.get(col));
                    if (len <= 0) continue;
                    byte[] raw = IO.readBytes(pageData, off, len);
                    if (columnType == SasColumnType.NUMERIC && len < 8) {
                        ByteBuffer bb = ByteBuffer.allocate(8);
                        for (int j = 0; j < 8 - len; ++j) {
                            bb.put((byte)0);
                        }
                        bb.put(raw);
                        raw = bb.array();
                        len = 8;
                    }
                    if (columnType == SasColumnType.CHARACTER) {
                        String str = IO.readString(raw, 0, len);
                        str = str.trim();
                        value = str;
                    } else {
                        value = IO.readNumber(raw, 0, len);
                    }
                    rowData[col] = value;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("({}) row no. {} read: {}", new Object[]{this._file, row, rowData});
                }
                if (!(next = callback.row(++rowCount, rowData))) {
                    logger.info("({}) Callback decided to stop iteration", (Object)this._file);
                    return;
                }
                base += row_length;
            }
        }
    }

    private SasSubHeader spliceColAttrSubHeaders(List<SasSubHeader> colAttrHeaders) {
        int colAttrHeadersSize = colAttrHeaders.size();
        logger.info("({}) Splicing {} column attribute headers", (Object)this._file, (Object)colAttrHeadersSize);
        byte[] result = IO.readBytes(colAttrHeaders.get(0).getRawData(), 0, colAttrHeaders.get(0).getRawData().length - 8);
        for (int i = 1; i < colAttrHeadersSize; ++i) {
            byte[] rawData = colAttrHeaders.get(i).getRawData();
            result = IO.concat(result, IO.readBytes(rawData, 12, rawData.length - 20));
        }
        return new SasSubHeader(result, null);
    }

    private List<SasSubHeader> getSubHeaders(List<SasSubHeader> subHeaders, byte[] signature, String name) {
        ArrayList<SasSubHeader> result = new ArrayList<SasSubHeader>();
        for (SasSubHeader subHeader : subHeaders) {
            byte[] signatureData = subHeader.getSignatureData();
            if (!SasReader.isIdentical(signatureData, signature)) continue;
            result.add(subHeader);
        }
        return result;
    }

    private SasSubHeader getSubHeader(List<SasSubHeader> subHeaders, byte[] signature, String name) {
        List<SasSubHeader> result = this.getSubHeaders(subHeaders, signature, name);
        if (result.isEmpty()) {
            throw new SasReaderException("Could not find sub header: " + name);
        }
        if (result.size() != 1) {
            throw new SasReaderException("Multiple (" + result.size() + ") instances of the same sub header: " + name);
        }
        return result.get(0);
    }

    private SasHeader readHeader(InputStream is) throws Exception {
        byte[] header = new byte[1024];
        int read = is.read(header);
        if (read != 1024) {
            throw new SasReaderException("Header too short (not a sas7bdat file?): " + read);
        }
        if (!SasReader.isMagicNumber(header)) {
            throw new SasReaderException("Magic number mismatch!");
        }
        byte byte32 = IO.readByte(header, 32);
        byte byte35 = IO.readByte(header, 35);
        byte byte37 = IO.readByte(header, 37);
        int a2 = byte32 == 51 ? 4 : 0;
        int a1 = byte35 == 51 ? 4 : 0;
        boolean bigEndian = byte37 == 0;
        boolean u64 = a2 == 4;
        logger.debug("Endianness: {}", (Object)(bigEndian ? "big" : "little"));
        logger.debug("U64? {}", (Object)String.valueOf(u64));
        logger.debug("a1={}, a2={}", (Object)a1, (Object)a2);
        int pageSize = IO.readInt(header, 200 + a1);
        if (pageSize < 0) {
            throw new SasReaderException("Page size is negative: " + pageSize);
        }
        int pageCount = IO.readInt(header, 204 + a1);
        if (pageCount < 1) {
            throw new SasReaderException("Page count is not positive: " + pageCount);
        }
        logger.info("({}) page size={}, page count={}", new Object[]{this._file, pageSize, pageCount});
        String sasRelease = IO.readString(header, 216, 8);
        String sasHost = IO.readString(header, 224, 8);
        return new SasHeader(sasRelease, sasHost, pageSize, pageCount);
    }
}

