/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.excel;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.QueryPostprocessDataContext;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.UpdateScript;
import org.apache.metamodel.UpdateSummary;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.excel.DefaultSpreadsheetReaderDelegate;
import org.apache.metamodel.excel.ExcelConfiguration;
import org.apache.metamodel.excel.ExcelUpdateCallback;
import org.apache.metamodel.excel.SpreadsheetReaderDelegate;
import org.apache.metamodel.excel.XlsxSpreadsheetReaderDelegate;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.FileResource;
import org.apache.metamodel.util.Resource;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExcelDataContext
extends QueryPostprocessDataContext
implements UpdateableDataContext {
    private static final Logger logger = LoggerFactory.getLogger(ExcelDataContext.class);
    private final Object WRITE_LOCK = new Object();
    private final Resource _resource;
    private final ExcelConfiguration _configuration;
    private SpreadsheetReaderDelegate _spreadsheetReaderDelegate;

    public ExcelDataContext(File file) {
        this(file, new ExcelConfiguration());
    }

    public ExcelDataContext(File file, ExcelConfiguration configuration) {
        super(true);
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("ExcelConfiguration cannot be null");
        }
        if (file.exists() && !file.canRead()) {
            throw new IllegalArgumentException("Cannot read from file");
        }
        this._resource = new FileResource(file);
        this._configuration = configuration;
    }

    public ExcelDataContext(Resource resource, ExcelConfiguration configuration) {
        super(true);
        if (resource == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("ExcelConfiguration cannot be null");
        }
        this._resource = resource;
        this._configuration = configuration;
    }

    public ExcelConfiguration getConfiguration() {
        return this._configuration;
    }

    public Resource getResource() {
        return this._resource;
    }

    protected String getMainSchemaName() throws MetaModelException {
        return this._resource.getName();
    }

    public DataSet materializeMainSchemaTable(Table table, List<Column> columns, int maxRows) {
        try {
            SpreadsheetReaderDelegate delegate = this.getSpreadsheetReaderDelegate();
            this.getDefaultSchema();
            DataSet dataSet = delegate.executeQuery(table, columns, maxRows);
            return dataSet;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new MetaModelException("Unexpected exception while materializing main schema table", e);
        }
    }

    protected Schema getMainSchema() throws MetaModelException {
        if (!this._resource.isExists()) {
            logger.info("Resource does not exist, returning empty schema");
            return new MutableSchema(this.getMainSchemaName());
        }
        try {
            SpreadsheetReaderDelegate delegate = this.getSpreadsheetReaderDelegate();
            Schema schema = delegate.createSchema(this.getMainSchemaName());
            assert (this.getMainSchemaName().equals(schema.getName()));
            return schema;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new MetaModelException("Unexpected exception while building main schema", e);
        }
    }

    protected void onSchemaCacheRefreshed() {
        super.onSchemaCacheRefreshed();
        this._spreadsheetReaderDelegate = null;
    }

    protected Class<? extends SpreadsheetReaderDelegate> getSpreadsheetReaderDelegateClass() {
        if (this._spreadsheetReaderDelegate != null) {
            return this._spreadsheetReaderDelegate.getClass();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpreadsheetReaderDelegate getSpreadsheetReaderDelegate() throws MetaModelException {
        if (this._spreadsheetReaderDelegate == null) {
            ExcelDataContext excelDataContext = this;
            synchronized (excelDataContext) {
                if (this._spreadsheetReaderDelegate == null) {
                    this._spreadsheetReaderDelegate = (SpreadsheetReaderDelegate)this._resource.read(in -> {
                        try {
                            if (FileMagic.valueOf((InputStream)in) == FileMagic.OOXML && !this._configuration.isDetectColumnTypes()) {
                                return new XlsxSpreadsheetReaderDelegate(this._resource, this._configuration);
                            }
                            return new DefaultSpreadsheetReaderDelegate(this._resource, this._configuration);
                        }
                        catch (IOException e) {
                            logger.warn("Could not identify spreadsheet type, using default", (Throwable)e);
                            return new DefaultSpreadsheetReaderDelegate(this._resource, this._configuration);
                        }
                    });
                }
            }
        }
        return this._spreadsheetReaderDelegate;
    }

    protected void notifyTablesModified() {
        this.getSpreadsheetReaderDelegate().notifyTablesModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateSummary executeUpdate(UpdateScript update) {
        ExcelUpdateCallback updateCallback = new ExcelUpdateCallback(this);
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            try {
                update.run((UpdateCallback)updateCallback);
            }
            finally {
                updateCallback.close();
            }
        }
        return updateCallback.getUpdateSummary();
    }
}

