/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.excel;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.RowPublisherDataSet;
import org.apache.metamodel.data.Style;
import org.apache.metamodel.excel.ExcelConfiguration;
import org.apache.metamodel.excel.ExcelUtils;
import org.apache.metamodel.excel.SpreadsheetReaderDelegate;
import org.apache.metamodel.excel.XlsxRowCallback;
import org.apache.metamodel.excel.XlsxRowPublisherAction;
import org.apache.metamodel.excel.XlsxSheetToRowsHandler;
import org.apache.metamodel.excel.XlsxStopParsingException;
import org.apache.metamodel.excel.XlsxWorkbookToTablesHandler;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.naming.ColumnNamingContext;
import org.apache.metamodel.schema.naming.ColumnNamingContextImpl;
import org.apache.metamodel.schema.naming.ColumnNamingSession;
import org.apache.metamodel.schema.naming.ColumnNamingStrategy;
import org.apache.metamodel.util.Action;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.FileResource;
import org.apache.metamodel.util.Resource;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

final class XlsxSpreadsheetReaderDelegate
implements SpreadsheetReaderDelegate {
    private static final Logger logger = LoggerFactory.getLogger(XlsxSpreadsheetReaderDelegate.class);
    private final Resource _resource;
    private final ExcelConfiguration _configuration;
    private final Map<String, String> _tableNamesToInternalIds;

    public XlsxSpreadsheetReaderDelegate(Resource resource, ExcelConfiguration configuration) {
        this._resource = resource;
        this._configuration = configuration;
        this._tableNamesToInternalIds = new ConcurrentHashMap<String, String>();
    }

    @Override
    public DataSet executeQuery(Table table, List<Column> columns, int maxRows) throws Exception {
        OPCPackage pkg = this.openOPCPackage();
        XSSFReader xssfReader = new XSSFReader(pkg);
        String relationshipId = this._tableNamesToInternalIds.get(table.getName());
        if (relationshipId == null) {
            throw new IllegalStateException("No internal relationshipId found for table: " + table);
        }
        return this.buildDataSet(columns, maxRows, relationshipId, xssfReader, pkg);
    }

    private OPCPackage openOPCPackage() throws Exception {
        if (this._resource instanceof FileResource) {
            File file = ((FileResource)this._resource).getFile();
            return OPCPackage.open((File)file);
        }
        return OPCPackage.open((InputStream)this._resource.read());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema createSchema(String schemaName) throws Exception {
        MutableSchema schema = new MutableSchema(schemaName);
        OPCPackage pkg = this.openOPCPackage();
        try {
            XSSFReader xssfReader = new XSSFReader(pkg);
            XlsxWorkbookToTablesHandler workbookToTables = new XlsxWorkbookToTablesHandler(schema, this._tableNamesToInternalIds);
            this.buildTables(xssfReader, workbookToTables);
            for (Map.Entry<String, String> entry : this._tableNamesToInternalIds.entrySet()) {
                String tableName = entry.getKey();
                String relationshipId = entry.getValue();
                MutableTable table = (MutableTable)schema.getTableByName(tableName);
                this.buildColumns(table, relationshipId, xssfReader);
            }
        }
        finally {
            pkg.revert();
        }
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyTablesModified() {
        XlsxWorkbookToTablesHandler workbookToTables = new XlsxWorkbookToTablesHandler(null, this._tableNamesToInternalIds);
        try {
            OPCPackage pkg = this.openOPCPackage();
            try {
                XSSFReader xssfReader = new XSSFReader(pkg);
                this.buildTables(xssfReader, workbookToTables);
            }
            finally {
                pkg.revert();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private DataSet buildDataSet(List<Column> columns, int maxRows, String relationshipId, XSSFReader xssfReader, final OPCPackage pkg) throws Exception {
        List<SelectItem> selectItems = columns.stream().map(SelectItem::new).collect(Collectors.toList());
        XlsxRowPublisherAction publishAction = new XlsxRowPublisherAction(this._configuration, columns, relationshipId, xssfReader);
        return new RowPublisherDataSet(selectItems.toArray(new SelectItem[selectItems.size()]), maxRows, (Action)publishAction, new Closeable[]{new Closeable(){

            @Override
            public void close() throws IOException {
                pkg.revert();
            }
        }});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildColumns(final MutableTable table, String relationshipId, XSSFReader xssfReader) throws Exception {
        InputStream sheetData = xssfReader.getSheet(relationshipId);
        XlsxRowCallback rowCallback = new XlsxRowCallback(){

            @Override
            public boolean row(int rowNumber, List<String> values, List<Style> styles) {
                int zeroBasedLineNumber;
                boolean hasColumnNameLine;
                int columnNameLineNumber = XlsxSpreadsheetReaderDelegate.this._configuration.getColumnNameLineNumber();
                boolean bl = hasColumnNameLine = columnNameLineNumber != 0;
                if (hasColumnNameLine && rowNumber < (zeroBasedLineNumber = columnNameLineNumber - 1)) {
                    return true;
                }
                ColumnNamingStrategy columnNamingStrategy = XlsxSpreadsheetReaderDelegate.this._configuration.getColumnNamingStrategy();
                try (ColumnNamingSession session = columnNamingStrategy.startColumnNamingSession();){
                    for (int i = 0; i < values.size(); ++i) {
                        String intrinsicColumnName = hasColumnNameLine ? values.get(i) : null;
                        String columnName = session.getNextColumnName((ColumnNamingContext)new ColumnNamingContextImpl((Table)table, intrinsicColumnName, i));
                        if (XlsxSpreadsheetReaderDelegate.this._configuration.isSkipEmptyColumns() && values.get(i) == null) continue;
                        table.addColumn((Column)new MutableColumn(columnName, ColumnType.STRING, (Table)table, i, Boolean.valueOf(true)));
                    }
                }
                return false;
            }
        };
        XlsxSheetToRowsHandler handler = new XlsxSheetToRowsHandler(rowCallback, xssfReader, this._configuration);
        XMLReader sheetParser = ExcelUtils.createXmlReader();
        sheetParser.setContentHandler(handler);
        try {
            sheetParser.parse(new InputSource(sheetData));
        }
        catch (XlsxStopParsingException e) {
            try {
                logger.debug("Parsing stop signal thrown");
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{sheetData});
                throw throwable;
            }
            FileHelper.safeClose((Object[])new Object[]{sheetData});
        }
        FileHelper.safeClose((Object[])new Object[]{sheetData});
    }

    private void buildTables(XSSFReader xssfReader, XlsxWorkbookToTablesHandler workbookToTables) throws Exception {
        InputStream workbookData = xssfReader.getWorkbookData();
        XMLReader workbookParser = ExcelUtils.createXmlReader();
        workbookParser.setContentHandler(workbookToTables);
        workbookParser.parse(new InputSource(workbookData));
        FileHelper.safeClose((Object[])new Object[]{workbookData});
    }
}

