/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.maven;

import com.jcabi.log.Logger;
import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.cactoos.Output;
import org.cactoos.io.OutputTo;
import org.cactoos.list.ListOf;
import org.eolang.maven.Save;
import org.eolang.maven.TargetSpy;
import org.eolang.parser.Spy;
import org.eolang.parser.Xsline;
import org.slf4j.impl.StaticLoggerBinder;

@Mojo(name="optimize", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public final class OptimizeMojo
extends AbstractMojo {
    @Parameter(required=true, defaultValue="${project.build.directory}/eo")
    private File targetDir;

    public void execute() throws MojoFailureException {
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        Path dir = this.targetDir.toPath().resolve("01-parse");
        try {
            Files.walk(dir, new FileVisitOption[0]).filter(file -> !file.toFile().isDirectory()).forEach(file -> this.optimize(dir, (Path)file));
        }
        catch (IOException ex) {
            throw new MojoFailureException(String.format("Can't list XML files in %s", dir), (Throwable)ex);
        }
    }

    private void optimize(Path home, Path file) {
        String name = file.toString().substring(home.toString().length() + 1);
        Path dir = this.targetDir.toPath().resolve("02-steps").resolve(name);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new Xsline((XML)new XMLDocument(file), (Output)new OutputTo((OutputStream)baos), (Spy)new TargetSpy(dir)).with((Iterable)new ListOf((Object[])new String[]{"org/eolang/parser/optimize/globals-to-abstracts.xsl", "org/eolang/parser/optimize/remove-refs.xsl", "org/eolang/parser/optimize/abstracts-float-up.xsl", "org/eolang/parser/optimize/remove-levels.xsl", "org/eolang/parser/add-refs.xsl", "org/eolang/parser/optimize/fix-missed-names.xsl", "org/eolang/parser/errors/broken-refs.xsl"})).pass();
            Path target = this.targetDir.toPath().resolve("03-optimize").resolve(name);
            new Save(baos.toString(), target).save();
            Logger.info((Object)((Object)this), (String)"%s optimized to %s, all steps are in %s", (Object[])new Object[]{file, target, dir});
            Logger.debug((Object)((Object)this), (String)"Optimized XML saved to %s:\n%s", (Object[])new Object[]{target, baos.toString()});
        }
        catch (IOException ex) {
            throw new IllegalStateException(String.format("Can't pass %s into %s", file, this.targetDir), ex);
        }
    }
}

