/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.maven;

import com.jcabi.log.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.cactoos.Input;
import org.cactoos.Output;
import org.cactoos.io.InputOf;
import org.cactoos.io.OutputTo;
import org.cactoos.set.SetOf;
import org.eolang.maven.Save;
import org.eolang.parser.Syntax;
import org.slf4j.impl.StaticLoggerBinder;

@Mojo(name="parse", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public final class ParseMojo
extends AbstractMojo {
    @Parameter(required=true, defaultValue="${project.build.directory}/eo")
    private File targetDir;
    @Parameter(required=true, defaultValue="${project.basedir}/src/main/eo")
    private File sourcesDir;
    @Parameter
    private Set<String> includes = new SetOf((Object[])new String[]{"**/*.eo"});
    @Parameter
    private Set<String> excludes = new HashSet<String>(0);

    public void execute() throws MojoFailureException {
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        try {
            Files.walk(this.sourcesDir.toPath(), new FileVisitOption[0]).filter(file -> !file.toFile().isDirectory()).filter(file -> this.includes.stream().anyMatch(glob -> ParseMojo.matcher(glob).matches((Path)file))).filter(file -> this.excludes.stream().noneMatch(glob -> ParseMojo.matcher(glob).matches((Path)file))).forEach(this::parse);
        }
        catch (IOException ex) {
            throw new MojoFailureException(String.format("Can't list EO files in %s", this.sourcesDir), (Throwable)ex);
        }
    }

    private static PathMatcher matcher(String text) {
        return FileSystems.getDefault().getPathMatcher(String.format("glob:%s", text));
    }

    private void parse(Path file) {
        String name = file.toString().substring(this.sourcesDir.toString().length() + 1);
        String xml = String.format("%s.xml", name);
        Path path = this.targetDir.toPath().resolve("01-parse").resolve(xml);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new Syntax(name, (Input)new InputOf(file), (Output)new OutputTo((OutputStream)baos)).parse();
            new Save(baos.toString(), path).save();
        }
        catch (IOException ex) {
            throw new IllegalStateException(String.format("Can't parse %s into %s", file, this.targetDir), ex);
        }
        Logger.info((Object)((Object)this), (String)"%s parsed to %s", (Object[])new Object[]{file, path});
    }
}

