/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.maven;

import com.jcabi.log.Logger;
import com.jcabi.xml.XMLDocument;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.cactoos.Func;
import org.cactoos.Input;
import org.cactoos.func.IoCheckedFunc;
import org.cactoos.io.InputOf;
import org.eolang.maven.Save;
import org.slf4j.impl.StaticLoggerBinder;

@Mojo(name="pull", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public final class PullMojo
extends AbstractMojo {
    @Parameter(required=true, defaultValue="${project.build.directory}/eo")
    private File targetDir;
    private Func<String, Input> repo = name -> new InputOf(new URL(String.format("https://www.objectionary.com/xml/%s.eo.xml", name.replace(".", "/"))));

    public void execute() throws MojoFailureException {
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        Path dir = this.targetDir.toPath().resolve("03-optimize");
        try {
            Files.walk(dir, new FileVisitOption[0]).filter(file -> !file.toFile().isDirectory()).forEach(file -> this.pull(dir, (Path)file));
        }
        catch (IOException ex) {
            throw new MojoFailureException(String.format("Can't list XML files in %s", dir), (Throwable)ex);
        }
    }

    private void pull(Path dir, Path file) {
        try {
            String xpath = String.join((CharSequence)"", "//o[@base and contains(@base, '.') ", "and not(starts-with(@base, '.'))]/@base");
            for (String name : new XMLDocument(file).xpath(xpath)) {
                this.pull(dir, name);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(String.format("Can't pull %s into %s", file, this.targetDir), ex);
        }
    }

    private void pull(Path dir, String name) throws IOException {
        Path path = dir.resolve(String.format("%s.eo.xml", name.replace(".", "/")));
        if (path.toFile().exists()) {
            Logger.debug((Object)((Object)this), (String)"The file %s already exists", (Object[])new Object[]{path});
        } else {
            new Save((Input)new IoCheckedFunc(this.repo).apply((Object)name), path).save();
        }
    }
}

