/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.maven;

import com.jcabi.log.Logger;
import com.jcabi.xml.XMLDocument;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.slf4j.impl.StaticLoggerBinder;

@Mojo(name="resolve", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public final class ResolveMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Parameter(required=true, defaultValue="${project.build.directory}/eo")
    private File targetDir;
    @Parameter
    private boolean addToScope = true;

    public void execute() throws MojoFailureException {
        Collection deps;
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        Path dir = this.targetDir.toPath().resolve("03-optimize");
        try {
            deps = Files.walk(dir, new FileVisitOption[0]).filter(file -> !file.toFile().isDirectory()).map(this::artifacts).flatMap(Collection::stream).map(x$0 -> new Wrap((Dependency)x$0)).sorted().distinct().map(Wrap::dep).collect(Collectors.toList());
        }
        catch (IOException ex) {
            throw new MojoFailureException(String.format("Can't list XML files in %s", dir), (Throwable)ex);
        }
        for (Dependency dep : deps) {
            if (this.addToScope) {
                this.project.getDependencies().add(dep);
                Logger.info((Object)((Object)this), (String)"%s:%s:%s added to \"%s\" scope", (Object[])new Object[]{dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getScope()});
                continue;
            }
            Logger.info((Object)((Object)this), (String)"%s:%s:%s would be added to \"%s\" scope", (Object[])new Object[]{dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getScope()});
        }
    }

    private Collection<Dependency> artifacts(Path file) {
        LinkedList<Dependency> artifacts = new LinkedList<Dependency>();
        try {
            String xpath = "//meta[head='rt' and part[1]='jvm']/part[2]/text()";
            for (String coords : new XMLDocument(file).xpath("//meta[head='rt' and part[1]='jvm']/part[2]/text()")) {
                String[] parts = coords.split(":");
                Dependency dep = new Dependency();
                dep.setGroupId(parts[0]);
                dep.setArtifactId(parts[1]);
                dep.setVersion(parts[2]);
                dep.setClassifier("");
                dep.setType("jar");
                dep.setScope("compile");
                artifacts.add(dep);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(String.format("Can't pull %s into %s", file, this.targetDir), ex);
        }
        return artifacts;
    }

    private static final class Wrap
    implements Comparable<Wrap> {
        private final Dependency dependency;

        private Wrap(Dependency dep) {
            this.dependency = dep;
        }

        public Dependency dep() {
            return this.dependency;
        }

        @Override
        public int compareTo(Wrap wrap) {
            return Wrap.toStr(this.dependency).compareTo(Wrap.toStr(wrap.dependency));
        }

        public boolean equals(Object wrap) {
            return Wrap.toStr(this.dependency).equals(Wrap.toStr(((Wrap)Wrap.class.cast((Object)wrap)).dependency));
        }

        public int hashCode() {
            return Wrap.toStr(this.dependency).hashCode();
        }

        private static String toStr(Dependency dep) {
            return String.format("%s:%s:%s", dep.getGroupId(), dep.getArtifactId(), dep.getVersion());
        }
    }
}

