/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.eolang.AtAbsent;
import org.eolang.AtNamed;
import org.eolang.AtSimple;
import org.eolang.Attr;
import org.eolang.Phi;
import org.eolang.XmirObject;

public abstract class PhDefault
implements Phi,
Cloneable {
    private static final String REPLACEMENT = "\n  ";
    private static final Pattern SORTABLE = Pattern.compile("^[a-z].*$");
    private Map<String, Attr> attrs;
    private final List<String> order;
    private final ConcurrentMap<String, Phi> cached = new ConcurrentHashMap<String, Phi>(1);

    public PhDefault() {
        this(Phi.\u03a6);
    }

    public PhDefault(Phi sigma) {
        this.attrs = new HashMap<String, Attr>(0);
        this.order = new ArrayList<String>(0);
        this.add("\u03c1", new AtSimple(sigma));
        this.add("\u03c3", new AtSimple(sigma));
    }

    @Override
    public String \u03c6Term() {
        ArrayList<String> list = new ArrayList<String>(this.attrs.size());
        for (Map.Entry<String, Attr> ent : this.attrs.entrySet()) {
            String attr;
            if (!SORTABLE.matcher(ent.getKey()).matches() || (attr = String.format("%s \u21a6 %s", ent.getKey(), ent.getValue().\u03c6Term())).endsWith("\u03bb")) continue;
            list.add(attr);
        }
        String txt = this.getClass().getSimpleName();
        XmirObject xmir = this.getClass().getAnnotation(XmirObject.class);
        if (xmir != null && "@".equals(txt = xmir.oname())) {
            txt = "\u03c6";
        }
        if (!list.isEmpty()) {
            txt = String.format("%s\u27e6%s\u27e7", txt, String.join((CharSequence)", ", list));
        }
        return txt;
    }

    public String toString() {
        ArrayList<String> list = new ArrayList<String>(this.attrs.size());
        list.add(String.format("_order=%s", this.order));
        for (Map.Entry<String, Attr> ent : this.attrs.entrySet()) {
            int idx = this.order.indexOf(ent.getKey());
            list.add(String.format("%s%s=%s", ent.getKey(), idx >= 0 ? String.format("(%d)", idx) : "", ent.getValue().toString().replace("\n", REPLACEMENT)));
        }
        return String.format("%s#%d:{\n  %s\n}", this.getClass().getCanonicalName(), this.hashCode(), String.join((CharSequence)REPLACEMENT, list));
    }

    @Override
    public final Phi copy() {
        return this.copy(this.attrs.get("\u03c1"));
    }

    @Override
    public final Phi copy(Phi rho) {
        return this.copy(new AtSimple(rho));
    }

    @Override
    public final Attr attr(int pos) {
        if (pos < 0) {
            throw new Attr.IllegalAttrException(String.format("Attribute position can't be negative (%d)", pos));
        }
        if (this.order.isEmpty()) {
            throw new Attr.IllegalAttrException(String.format("There are no attributes here, can't get the %d-th one", pos));
        }
        int idx = pos >= this.order.size() ? this.order.size() - 1 : pos;
        return this.attr(this.order.get(idx));
    }

    @Override
    public final Attr attr(String name) {
        Attr attr = this.attrs.get(name);
        if (attr == null) {
            Attr phi = this.attrs.get("\u03c6");
            if (phi == null) {
                attr = new AtAbsent(name, String.format(" among other %d attrs (%s) and \u03c6 is absent", this.attrs.size(), String.join((CharSequence)", ", this.attrs.keySet())));
            } else {
                this.cached.computeIfAbsent("\u03c6", x -> phi.get());
                Phi base = (Phi)this.cached.get("\u03c6");
                Phi ret = base.attr(name).copy(base).get();
                if ("\u0394".equals(name)) {
                    this.cached.remove("\u03c6");
                }
                return new AtSimple(ret.copy(this));
            }
        }
        return this.named(attr, name);
    }

    protected final void add(String name, Attr attr) {
        if (SORTABLE.matcher(name).matches()) {
            this.order.add(name);
        }
        this.attrs.put(name, attr);
    }

    private Attr named(Attr attr, String name) {
        return new AtNamed(String.format("%s#%s", this.getClass().getCanonicalName(), name), String.format("%s.%s", this.oname(), name), this, attr);
    }

    private String oname() {
        String txt = this.getClass().getSimpleName();
        XmirObject xmir = this.getClass().getAnnotation(XmirObject.class);
        if (xmir != null && "@".equals(txt = xmir.oname())) {
            txt = "\u03c6";
        }
        return txt;
    }

    private Phi copy(Attr rho) {
        try {
            PhDefault copy = (PhDefault)PhDefault.class.cast(this.clone());
            HashMap<String, Attr> map = new HashMap<String, Attr>(this.attrs.size());
            for (Map.Entry<String, Attr> ent : this.attrs.entrySet()) {
                if ("\u03c1".equals(ent.getKey())) continue;
                map.put(ent.getKey(), ent.getValue().copy(copy));
            }
            map.put("\u03c1", rho);
            copy.attrs = map;
            return copy;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

