/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.eolang.Bytes;

public final class BytesOf
implements Bytes {
    private final byte[] data;

    public BytesOf(byte[] data) {
        this.data = data;
    }

    public BytesOf(String str) {
        this(str.getBytes(StandardCharsets.UTF_8));
    }

    public BytesOf(long number) {
        this(ByteBuffer.allocate(8).putLong(number).array());
    }

    public BytesOf(Double number) {
        this(ByteBuffer.allocate(8).putDouble(number).array());
    }

    @Override
    public Bytes not() {
        byte[] copy = this.take();
        for (int index = 0; index < copy.length; ++index) {
            copy[index] = ~copy[index];
        }
        return new BytesOf(copy);
    }

    @Override
    public Bytes and(Bytes other) {
        byte[] first = this.take();
        byte[] second = (byte[])other.take();
        for (int index = 0; index < Math.min(first.length, second.length); ++index) {
            first[index] = (byte)(first[index] & second[index]);
        }
        return new BytesOf(first);
    }

    @Override
    public Bytes or(Bytes other) {
        byte[] first = this.take();
        byte[] second = (byte[])other.take();
        for (int index = 0; index < Math.min(first.length, second.length); ++index) {
            first[index] = (byte)(first[index] | second[index]);
        }
        return new BytesOf(first);
    }

    @Override
    public Bytes xor(Bytes other) {
        byte[] first = this.take();
        byte[] second = (byte[])other.take();
        for (int index = 0; index < Math.min(first.length, second.length); ++index) {
            first[index] = (byte)(first[index] ^ second[index]);
        }
        return new BytesOf(first);
    }

    @Override
    public Bytes shift(int bits) {
        byte[] bytes = this.take();
        int mod = Math.abs(bits) % 8;
        int offset = Math.abs(bits) / 8;
        if (bits < 0) {
            byte carry = (byte)((1 << mod) - 1);
            for (int index = 0; index < bytes.length; ++index) {
                int source = index + offset;
                if (source >= bytes.length) {
                    bytes[index] = 0;
                    continue;
                }
                byte dst = (byte)(bytes[source] << mod);
                if (source + 1 < bytes.length) {
                    dst = (byte)(dst | bytes[source + 1] >>> 8 - mod & carry);
                }
                bytes[index] = dst;
            }
        } else {
            byte carry = (byte)(255 << 8 - mod);
            for (int index = bytes.length - 1; index >= 0; --index) {
                int source = index - offset;
                if (source < 0) {
                    bytes[index] = 0;
                    continue;
                }
                byte dst = (byte)((0xFF & bytes[source]) >>> mod);
                if (source - 1 >= 0) {
                    dst = (byte)(dst | bytes[source - 1] << 8 - mod & carry);
                }
                bytes[index] = dst;
            }
        }
        return new BytesOf(bytes);
    }

    @Override
    public <T extends Number> T asNumber(Class<T> type) {
        Number res;
        byte[] ret = this.take();
        ByteBuffer buf = ByteBuffer.wrap(ret);
        if (Long.class.equals(type) && ret.length == 8) {
            res = buf.getLong();
        } else if (Integer.class.equals(type) && ret.length == 4) {
            res = buf.getLong();
        } else if (Double.class.equals(type) && ret.length == 8) {
            res = buf.getDouble();
        } else {
            throw new UnsupportedOperationException(String.format("Unsupported conversion to '%s' for %d bytes", type, ret.length));
        }
        return (T)((Number)type.cast(res));
    }

    @Override
    public byte[] take() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    public String toString() {
        return String.format("BytesOf{%s}", Arrays.toString(this.data));
    }

    public boolean equals(Object other) {
        boolean result = this == other ? true : (other instanceof Bytes ? Arrays.equals(this.data, (byte[])((Bytes)other).take()) : false);
        return result;
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }
}

