/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eolang.Data;
import org.eolang.Phi;

public final class Dataized {
    private static final Logger LOGGER = Logger.getLogger(Dataized.class.getName());
    private static final ThreadLocal<Integer> LEVEL = ThreadLocal.withInitial(() -> 0);
    private static final ThreadLocal<Integer> MAX_LEVEL = ThreadLocal.withInitial(() -> Integer.getInteger("max.dataization.log", 3));
    private final Phi phi;

    public Dataized(Phi src) {
        this.phi = src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object take() {
        int before = LEVEL.get();
        LEVEL.set(before + 1);
        try {
            Phi src = this.phi;
            if (!(src instanceof Data) && !((src = src.attr("\u0394").get()) instanceof Data)) {
                throw new IllegalStateException(String.format("The attribute \u0394 of %s has %s instead of %s", this.phi.getClass().getCanonicalName(), src.getClass().getCanonicalName(), Data.class.getCanonicalName()));
            }
            Object data = ((Data)Data.class.cast(src)).take();
            if (LOGGER.isLoggable(Level.FINE) && LEVEL.get() <= MAX_LEVEL.get()) {
                LOGGER.log(Level.FINE, String.format("%s\ud835\udd3b( <%s>%s ) \u279c %s", String.join((CharSequence)"", Collections.nCopies(before, "\u00b7")), this.phi.location(), this.phi.toString().replaceAll("[\n\t]", ""), new Data.Value(data).toString().replaceAll("[\n\t]", "")));
            }
            Object t = data;
            return t;
        }
        finally {
            LEVEL.set(before);
        }
    }

    public <T> T take(Class<T> type) {
        return type.cast(this.take());
    }
}

