/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.eolang.Phi;

final class Vertices {
    private final AtomicInteger count = new AtomicInteger();
    private final ConcurrentHashMap<String, Integer> seen = new ConcurrentHashMap(0);

    Vertices() {
    }

    public int next() {
        return this.seen.computeIfAbsent(String.format("next:%d", this.count.addAndGet(1)), key -> this.count.addAndGet(1));
    }

    public int best(Object obj) {
        int best = obj instanceof Phi[] ? this.next() : this.bestNonPhi(obj);
        return best;
    }

    private synchronized int bestNonPhi(Object obj) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
        digest.update(String.format("%s %s", obj.getClass().getName(), Vertices.label(obj)).getBytes());
        String hash = new String(digest.digest());
        return this.seen.computeIfAbsent(hash, key -> this.count.addAndGet(1));
    }

    private static String label(Object obj) {
        String label;
        if (Vertices.primitive(obj)) {
            label = obj.toString();
        } else if (obj instanceof Pattern) {
            label = ((Pattern)Pattern.class.cast(obj)).pattern();
        } else if (obj instanceof byte[]) {
            label = Arrays.toString((byte[])byte[].class.cast(obj));
        } else {
            throw new IllegalArgumentException(String.format("Unknown type for vertex allocation: %s", obj.getClass().getCanonicalName()));
        }
        return label;
    }

    private static boolean primitive(Object obj) {
        return Vertices.numeric(obj) || Vertices.literal(obj) || obj instanceof Boolean;
    }

    private static boolean literal(Object obj) {
        return obj instanceof String || obj instanceof Character;
    }

    private static boolean numeric(Object obj) {
        return obj instanceof Long || obj instanceof Double;
    }
}

