/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.eolang.AtSimple;
import org.eolang.Attr;
import org.eolang.ExFailure;
import org.eolang.JavaPath;
import org.eolang.Phi;

final class PhPackage
implements Phi {
    private final String pkg;
    private final Map<String, Phi> objects = new ConcurrentHashMap<String, Phi>(0);

    PhPackage(String name) {
        this.pkg = name;
    }

    @Override
    public Attr attr(String name) {
        String obj = this.eoPackage(name);
        return new AtSimple(this.objects.computeIfAbsent(new JavaPath(obj).toString(), t -> this.loadPhi((String)t).orElseGet(() -> new PhPackage(obj))));
    }

    @Override
    public String locator() {
        return "?:?";
    }

    public String toString() {
        return String.format("\u03a6.%s", this.pkg);
    }

    @Override
    public String \u03c6Term() {
        return String.format("\u03a6.%s", this.pkg);
    }

    @Override
    public Attr attr(int pos) {
        throw new ExFailure(String.format("Can't #attr(%d) from package object '%s'", pos, this.pkg), new Object[0]);
    }

    @Override
    public Phi copy() {
        throw new ExFailure(String.format("Can't #copy() package object '%s'", this.pkg), new Object[0]);
    }

    private String eoPackage(String name) {
        StringBuilder abs = new StringBuilder(0).append(this.pkg);
        if (abs.length() > 0) {
            abs.append('.');
        }
        abs.append(name);
        return abs.toString();
    }

    private Optional<Phi> loadPhi(String target) {
        Optional<Phi> res;
        try {
            Phi kid = (Phi)Class.forName(target).getConstructor(Phi.class).newInstance(Phi.\u03a6);
            kid.attr("\u03c1").put(this);
            res = Optional.of(kid);
        }
        catch (ClassNotFoundException notfound) {
            res = Optional.empty();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new ExFailure(String.format("Can't find Java object/package '%s' in EO package '%s'", target, this.pkg), ex);
        }
        return res;
    }
}

