/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eolang.BytesOf;
import org.eolang.Data;
import org.eolang.ExFailure;
import org.eolang.Phi;
import org.eolang.Versionized;

@Versionized
public final class Dataized {
    private static final ThreadLocal<Integer> LEVEL = ThreadLocal.withInitial(() -> 0);
    private static final ThreadLocal<Integer> MAX_LEVEL = ThreadLocal.withInitial(() -> Integer.getInteger("max.dataization.log", 3));
    private final Phi phi;
    private final Logger logger;

    public Dataized(Phi src) {
        this(src, Logger.getLogger(Dataized.class.getName()));
    }

    public Dataized(Phi src, Logger log) {
        this.phi = src;
        this.logger = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] take() {
        int before = LEVEL.get();
        LEVEL.set(before + 1);
        try {
            Phi src = this.phi;
            if (!(src instanceof Data) && !((src = src.attr("\u0394").get()) instanceof Data)) {
                throw new IllegalStateException(String.format("The attribute \u0394 of %s has %s instead of %s", this.phi.getClass().getCanonicalName(), src.getClass().getCanonicalName(), Data.class.getCanonicalName()));
            }
            Object data = ((Data)Data.class.cast(src)).take();
            if (!(data instanceof byte[])) {
                throw new ExFailure("data of %s must be %s, but was %s", this.phi.toString(), byte[].class, data.getClass());
            }
            if (this.logger.isLoggable(Level.FINE) && LEVEL.get() <= MAX_LEVEL.get()) {
                this.logger.log(Level.FINE, String.format("%s\ud835\udd3b( <%s>%s ) \u279c %s", String.join((CharSequence)"", Collections.nCopies(before, "\u00b7")), this.phi.locator(), this.phi.toString().replaceAll("[\n\t]", ""), new Data.Value(data).toString().replaceAll("[\n\t]", "")));
            }
            byte[] byArray = (byte[])data;
            return byArray;
        }
        finally {
            LEVEL.set(before);
        }
    }

    public <T> T take(Class<T> type) {
        Object strong;
        byte[] weak = this.take();
        if (type.equals(Long.class)) {
            strong = new BytesOf(weak).asNumber(Long.class);
        } else if (type.equals(Double.class)) {
            strong = new BytesOf(weak).asNumber(Double.class);
        } else if (type.equals(byte[].class)) {
            strong = weak;
        } else if (type.equals(String.class)) {
            strong = new String(weak, StandardCharsets.UTF_8);
        } else if (weak.length == 1 && type.equals(Boolean.class)) {
            strong = weak[0] == 1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        } else {
            throw new IllegalArgumentException(String.format("Unknown type: %s", type.getCanonicalName()));
        }
        return type.cast(strong);
    }

    public static void cleanUp() {
        LEVEL.remove();
        MAX_LEVEL.remove();
    }
}

