/*
 * Decompiled with CFR 0.152.
 */
package EOorg.EOeolang.EOtxt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eolang.Atom;
import org.eolang.Data;
import org.eolang.Dataized;
import org.eolang.ExFailure;
import org.eolang.PhDefault;
import org.eolang.PhVoid;
import org.eolang.Phi;
import org.eolang.XmirObject;

@XmirObject(oname="sscanf")
public final class EOsscanf
extends PhDefault
implements Atom {
    private static final Map<Character, Function<String, Phi>> CONVERSION = new HashMap<Character, Function<String, Phi>>();
    private static final char PERCENT = '%';

    public EOsscanf() {
        this.add("format", new PhVoid("format"));
        this.add("read", new PhVoid("read"));
    }

    @Override
    public Phi lambda() {
        String format = new Dataized(this.take("format")).asString();
        StringBuilder regex = new StringBuilder();
        boolean literal = false;
        for (int idx = 0; idx < format.length(); ++idx) {
            char sym = format.charAt(idx);
            if (sym == '%') {
                if (literal) {
                    regex.append('%');
                    literal = false;
                    continue;
                }
                literal = true;
                continue;
            }
            if (literal) {
                switch (sym) {
                    case 'd': {
                        regex.append("(\\d+)");
                        break;
                    }
                    case 'f': {
                        regex.append("([+-]?\\d+(?:\\.\\d+)?)");
                        break;
                    }
                    case 's': {
                        regex.append("(\\S+)");
                        break;
                    }
                    default: {
                        throw new ExFailure("Unsupported format specifier: '%%%c'", Character.valueOf(sym));
                    }
                }
                literal = false;
                continue;
            }
            regex.append(Pattern.quote(String.valueOf(sym)));
        }
        Matcher matcher = Pattern.compile(regex.toString()).matcher(new Dataized(this.take("read")).asString());
        String frmt = format;
        ArrayList<Phi> output = new ArrayList<Phi>(0);
        if (matcher.find()) {
            int idx;
            int index = 1;
            while ((idx = frmt.indexOf(37)) != -1) {
                char sym = frmt.charAt(idx + 1);
                if (sym != '%') {
                    output.add(EOsscanf.converted(sym, matcher.group(index)));
                    ++index;
                }
                frmt = frmt.substring(idx + 2);
            }
        }
        return new Data.ToPhi(output.toArray(new Phi[0]));
    }

    private static Phi converted(char symbol, String str) {
        if (!CONVERSION.containsKey(Character.valueOf(symbol))) {
            throw new ExFailure(String.format("The format %c is unsupported, only %s formats can be used", Character.valueOf(symbol), "%s, %d, %f"), new Object[0]);
        }
        return CONVERSION.get(Character.valueOf(symbol)).apply(str);
    }

    static {
        CONVERSION.put(Character.valueOf('s'), Data.ToPhi::new);
        CONVERSION.put(Character.valueOf('d'), str -> new Data.ToPhi(Long.parseLong(str)));
        CONVERSION.put(Character.valueOf('f'), str -> new Data.ToPhi(Double.parseDouble(str)));
    }
}

