/*
 * Decompiled with CFR 0.152.
 */
package EOorg.EOeolang.EOtxt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eolang.Data;
import org.eolang.Dataized;
import org.eolang.ExFailure;
import org.eolang.Phi;

final class SprintfArgs {
    private static final Map<Character, Function<Dataized, Object>> CONVERSION = new HashMap<Character, Function<Dataized, Object>>();
    private static final char PERCENT = '%';
    private final String format;
    private final long length;
    private final Phi retriever;

    SprintfArgs(String fmt, long len, Phi phi) {
        this.format = fmt;
        this.length = len;
        this.retriever = phi;
    }

    public List<Object> formatted() {
        ArrayList<Object> arguments = new ArrayList<Object>(0);
        Matcher matcher = Pattern.compile("%(\\d+\\$)?([a-zA-Z%])").matcher(this.format);
        long auto = 0L;
        while (matcher.find()) {
            String positional = matcher.group(1);
            char symbol = matcher.group(2).charAt(0);
            if (symbol == '%') continue;
            long arg = positional != null ? Long.parseLong(positional.substring(0, positional.length() - 1)) - 1L : auto++;
            if (arg >= this.length) {
                throw new ExFailure(String.format("The argument index %d is out of bounds (total arguments: %d)", arg, this.length), new Object[0]);
            }
            Phi taken = this.retriever.copy();
            taken.put(0, (Phi)new Data.ToPhi(arg));
            arguments.add(SprintfArgs.fmt(symbol, new Dataized(taken)));
        }
        return arguments;
    }

    private static Object fmt(char symbol, Dataized element) {
        if (!CONVERSION.containsKey(Character.valueOf(symbol))) {
            throw new ExFailure(String.format("The format %c is unsupported, only %s formats can be used", Character.valueOf(symbol), "%s, %d, %f, %x, %b"), new Object[0]);
        }
        return CONVERSION.get(Character.valueOf(symbol)).apply(element);
    }

    private static String bytesToHex(byte[] bytes) {
        StringJoiner out = new StringJoiner("-");
        for (byte bty : bytes) {
            out.add(String.format("%02X", bty));
        }
        return out.toString();
    }

    static {
        CONVERSION.put(Character.valueOf('s'), Dataized::asString);
        CONVERSION.put(Character.valueOf('d'), element -> element.asNumber().longValue());
        CONVERSION.put(Character.valueOf('f'), Dataized::asNumber);
        CONVERSION.put(Character.valueOf('x'), element -> SprintfArgs.bytesToHex(element.take()));
        CONVERSION.put(Character.valueOf('b'), Dataized::asBool);
    }
}

