/*
 * Decompiled with CFR 0.152.
 */
package EOorg.EOeolang;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import org.eolang.ExFailure;
import org.eolang.Phi;

final class Heaps {
    static final Heaps INSTANCE = new Heaps();
    private final ConcurrentHashMap<Integer, byte[]> blocks = new ConcurrentHashMap(0);

    private Heaps() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int malloc(Phi phi, int size) {
        int identifier = phi.hashCode();
        ConcurrentHashMap<Integer, byte[]> concurrentHashMap = this.blocks;
        synchronized (concurrentHashMap) {
            if (this.blocks.containsKey(identifier)) {
                throw new ExFailure(String.format("Can't allocate block in memory with identifier '%d' because it's already allocated", identifier), new Object[0]);
            }
            this.blocks.put(identifier, new byte[size]);
        }
        return identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int size(int identifier) {
        ConcurrentHashMap<Integer, byte[]> concurrentHashMap = this.blocks;
        synchronized (concurrentHashMap) {
            if (!this.blocks.containsKey(identifier)) {
                throw new ExFailure(String.format("Block in memory by identifier '%d' is not allocated, can't get size", identifier), new Object[0]);
            }
            return this.blocks.get(identifier).length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resize(int identifier, int size) {
        if (size < 0) {
            throw new ExFailure(String.format("Can't change size of block in memory by identifier '%d' to negative '%d'", identifier, size), new Object[0]);
        }
        ConcurrentHashMap<Integer, byte[]> concurrentHashMap = this.blocks;
        synchronized (concurrentHashMap) {
            if (!this.blocks.containsKey(identifier)) {
                throw new ExFailure(String.format("Block in memory by identifier '%d' is not allocated, can't get size", identifier), new Object[0]);
            }
            byte[] bytes = this.blocks.get(identifier);
            byte[] resized = new byte[size];
            System.arraycopy(bytes, 0, resized, 0, Math.min(bytes.length, size));
            this.blocks.put(identifier, resized);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] read(int identifier, int offset, int length) {
        ConcurrentHashMap<Integer, byte[]> concurrentHashMap = this.blocks;
        synchronized (concurrentHashMap) {
            if (!this.blocks.containsKey(identifier)) {
                throw new ExFailure(String.format("Block in memory by identifier '%d' is not allocated, can't read", identifier), new Object[0]);
            }
            byte[] bytes = this.blocks.get(identifier);
            if (offset + length > bytes.length) {
                throw new ExFailure(String.format("Can't read '%d' bytes from offset '%d', because only '%d' are allocated", length, offset, bytes.length), new Object[0]);
            }
            return Arrays.copyOfRange(bytes, offset, offset + length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(int identifier, int offset, byte[] data) {
        ConcurrentHashMap<Integer, byte[]> concurrentHashMap = this.blocks;
        synchronized (concurrentHashMap) {
            if (!this.blocks.containsKey(identifier)) {
                throw new ExFailure(String.format("Can't read a block in memory with identifier '%d' because it's not allocated", identifier), new Object[0]);
            }
            byte[] current = this.blocks.get(identifier);
            int length = current.length;
            if (length < offset + data.length) {
                throw new ExFailure(String.format("Can't write '%d' bytes with offset '%d' to the block with identifier '%d', because only '%d' were allocated", data.length, offset, identifier, length), new Object[0]);
            }
            byte[] result = new byte[length];
            if (offset > 0) {
                System.arraycopy(current, 0, result, 0, offset);
            }
            System.arraycopy(data, 0, result, offset, data.length);
            if (length > offset + data.length) {
                System.arraycopy(current, offset + data.length, result, offset + data.length, length - offset - data.length);
            }
            this.blocks.put(identifier, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void free(int identifier) {
        ConcurrentHashMap<Integer, byte[]> concurrentHashMap = this.blocks;
        synchronized (concurrentHashMap) {
            if (!this.blocks.containsKey(identifier)) {
                throw new ExFailure(String.format("Can't free a block in memory with identifier '%d' because it's not allocated", identifier), new Object[0]);
            }
            this.blocks.remove(identifier);
        }
    }
}

