/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.eolang.Bytes;
import org.eolang.BytesRaw;

public final class BytesOf
implements Bytes {
    private final Bytes bytes;

    public BytesOf(String str) {
        this(str.getBytes(StandardCharsets.UTF_8));
    }

    public BytesOf(int number) {
        this(ByteBuffer.allocate(4).putInt(number).array());
    }

    public BytesOf(char chr) {
        this(ByteBuffer.allocate(2).putChar(chr).array());
    }

    public BytesOf(long number) {
        this(ByteBuffer.allocate(8).putLong(number).array());
    }

    public BytesOf(double number) {
        this(ByteBuffer.allocate(8).putDouble(number).array());
    }

    public BytesOf(byte[] data) {
        this(new BytesRaw(Arrays.copyOf(data, data.length)));
    }

    public BytesOf(Bytes bytes) {
        this.bytes = bytes;
    }

    @Override
    public Bytes not() {
        return this.bytes.not();
    }

    @Override
    public Bytes and(Bytes other) {
        return this.bytes.and(other);
    }

    @Override
    public Bytes or(Bytes other) {
        return this.bytes.or(other);
    }

    @Override
    public Bytes xor(Bytes other) {
        return this.bytes.xor(other);
    }

    @Override
    public Bytes shift(int bits) {
        return this.bytes.shift(bits);
    }

    @Override
    public Bytes sshift(int bits) {
        return this.bytes.sshift(bits);
    }

    @Override
    public Double asNumber() {
        return this.bytes.asNumber();
    }

    @Override
    public <T extends Number> T asNumber(Class<T> type) {
        return this.bytes.asNumber(type);
    }

    @Override
    public String asString() {
        return this.bytes.asString();
    }

    @Override
    public byte[] take() {
        return this.bytes.take();
    }

    public String toString() {
        return this.bytes.toString();
    }

    public boolean equals(Object other) {
        return this.bytes.equals(other);
    }

    public int hashCode() {
        return this.bytes.hashCode();
    }
}

