/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.eolang.Bytes;
import org.eolang.BytesOf;
import org.eolang.ExFailure;

final class BytesRaw
implements Bytes {
    private final byte[] data;

    BytesRaw(byte[] data) {
        this.data = Arrays.copyOf(data, data.length);
    }

    @Override
    public Bytes not() {
        byte[] copy = this.take();
        for (int index = 0; index < copy.length; ++index) {
            copy[index] = ~copy[index];
        }
        return new BytesOf(copy);
    }

    @Override
    public Bytes and(Bytes other) {
        byte[] first = this.take();
        byte[] second = other.take();
        for (int index = 0; index < Math.min(first.length, second.length); ++index) {
            first[index] = (byte)(first[index] & second[index]);
        }
        return new BytesOf(first);
    }

    @Override
    public Bytes or(Bytes other) {
        byte[] first = this.take();
        byte[] second = other.take();
        for (int index = 0; index < Math.min(first.length, second.length); ++index) {
            first[index] = (byte)(first[index] | second[index]);
        }
        return new BytesOf(first);
    }

    @Override
    public Bytes xor(Bytes other) {
        byte[] first = this.take();
        byte[] second = other.take();
        for (int index = 0; index < Math.min(first.length, second.length); ++index) {
            first[index] = (byte)(first[index] ^ second[index]);
        }
        return new BytesOf(first);
    }

    @Override
    public Bytes shift(int bits) {
        byte[] bytes = this.take();
        int mod = Math.abs(bits) % 8;
        int offset = Math.abs(bits) / 8;
        Bytes shifted = bits < 0 ? BytesRaw.shiftLeft(bytes, mod, offset) : BytesRaw.shiftRight(bytes, mod, offset);
        return shifted;
    }

    @Override
    public Bytes sshift(int bits) {
        if (bits < 0) {
            throw new UnsupportedOperationException("The \"right shift\" is NYI");
        }
        byte[] bytes = this.shift(bits).take();
        if (this.take()[0] < 0) {
            for (int index = 0; index < bytes.length; ++index) {
                byte zeros = BytesRaw.numberOfLeadingZeros(bytes[index]);
                bytes[index] = (byte)(bytes[index] & 0xFF ^ -1 << 8 - zeros);
                if (zeros != 8) break;
            }
        }
        return new BytesOf(bytes);
    }

    @Override
    public Double asNumber() {
        return this.asNumber(Double.class);
    }

    @Override
    public <T extends Number> T asNumber(Class<T> type) {
        Number res;
        byte[] ret = this.take();
        ByteBuffer buf = ByteBuffer.wrap(ret);
        if (Long.class.equals(type)) {
            res = BytesRaw.whenFit(buf, ret, Long.class).getLong();
        } else if (Integer.class.equals(type)) {
            res = BytesRaw.whenFit(buf, ret, Integer.class).getInt();
        } else if (Double.class.equals(type)) {
            res = BytesRaw.whenFit(buf, ret, Double.class).getDouble();
        } else if (Short.class.equals(type)) {
            res = BytesRaw.whenFit(buf, ret, Short.class).getShort();
        } else {
            throw new UnsupportedOperationException(String.format("Can't convert %d bytes to \"%s\"", ret.length, type.getCanonicalName()));
        }
        return (T)((Number)type.cast(res));
    }

    @Override
    public String asString() {
        StringBuilder out = new StringBuilder(0);
        for (byte bte : this.data) {
            if (out.length() > 0) {
                out.append('-');
            }
            out.append(String.format("%02X", bte));
        }
        if (this.data.length == 0) {
            out.append("--");
        }
        return out.toString();
    }

    @Override
    public byte[] take() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    public String toString() {
        return String.format("BytesOf{%s}", Arrays.toString(this.data));
    }

    public boolean equals(Object other) {
        boolean result = this == other ? true : (other instanceof Bytes ? Arrays.equals(this.data, ((Bytes)other).take()) : false);
        return result;
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    private static Bytes shiftLeft(byte[] bytes, int mod, int offset) {
        byte carry = (byte)((1 << mod) - 1);
        for (int index = 0; index < bytes.length; ++index) {
            int source = index + offset;
            if (source >= bytes.length) {
                bytes[index] = 0;
                continue;
            }
            byte dst = (byte)(bytes[source] << mod);
            if (source + 1 < bytes.length) {
                dst = (byte)(dst | (byte)(bytes[source + 1] >>> 8 - mod & (carry & 0xFF)));
            }
            bytes[index] = dst;
        }
        return new BytesOf(bytes);
    }

    private static Bytes shiftRight(byte[] bytes, int mod, int offset) {
        byte carry = (byte)(255 << 8 - mod);
        for (int index = bytes.length - 1; index >= 0; --index) {
            int source = index - offset;
            if (source < 0) {
                bytes[index] = 0;
                continue;
            }
            byte dst = (byte)((0xFF & bytes[source]) >>> mod);
            if (source - 1 >= 0) {
                dst = (byte)(dst | (byte)(bytes[source - 1] << 8 - mod & (carry & 0xFF)));
            }
            bytes[index] = dst;
        }
        return new BytesOf(bytes);
    }

    private static byte numberOfLeadingZeros(byte num) {
        byte result;
        if (num == 0) {
            result = 8;
        } else if (num < 0) {
            result = 0;
        } else {
            byte temp = num;
            int bts = 7;
            if (temp >= 16) {
                bts -= 4;
                temp = (byte)(temp >>> 4);
            }
            if (temp >= 4) {
                bts -= 2;
                temp = (byte)(temp >>> 2);
            }
            result = (byte)(bts - (temp >>> 1));
        }
        return result;
    }

    private static ByteBuffer whenFit(ByteBuffer buf, byte[] bytes, Class<?> type) {
        int expected;
        try {
            expected = type.getField("BYTES").getInt(null);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw new IllegalArgumentException(ex);
        }
        if (bytes.length != expected) {
            throw new ExFailure(String.format("Can't convert %d bytes to %s, exactly %d bytes expected", bytes.length, type.getName(), expected), new Object[0]);
        }
        return buf;
    }
}

