/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import java.util.function.Function;
import java.util.function.Supplier;
import org.eolang.Dataized;
import org.eolang.ExFailure;
import org.eolang.Phi;

public class Expect<T> {
    private final String subject;
    private final Supplier<T> sup;

    public Expect(String subj, Supplier<T> supplier) {
        this.subject = subj;
        this.sup = supplier;
    }

    public static Expect<Phi> at(Phi phi, String attr) {
        return new Expect<Phi>(String.format("the '%s' attribute", attr), () -> phi.take(attr));
    }

    public <R> Expect<R> that(Function<T, R> fun) {
        return new Expect<Object>(this.subject, () -> {
            try {
                return fun.apply(this.sup.get());
            }
            catch (ExFailure ex) {
                throw new ExThat(ex.getMessage(), new Object[]{ex});
            }
        });
    }

    public Expect<T> otherwise(String message) {
        return new Expect<Object>(this.subject, () -> {
            try {
                return this.sup.get();
            }
            catch (ExMust ex) {
                throw new ExOtherwise(String.format("%s %s %s", this.subject, ex.getMessage(), message), new Object[]{ex});
            }
            catch (ExThat ex) {
                throw new ExOtherwise(String.format("%s %s", this.subject, message), new Object[]{ex});
            }
        });
    }

    public Expect<T> must(Function<T, Boolean> fun) {
        return new Expect<Object>(this.subject, () -> {
            T ret = this.sup.get();
            if (!((Boolean)fun.apply(ret)).booleanValue()) {
                throw new ExMust(String.format("(%s)", ret), new Object[0]);
            }
            return ret;
        });
    }

    public T it() {
        try {
            return this.sup.get();
        }
        catch (ExOtherwise ex) {
            throw new ExFailure(ex.getMessage(), ex);
        }
    }

    public static final class Natural {
        private final Expect<Phi> expect;

        public Natural(Expect<Phi> expect) {
            this.expect = expect;
        }

        public Integer it() {
            return this.expect.that(phi -> new Dataized((Phi)phi).asNumber()).otherwise("must be a number").must(number -> number % 1.0 == 0.0).otherwise("must be an integer").that(Double::intValue).must(integer -> integer >= 0).otherwise("must be greater or equal to zero").it();
        }
    }

    public static final class Int {
        private final Expect<Phi> expect;

        public Int(Expect<Phi> expect) {
            this.expect = expect;
        }

        public Integer it() {
            return this.expect.that(phi -> new Dataized((Phi)phi).asNumber()).otherwise("must be a number").must(number -> number % 1.0 == 0.0).otherwise("must be an integer").that(Double::intValue).it();
        }
    }

    public static final class Number {
        private final Expect<Phi> expect;

        public Number(Expect<Phi> expect) {
            this.expect = expect;
        }

        public Double it() {
            return this.expect.that(phi -> new Dataized((Phi)phi).asNumber()).otherwise("must be a number").it();
        }
    }

    private static final class ExOtherwise
    extends RuntimeException {
        ExOtherwise(String cause, Object ... args) {
            super(String.format(cause, args));
        }
    }

    private static final class ExThat
    extends RuntimeException {
        ExThat(String cause, Object ... args) {
            super(String.format(cause, args));
        }
    }

    private static final class ExMust
    extends RuntimeException {
        ExMust(String cause, Object ... args) {
            super(String.format(cause, args));
        }
    }
}

