/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eolang.Data;
import org.eolang.Dataized;
import org.eolang.ExAbstract;
import org.eolang.Phi;
import org.eolang.VerboseBytesAsString;

public final class Main {
    private static final Logger LOGGER = Logger.getLogger(Main.class.getName());
    private static final Logger EOLOG = Logger.getLogger("org.eolang");

    private Main() {
    }

    public static void main(String ... args) throws Exception {
        Main.setup();
        ArrayList<String> opts = new ArrayList<String>(Arrays.asList(args));
        while (!opts.isEmpty()) {
            String opt = (String)opts.get(0);
            if (Main.parse(opt)) {
                return;
            }
            if (!opt.startsWith("--")) break;
            opts.remove(0);
        }
        LOGGER.log(Level.FINE, String.format("EOLANG Runtime %s", Main.version()));
        if (opts.isEmpty()) {
            throw new IllegalStateException("The name of an object is expected as a command line argument");
        }
        try {
            Main.run(opts);
        }
        catch (ExAbstract ex) {
            Main.print(ex);
            System.exit(1);
        }
    }

    private static void print(Throwable thr) {
        LOGGER.log(Level.SEVERE, thr.getMessage());
        Throwable cause = thr.getCause();
        if (cause != null) {
            Main.print(cause);
        }
    }

    private static void setup() {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new Formatter(){

            @Override
            public String format(LogRecord rec) {
                return String.format("%s%n", rec.getMessage());
            }
        });
        EOLOG.addHandler(handler);
        EOLOG.setUseParentHandlers(false);
    }

    private static boolean parse(String opt) throws IOException {
        if ("--verbose".equals(opt)) {
            EOLOG.setLevel(Level.FINE);
            for (Handler hnd : EOLOG.getHandlers()) {
                hnd.setLevel(Level.FINE);
            }
        }
        boolean exit = false;
        if ("--version".equals(opt)) {
            LOGGER.info(Main.version());
            exit = true;
        }
        if ("--help".equals(opt)) {
            LOGGER.info(String.join((CharSequence)"\n", "Usage: java -cp target/classes org.eolang.Main [option...] class [argument...]", "  class: Name of EO class, e.g. \"org.eolang.io.stdio\"", "  argument: Value that will be wrapped as strings and passed to your EO object", "  options:", "    --help     Print this documentation and exit", "    --version  Print the version of this JAR and exit", "    --verbose  Print all intermediate dataization results"));
            exit = true;
        }
        return exit;
    }

    private static void run(List<String> opts) {
        String obj = opts.get(0);
        if (obj.isEmpty()) {
            throw new IllegalArgumentException("The name of the object is an empty string, why?");
        }
        Phi app = Phi.\u03a6.take(obj);
        if (opts.size() > 1) {
            Phi args = Phi.\u03a6.take("org.eolang.tuple").take("empty");
            for (int idx = 1; idx < opts.size(); ++idx) {
                args = args.take("with");
                args.put(0, (Phi)new Data.ToPhi(opts.get(idx)));
            }
            app.put(0, args);
        }
        long start = System.currentTimeMillis();
        byte[] ret = new Dataized(app).take();
        LOGGER.info(String.format("%n---%n%s%nFinished in %.02fs (%d bytes)", new VerboseBytesAsString(ret).get(), (double)(System.currentTimeMillis() - start) / 1000.0, ret.length));
    }

    private static String version() throws IOException {
        try (BufferedReader input = new BufferedReader(new InputStreamReader(Objects.requireNonNull(Main.class.getResourceAsStream("version.txt")), StandardCharsets.UTF_8));){
            String string = input.lines().findFirst().orElse("N/A");
            return string;
        }
    }
}

