/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eolang.Atom;
import org.eolang.AtomSafe;
import org.eolang.ExFailure;
import org.eolang.ExReadOnly;
import org.eolang.ExUnset;
import org.eolang.PhRho;
import org.eolang.PhVoid;
import org.eolang.PhWithRho;
import org.eolang.Phi;
import org.eolang.XmirObject;

public class PhDefault
implements Phi,
Cloneable {
    private static final Logger LOGGER = Logger.getLogger(PhDefault.class.getName());
    private static final Pattern SORTABLE = Pattern.compile(String.format("^([a-z].*)|%s$", "\u03c6"));
    private static final ThreadLocal<Integer> NESTING = ThreadLocal.withInitial(() -> 0);
    private static final Pattern TO_FORMA = Pattern.compile("(^|\\.)EO");
    private final Optional<byte[]> data;
    private final Map<Integer, String> order;
    private Map<String, Phi> attrs;

    public PhDefault() {
        this(null);
    }

    public PhDefault(byte[] dta) {
        this.data = Optional.ofNullable(dta);
        this.attrs = PhDefault.defaults();
        this.order = new HashMap<Integer, String>(0);
    }

    public boolean equals(Object obj) {
        return obj instanceof Phi && this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        return super.hashCode() + 1;
    }

    @Override
    public final Phi copy() {
        try {
            PhDefault copy = (PhDefault)this.clone();
            HashMap<String, Phi> map = new HashMap<String, Phi>(this.attrs.size());
            for (Map.Entry<String, Phi> ent : this.attrs.entrySet()) {
                map.put(ent.getKey(), ent.getValue().copy(copy));
            }
            copy.attrs = map;
            return copy;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public boolean hasRho() {
        boolean has = true;
        try {
            this.attrs.get("\u03c1").take(0);
        }
        catch (ExUnset exception) {
            has = false;
        }
        return has;
    }

    @Override
    public void put(int pos, Phi object) {
        String name = this.attr(pos);
        if (!(((PhWithRho)this.attrs.get(name)).origin() instanceof PhVoid)) {
            throw new ExReadOnly(String.format("Can't put attribute with position %d because it's not void one", pos));
        }
        this.put(name, object);
    }

    @Override
    public void put(String name, Phi object) {
        if (!this.attrs.containsKey(name)) {
            throw new ExUnset(String.format("Can't #put(\"%s\", %s) to %s, because the attribute is absent", name, object, this));
        }
        this.attrs.get(name).put(name, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Phi take(String name) {
        NESTING.set(NESTING.get() + 1);
        try {
            Phi object;
            if (this.attrs.containsKey(name)) {
                object = this.attrs.get(name).take(0);
            } else if (name.equals("\u03bb")) {
                object = new AtomSafe(this).lambda();
            } else if (this instanceof Atom) {
                object = this.take("\u03bb").take(name);
            } else if (this.attrs.containsKey("\u03c6")) {
                object = this.take("\u03c6").take(name);
            } else {
                throw new ExUnset(String.format("Can't #take(\"%s\"), the attribute is absent among other %d attrs of %s:(%s), %s and %s are also absent", name, this.attrs.size(), this.forma(), String.join((CharSequence)", ", this.attrs.keySet()), "\u03c6", "\u03bb"));
            }
            PhDefault.debug(String.format("%s\ud835\udd38('%s' for %s) \u279c %s", PhDefault.padding(), name, this, object));
            Phi phi = object;
            return phi;
        }
        finally {
            int current = NESTING.get();
            if (current > 0) {
                NESTING.set(current - 1);
            } else {
                NESTING.set(0);
            }
        }
    }

    @Override
    public Phi take(int pos) {
        return this.take(this.attr(pos));
    }

    @Override
    public byte[] delta() {
        byte[] bytes;
        if (this.data.isPresent()) {
            bytes = this.data.get();
        } else if (this instanceof Atom) {
            bytes = this.take("\u03bb").delta();
        } else if (this.attrs.containsKey("\u03c6")) {
            bytes = this.take("\u03c6").delta();
        } else {
            throw new ExFailure(String.format("There's no \"\u0394\" in the object of \"%s\"", this.forma()), new Object[0]);
        }
        return bytes;
    }

    @Override
    public String locator() {
        return "?";
    }

    @Override
    public String forma() {
        String name = this.oname();
        String form = PhDefault.class.getSimpleName().equals(name) ? "[]" : String.join((CharSequence)".", "\u03a6", TO_FORMA.matcher(this.getClass().getPackageName()).replaceAll("$1"), name);
        return form;
    }

    @Override
    public Phi copy(Phi self) {
        return this.copy();
    }

    public final void add(String name, Phi attr) {
        if (SORTABLE.matcher(name).matches()) {
            this.order.put(this.order.size(), name);
        }
        this.attrs.put(name, new PhWithRho(attr, this));
    }

    private String attr(int pos) {
        if (0 > pos) {
            throw new ExFailure(String.format("The attribute position can't be negative (%d)", pos), new Object[0]);
        }
        if (this.order.isEmpty()) {
            throw new ExFailure(String.format("There are no attributes here, can't read the %d-th one", pos), new Object[0]);
        }
        if (!this.order.containsKey(pos)) {
            throw new ExFailure(String.format("%s has just %d attribute(s), can't read the %d-th one", this, this.order.size(), pos), new Object[0]);
        }
        return this.order.get(pos);
    }

    private String oname() {
        String txt = this.getClass().getSimpleName();
        XmirObject xmir = this.getClass().getAnnotation(XmirObject.class);
        if (null != xmir && "@".equals(txt = xmir.oname())) {
            txt = "\u03c6";
        }
        return txt;
    }

    private static Map<String, Phi> defaults() {
        HashMap<String, Phi> attrs = new HashMap<String, Phi>(0);
        attrs.put("\u03c1", new PhRho());
        return attrs;
    }

    private static void debug(String msg) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, msg);
        }
    }

    private static String padding() {
        return String.join((CharSequence)"", Collections.nCopies(NESTING.get(), "\u00b7"));
    }
}

