/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import EOorg.EOeolang.EOerror;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.eolang.Atom;
import org.eolang.AtomSafe;
import org.eolang.Data;
import org.eolang.ExAbstract;
import org.eolang.Phi;

public final class PhSafe
implements Phi,
Atom {
    private final Phi origin;
    private final String program;
    private final int line;
    private final int position;
    private final String location;
    private final String oname;

    public PhSafe(Phi phi) {
        this(phi, "unknown", 0, 0);
    }

    public PhSafe(Phi phi, String prg, int lne, int pos) {
        this(phi, prg, lne, pos, "?", "?");
    }

    public PhSafe(Phi phi, String prg, int lne, int pos, String loc, String oname) {
        this.origin = phi;
        this.program = prg;
        this.line = lne;
        this.position = pos;
        this.location = loc;
        this.oname = oname;
    }

    public boolean equals(Object obj) {
        return this.origin.equals(obj);
    }

    public int hashCode() {
        return this.origin.hashCode();
    }

    @Override
    public Phi copy() {
        return new PhSafe(this.origin.copy(), this.program, this.line, this.position, this.location, this.oname);
    }

    @Override
    public boolean hasRho() {
        return this.through(this.origin::hasRho);
    }

    @Override
    public Phi take(String name) {
        return this.through(() -> this.origin.take(name));
    }

    @Override
    public Phi take(int pos) {
        return this.through(() -> this.origin.take(pos));
    }

    @Override
    public void put(int pos, Phi object) {
        this.through(() -> this.origin.put(pos, object));
    }

    @Override
    public void put(String nme, Phi object) {
        this.through(() -> this.origin.put(nme, object));
    }

    @Override
    public String locator() {
        return String.format("%s:%d:%d", this.location, this.line, this.position);
    }

    @Override
    public String forma() {
        return String.join((CharSequence)".", this.getClass().getPackageName(), this.oname);
    }

    @Override
    public Phi copy(Phi self) {
        return this.copy();
    }

    @Override
    public byte[] delta() {
        return this.through(this.origin::delta, ".\u0394");
    }

    @Override
    public Phi lambda() {
        return this.through(new AtomSafe(this.origin)::lambda, ".\u03bb");
    }

    private void through(Runnable action) {
        this.through(() -> {
            action.run();
            return true;
        }, "");
    }

    private <T> T through(Supplier<T> action) {
        return this.through(action, "");
    }

    private <T> T through(Supplier<T> action, String suffix) {
        try {
            return action.get();
        }
        catch (EOerror.ExError ex) {
            throw new EOerror.ExError(ex, this.label(suffix));
        }
        catch (ExAbstract ex) {
            throw new EOerror.ExError((Phi)new Data.ToPhi(ex.getMessage()), this.label(suffix));
        }
        catch (Throwable ex) {
            throw new EOerror.ExError((Phi)new Data.ToPhi(ex.getMessage()), PhSafe.trace(ex, this.label(suffix)));
        }
    }

    private static List<String> trace(Throwable exp, String head) {
        StackTraceElement[] stack = exp.getStackTrace();
        LinkedList<String> trace = new LinkedList<String>();
        if (stack != null) {
            for (StackTraceElement elm : stack) {
                trace.add(String.format("%s#%s():%d", PhSafe.shorter(elm.getClassName()), elm.getMethodName(), elm.getLineNumber()));
            }
        }
        trace.add(String.format("%s (%s)", head, PhSafe.shorter(exp.getClass().getName())));
        return trace;
    }

    private static String shorter(String full) {
        return full.replaceAll("(.)[^.]*\\.", "$1.");
    }

    private String label(String suffix) {
        return String.format("Error in \"%s%s\" at %s:%d:%d", this.location, suffix, this.program, this.line, this.position);
    }
}

