/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.phi;

import EOorg.EOeolang.EOarray;
import EOorg.EOeolang.EObool;
import EOorg.EOeolang.EOchar;
import EOorg.EOeolang.EOfloat;
import EOorg.EOeolang.EOint;
import EOorg.EOeolang.EOregex;
import EOorg.EOeolang.EOstring;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.eolang.phi.PhDefault;
import org.eolang.phi.PhEta;
import org.eolang.phi.PhOnce;
import org.eolang.phi.PhWith;
import org.eolang.phi.Phi;

public interface Data<T> {
    public T take();

    public static final class Value<T>
    extends PhDefault
    implements Data<T> {
        private final T val;

        public Value(T value) {
            super(new PhEta());
            this.val = value;
        }

        @Override
        public String toString() {
            String txt = this.val instanceof String ? String.format("\"%s\"", this.val.toString()) : (this.val.getClass().isArray() ? Arrays.toString((Object[])this.val) : this.val.toString());
            return txt;
        }

        @Override
        public T take() {
            return this.val;
        }
    }

    public static final class ToPhi
    extends PhOnce {
        public ToPhi(Object obj) {
            super(() -> {
                EObool phi;
                if (obj instanceof Boolean) {
                    phi = new EObool();
                } else if (obj instanceof Long) {
                    phi = new EOint();
                } else if (obj instanceof String) {
                    phi = new EOstring();
                } else if (obj instanceof Character) {
                    phi = new EOchar();
                } else if (obj instanceof Double) {
                    phi = new EOfloat();
                } else if (obj instanceof Pattern) {
                    phi = new EOregex();
                } else if (obj instanceof Phi[]) {
                    phi = new EOarray();
                } else {
                    throw new IllegalArgumentException(String.format("Unknown type of data: %s", obj.getClass().getCanonicalName()));
                }
                return new PhWith((Phi)phi, "\u0394", new Value<Object>(obj));
            });
        }
    }

    public static final class Once<T>
    implements Data<T> {
        private final Data<T> src;
        private final AtomicReference<T> ref;

        public Once(Data<T> data) {
            this.src = data;
            this.ref = new AtomicReference();
        }

        public String toString() {
            return this.take().toString();
        }

        @Override
        public T take() {
            if (this.ref.get() == null) {
                this.ref.set(this.src.take());
            }
            return this.ref.get();
        }
    }
}

