/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

import com.jcabi.xml.ClasspathSources;
import com.jcabi.xml.Sources;
import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import com.jcabi.xml.XSL;
import com.jcabi.xml.XSLDocument;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.cactoos.Input;
import org.cactoos.Text;
import org.cactoos.io.ResourceOf;
import org.cactoos.text.IoCheckedText;
import org.cactoos.text.TextOf;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;
import org.eolang.lints.Severity;

final class LintByXsl
implements Lint {
    private final String rule;
    private final XSL sheet;
    private final Input doc;

    LintByXsl(Input xsl, Input motive) throws IOException {
        XMLDocument xml = new XMLDocument(new IoCheckedText((Text)new TextOf(xsl)).asString());
        this.rule = (String)xml.xpath("/xsl:stylesheet/@id").get(0);
        this.sheet = new XSLDocument((XML)xml, this.rule).with((Sources)new ClasspathSources());
        this.doc = motive;
    }

    LintByXsl(String xsl) throws IOException {
        this((Input)new ResourceOf((CharSequence)String.format("org/eolang/lints/%s.xsl", xsl)), (Input)new ResourceOf((CharSequence)String.format("org/eolang/motives/%s.md", xsl)));
    }

    @Override
    public Collection<Defect> defects(XML xmir) {
        XML report = this.sheet.transform(LintByXsl.sanitized(xmir));
        LinkedList<Defect> defects = new LinkedList<Defect>();
        for (XML defect : report.nodes("/defects/defect")) {
            List severity = defect.xpath("@severity");
            if (severity.isEmpty()) {
                throw new IllegalStateException(String.format("No severity reported by %s", this.rule));
            }
            defects.add(new Defect.Default(this.rule, Severity.parsed((String)severity.get(0)), this.lineno(defect), (String)defect.xpath("text()").get(0)));
        }
        return defects;
    }

    @Override
    public String motive() throws Exception {
        return new TextOf(this.doc).asString();
    }

    private static XML sanitized(XML xmir) {
        String[] paths;
        for (String xpath : paths = new String[]{"/program/metas/meta[not(@line) or @line='']"}) {
            if (xmir.nodes(xpath).isEmpty()) continue;
            throw new IllegalArgumentException(String.format("There is something wrong with the XMIR, found '%s':%n%s", xpath, xmir));
        }
        return xmir;
    }

    private int lineno(XML defect) {
        int lineno;
        List lines = defect.xpath("@line");
        if (lines.isEmpty()) {
            throw new IllegalStateException(String.format("No line number reported by %s", this.rule));
        }
        String line = (String)lines.get(0);
        if (line.isEmpty()) {
            throw new IllegalStateException(String.format("Empty line number reported by %s", this.rule));
        }
        try {
            lineno = Integer.parseInt(line);
        }
        catch (NumberFormatException ex) {
            throw new IllegalStateException(String.format("Wrong line number reported by %s: '%s'", this.rule, lines.get(0)), ex);
        }
        return lineno;
    }
}

