/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints.comments;

import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import org.cactoos.Input;
import org.cactoos.io.ResourceOf;
import org.cactoos.text.TextOf;
import org.eolang.lints.Defect;
import org.eolang.lints.Lint;
import org.eolang.lints.Severity;

public final class AsciiOnly
implements Lint {
    @Override
    public Collection<Defect> defects(XML xmir) throws IOException {
        LinkedList<Defect> defects = new LinkedList<Defect>();
        for (XML comment : xmir.nodes("/program/comments/comment")) {
            Optional<Character> abusive = ((String)comment.xpath("text()").get(0)).chars().filter(chr -> chr < 32 || chr > 127).mapToObj(chr -> Character.valueOf((char)chr)).findFirst();
            if (!abusive.isPresent()) continue;
            String line = (String)comment.xpath("@line").get(0);
            Character chr2 = abusive.get();
            defects.add(new Defect.Default("ascii-only", Severity.ERROR, Integer.parseInt(line), String.format("Only ASCII characters are allowed in comments, while '%s' is used at the %sth line at the %sth position", chr2, line, ((String)comment.xpath("text()").get(0)).indexOf(chr2.charValue()) + 1)));
        }
        return defects;
    }

    @Override
    public String motive() throws Exception {
        return new TextOf((Input)new ResourceOf((CharSequence)"org/eolang/motives/comments/ascii-only.md")).asString();
    }
}

