/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.lints;

public enum Severity {
    CRITICAL("critical"),
    ERROR("error"),
    WARNING("warning");

    private final String name;

    private Severity(String txt) {
        this.name = txt;
    }

    public String mnemo() {
        return this.name;
    }

    public static Severity parsed(String text) {
        Severity severity;
        if (CRITICAL.mnemo().equals(text)) {
            severity = CRITICAL;
        } else if (ERROR.mnemo().equals(text)) {
            severity = ERROR;
        } else if (WARNING.mnemo().equals(text)) {
            severity = WARNING;
        } else {
            throw new IllegalArgumentException(String.format("Can't parse '%s'", text));
        }
        return severity;
    }
}

